/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.common.dakimakura.pack;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import moe.plushie.dakimakuramod.DakimakuraMod;
import moe.plushie.dakimakuramod.common.dakimakura.Daki;
import moe.plushie.dakimakuramod.common.dakimakura.DakiManager;
import moe.plushie.dakimakuramod.common.dakimakura.pack.IDakiPack;

public abstract class AbstractDakiPack
implements IDakiPack {
    protected final DakiManager dakiManager = DakimakuraMod.getProxy().getDakimakuraManager();
    private final String resourceName;
    protected final LinkedHashMap<String, Daki> dakiMap;

    protected AbstractDakiPack(String resourceName) {
        this.resourceName = resourceName;
        this.dakiMap = new LinkedHashMap();
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public int getDakiCount() {
        return this.dakiMap.size();
    }

    @Override
    public Daki getDaki(String dakiDirName) {
        return this.dakiMap.get(this.getResourceName() + ":" + dakiDirName);
    }

    @Override
    public void addDaki(Daki daki) {
        this.dakiMap.put(this.getResourceName() + ":" + daki.getDakiDirectoryName(), daki);
    }

    @Override
    public ArrayList<Daki> getDakisInPack() {
        ArrayList<Daki> dakiList = new ArrayList<Daki>();
        for (Daki daki : this.dakiMap.values()) {
            dakiList.add(daki);
        }
        return dakiList;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.resourceName == null ? 0 : this.resourceName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDakiPack other = (AbstractDakiPack)obj;
        return !(this.resourceName == null ? other.resourceName != null : !this.resourceName.equals(other.resourceName));
    }
}

