/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.common.dakimakura;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import moe.plushie.dakimakuramod.DakimakuraMod;
import moe.plushie.dakimakuramod.common.config.ConfigHandler;
import moe.plushie.dakimakuramod.common.dakimakura.Daki;
import moe.plushie.dakimakuramod.common.dakimakura.DakiImageData;
import moe.plushie.dakimakuramod.common.dakimakura.DakiSendHelper;
import net.minecraft.entity.player.EntityPlayerMP;

public class DakiTextureManagerCommon
implements Runnable {
    private final Cache<Daki, DakiImageData> dakiImageCache = CacheBuilder.newBuilder().expireAfterAccess((long)ConfigHandler.cacheTimeServer, TimeUnit.MINUTES).build();
    private final ArrayList<WaitingClient> waitingClients = new ArrayList();
    private final ArrayList<Daki> dakiLoadQueue = new ArrayList();
    private volatile Thread threadTextureManager = null;

    public void serverStarted() {
        this.threadTextureManager = new Thread((Runnable)this, "Dakimakura Mod texture manager thread");
        this.threadTextureManager.start();
    }

    public void serverStopped() {
        this.threadTextureManager = null;
    }

    @Override
    public void run() {
        Thread thisThread = Thread.currentThread();
        DakimakuraMod.getLogger().info("Starting texture manager thread.");
        while (this.threadTextureManager == thisThread) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.processDakiQueue();
        }
        DakimakuraMod.getLogger().info("Stopped texture manager thread.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDakiQueue() {
        Daki loadDaki = null;
        ArrayList<Daki> arrayList = this.dakiLoadQueue;
        synchronized (arrayList) {
            if (this.dakiLoadQueue.size() > 0) {
                loadDaki = this.dakiLoadQueue.get(0);
            }
        }
        if (loadDaki != null) {
            this.loadDakiTextures(loadDaki);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDakiTextures(Daki daki) {
        DakiImageData imageData = new DakiImageData(daki);
        Object object = this.dakiImageCache;
        synchronized (object) {
            this.dakiImageCache.put((Object)daki, (Object)imageData);
        }
        object = this.dakiLoadQueue;
        synchronized (object) {
            this.dakiLoadQueue.remove(daki);
        }
        this.checkAndSendToClients();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Cache<Daki, DakiImageData> cache = this.dakiImageCache;
        synchronized (cache) {
            return this.dakiImageCache.asMap().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.dakiImageCache;
        synchronized (object) {
            this.dakiImageCache.asMap().clear();
        }
        object = this.dakiLoadQueue;
        synchronized (object) {
            this.dakiLoadQueue.clear();
        }
        object = this.waitingClients;
        synchronized (object) {
            this.waitingClients.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClientRequestTexture(EntityPlayerMP playerEntity, Daki daki) {
        Cache<Daki, DakiImageData> cache = this.dakiImageCache;
        synchronized (cache) {
            if (this.dakiImageCache.asMap().containsKey(daki)) {
                this.sendTextureToClient(playerEntity, daki, (DakiImageData)this.dakiImageCache.getIfPresent((Object)daki));
            } else {
                ArrayList<Object> arrayList = this.waitingClients;
                synchronized (arrayList) {
                    this.waitingClients.add(new WaitingClient(playerEntity, daki));
                }
                arrayList = this.dakiLoadQueue;
                synchronized (arrayList) {
                    if (!this.dakiLoadQueue.contains(daki)) {
                        this.dakiLoadQueue.add(daki);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAndSendToClients() {
        Cache<Daki, DakiImageData> cache = this.dakiImageCache;
        synchronized (cache) {
            ArrayList<WaitingClient> arrayList = this.waitingClients;
            synchronized (arrayList) {
                for (int i = 0; i < this.waitingClients.size(); ++i) {
                    WaitingClient waitingClient = this.waitingClients.get(i);
                    DakiImageData imageData = (DakiImageData)this.dakiImageCache.getIfPresent((Object)waitingClient.getDaki());
                    if (imageData == null) continue;
                    this.sendTextureToClient(waitingClient.getPlayerEntity(), waitingClient.getDaki(), imageData);
                    this.waitingClients.remove(i);
                }
            }
        }
    }

    private void sendTextureToClient(EntityPlayerMP playerEntity, Daki daki, DakiImageData imageData) {
        DakiSendHelper.sendDakiTexturesToClient(playerEntity, daki, imageData);
    }

    public static class WaitingClient {
        private EntityPlayerMP playerEntity;
        private Daki daki;

        public WaitingClient(EntityPlayerMP playerEntity, Daki daki) {
            this.playerEntity = playerEntity;
            this.daki = daki;
        }

        public EntityPlayerMP getPlayerEntity() {
            return this.playerEntity;
        }

        public Daki getDaki() {
            return this.daki;
        }
    }
}

