/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.common.dakimakura;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import moe.plushie.dakimakuramod.common.dakimakura.Daki;
import moe.plushie.dakimakuramod.common.dakimakura.pack.DakiPackFolder;
import moe.plushie.dakimakuramod.common.dakimakura.pack.DakiPackZipFile;
import moe.plushie.dakimakuramod.common.dakimakura.pack.IDakiPack;
import moe.plushie.dakimakuramod.common.network.PacketHandler;
import moe.plushie.dakimakuramod.common.network.message.server.MessageServerSendDakiList;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class DakiManager {
    private static final String PACK_FOLDER_NAME = "dakimakura-mod";
    private final File packFolder;
    private final HashMap<String, IDakiPack> dakiPacksMap;

    public DakiManager(File file) {
        this.packFolder = new File(file, PACK_FOLDER_NAME);
        this.dakiPacksMap = new HashMap();
    }

    public void loadPacks(boolean sendToClients) {
        this.dakiPacksMap.clear();
        for (File file : this.packFolder.listFiles()) {
            String resourceName = file.getAbsolutePath().substring(this.packFolder.getAbsolutePath().length() + 1, file.getAbsolutePath().length());
            if (file.isDirectory()) {
                this.dakiPacksMap.put(resourceName, new DakiPackFolder(resourceName).loadPack());
            }
            if (!(file.isFile() & file.getName().endsWith(".zip"))) continue;
            this.dakiPacksMap.put(resourceName, new DakiPackZipFile(resourceName).loadPack());
        }
        if (sendToClients) {
            this.sendDakiListToClients();
        }
    }

    public Daki getDakiFromMap(String packDirName, String dakiDirName) {
        IDakiPack dakiPack = this.dakiPacksMap.get(packDirName);
        if (dakiPack != null) {
            return dakiPack.getDaki(dakiDirName);
        }
        return null;
    }

    public ArrayList<IDakiPack> getDakiPacksList() {
        ArrayList<IDakiPack> packsList = new ArrayList<IDakiPack>();
        for (IDakiPack dakiPack : this.dakiPacksMap.values()) {
            packsList.add(dakiPack);
        }
        return packsList;
    }

    public ArrayList<Daki> getDakiList() {
        ArrayList<Daki> dakimakuraList = new ArrayList<Daki>();
        for (IDakiPack dakiPack : this.dakiPacksMap.values()) {
            dakimakuraList.addAll(dakiPack.getDakisInPack());
        }
        Collections.sort(dakimakuraList);
        return dakimakuraList;
    }

    public void setDakiList(ArrayList<IDakiPack> packs) {
        this.dakiPacksMap.clear();
        for (IDakiPack pack : packs) {
            this.dakiPacksMap.put(pack.getResourceName(), pack);
        }
    }

    public ArrayList<Daki> getDakisInPack(String packName) {
        IDakiPack dakiPack = this.dakiPacksMap.get(packName);
        if (dakiPack != null) {
            return dakiPack.getDakisInPack();
        }
        return new ArrayList<Daki>();
    }

    public int getDakiIndexInPack(Daki daki) {
        ArrayList<Daki> packList = this.getDakisInPack(daki.getPackDirectoryName());
        for (int i = 0; i < packList.size(); ++i) {
            if (!daki.equals(packList.get(i))) continue;
            return i;
        }
        return -1;
    }

    public IDakiPack getDakiPack(String packName) {
        return this.dakiPacksMap.get(packName);
    }

    public File getPackFolder() {
        return this.packFolder;
    }

    private void sendDakiListToClients() {
        PacketHandler.NETWORK_WRAPPER.sendToAll((IMessage)new MessageServerSendDakiList());
    }
}

