/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.common.dakimakura;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import moe.plushie.dakimakuramod.DakimakuraMod;
import moe.plushie.dakimakuramod.common.config.ConfigHandler;
import org.apache.commons.io.IOUtils;

public final class DakiExtractor {
    private static final String DAKI_ASSETS_LOCATION = "assets/dakimakuramod/dakis/";
    private static final String[] README_LIST = new String[]{"en_GB", "de_DE"};
    private static final String DAKI_PACK_ANDREWS = "Andrew's Vanilla Mobs";
    private static final String[] DAKI_PACK_ANDREWS_LIST = new String[]{"Alex", "Bat", "Blaze", "CaveSpider", "Chicken", "Cow", "Cow2", "Creeper", "Enderman", "Ghast", "Horse", "IronGolem", "Magmacube", "MooshroomCow", "MooshroomCow2", "Ocelot", "Pig", "Sheep", "Sheep2", "Silverfish", "Skeleton", "Slime", "Snowman", "Spider", "Squid", "Steve", "Villager", "Witch", "WitherSkeleton", "Wolf", "Zombie", "ZombiePigman"};

    private DakiExtractor() {
    }

    public static void extractDakis() {
        File oldReadme;
        File packFolder = DakimakuraMod.getProxy().getDakimakuraManager().getPackFolder();
        if (packFolder.exists() && !ConfigHandler.hasUpdated) {
            return;
        }
        if (!packFolder.exists()) {
            packFolder.mkdirs();
        }
        if ((oldReadme = new File(packFolder, "readme.txt")).exists()) {
            try {
                oldReadme.delete();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DakiExtractor.extractReadmeFiles(packFolder);
        DakiExtractor.extractDakiPack(packFolder, DAKI_PACK_ANDREWS, DAKI_PACK_ANDREWS_LIST);
    }

    private static void extractReadmeFiles(File packFolder) {
        for (String langCode : README_LIST) {
            String readmeName = "readme_" + langCode + ".txt";
            DakiExtractor.extractResource(readmeName, new File(packFolder, readmeName), true);
        }
    }

    private static void extractDakiPack(File packFolder, String packName, String[] packFiles) {
        if (!(packFolder = new File(packFolder, packName)).exists() && !packFolder.mkdir()) {
            DakimakuraMod.getLogger().error("Failed to make pack folder.");
            return;
        }
        DakiExtractor.extractResource(packName + "/pack-info.json", new File(packFolder, "pack-info.json"), true);
        for (int i = 0; i < packFiles.length; ++i) {
            DakiExtractor.extractDaki(packFolder, packName, packFiles[i]);
        }
    }

    private static void extractDaki(File packFolder, String packName, String name) {
        DakiExtractor.extractDaki(packFolder, packName, name, "daki-info.json", "front.png", "back.png");
    }

    private static void extractDaki(File packFolder, String packName, String name, String ... files) {
        File dakiFolder = new File(packFolder, name);
        if (!dakiFolder.exists()) {
            dakiFolder.mkdir();
        }
        for (int i = 0; i < files.length; ++i) {
            DakiExtractor.extractResource(packName + "/" + name + "/" + files[i], new File(dakiFolder, files[i]), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractResource(String source, File target, boolean overwrite) {
        block10: {
            if (target.exists()) {
                if (overwrite) {
                    target.delete();
                } else {
                    return;
                }
            }
            InputStream input = null;
            FileOutputStream output = null;
            try {
                DakimakuraMod.getLogger().info(String.format("Extracting file '%s' to '%s'.", source, target.getAbsolutePath()));
                input = DakiExtractor.class.getClassLoader().getResourceAsStream(DAKI_ASSETS_LOCATION + source);
                if (input != null) {
                    output = new FileOutputStream(target);
                    IOUtils.copy((InputStream)input, (OutputStream)output);
                    output.flush();
                } else {
                    DakimakuraMod.getLogger().error(String.format("Error extracting file '%s'.", source));
                }
                IOUtils.closeQuietly((InputStream)input);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block10;
            }
            finally {
                IOUtils.closeQuietly(input);
                IOUtils.closeQuietly(output);
            }
            IOUtils.closeQuietly((OutputStream)output);
        }
    }
}

