/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.common.config;

import java.io.File;
import moe.plushie.dakimakuramod.DakimakuraMod;
import moe.plushie.dakimakuramod.common.lib.LibModInfo;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class ConfigHandler {
    public static final String CATEGORY_RECIPE = "recipe";
    public static final String CATEGORY_LOOT = "loot";
    public static final String CATEGORY_CLIENT = "client";
    public static final String CATEGORY_SERVER = "server";
    public static final String CATEGORY_OTHER = "other";
    private static final String LANG_KEY_PREFIX = "config.dakimakuramod:";
    public static Configuration config;
    public static boolean enableRecipe;
    public static boolean useAltRecipe;
    public static boolean enableRecycleRecipe;
    public static boolean enableClearingRecipe;
    public static boolean addUnlockToLootChests;
    public static float mobDropChance;
    public static float mobDropLootingBonus;
    public static int textureMaxSize;
    public static int dakiRenderDist;
    public static int cacheTimeClient;
    public static int cacheTimeServer;
    public static String lastVersion;
    public static boolean hasUpdated;

    public ConfigHandler(File file) {
        if (config == null) {
            config = new Configuration(file, "1");
            this.loadConfigFile();
        }
        this.checkIfUpdated();
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals("dakimakuramod")) {
            this.loadConfigFile();
        }
    }

    public void checkIfUpdated() {
        String localVersion = "1.12.2-1.5";
        if (LibModInfo.isDevelopmentVersion()) {
            return;
        }
        try {
            if (this.versionCompare(lastVersion.replaceAll("-", "."), localVersion.replaceAll("-", ".")) < 0) {
                DakimakuraMod.getLogger().info(String.format("Updated from version %s to version %s.", lastVersion, localVersion));
                config.getCategory(CATEGORY_OTHER).get("lastVersion").set(localVersion);
                if (config.hasChanged()) {
                    config.save();
                }
                hasUpdated = true;
            } else {
                hasUpdated = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            hasUpdated = true;
        }
    }

    public void loadConfigFile() {
        this.loadCategoryCommon();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            this.loadCategoryClient(config.getCategory(CATEGORY_CLIENT));
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    private void loadCategoryCommon() {
        this.loadCategoryRecipe(config.getCategory(CATEGORY_RECIPE));
        this.loadCategoryLoot(config.getCategory(CATEGORY_LOOT));
        this.loadCategoryServer(config.getCategory(CATEGORY_SERVER));
        lastVersion = config.getString("lastVersion", CATEGORY_OTHER, "0.0", "Used by the mod to check if it has been updated.");
    }

    private void loadCategoryRecipe(ConfigCategory category) {
        enableRecipe = config.getBoolean("enableRecipe", CATEGORY_RECIPE, true, "Enable the crafting recipe for dakimakuras.", "config.dakimakuramod:enableRecipe");
        category.get("enableRecipe").setRequiresMcRestart(true);
        useAltRecipe = config.getBoolean("useAltRecipe", CATEGORY_RECIPE, false, "Changes the crafting recipe from 6 wool to 3 wool and 6 string.", "config.dakimakuramod:useAltRecipe");
        category.get("useAltRecipe").setRequiresMcRestart(true);
        enableRecycleRecipe = config.getBoolean("enableRecycleRecipe", CATEGORY_RECIPE, true, "Allow getting a new dakimakura design by crafting 2 unwanted designs together.", "config.dakimakuramod:enableRecycleRecipe");
        category.get("enableRecycleRecipe").setRequiresMcRestart(true);
        enableClearingRecipe = config.getBoolean("enableClearingRecipe", CATEGORY_RECIPE, true, "Allow crafting a dakimakura to clear its design.", "config.dakimakuramod:enableClearingRecipe");
        category.get("enableClearingRecipe").setRequiresMcRestart(true);
    }

    private void loadCategoryLoot(ConfigCategory category) {
        addUnlockToLootChests = config.getBoolean("addUnlockToLootChests", CATEGORY_LOOT, false, "Add the dakimakura design items to loot chests around the world.", "config.dakimakuramod:addUnlockToLootChests");
        category.get("addUnlockToLootChests").setRequiresMcRestart(true);
        mobDropChance = config.getFloat("mobDropChance", CATEGORY_LOOT, 1.0f, 0.0f, 100.0f, "Percentage chance of mobs dropping a dakimakura design. 0 disables mob drops.", "config.dakimakuramod:mobDropChance");
        mobDropLootingBonus = config.getFloat("mobDropLootingBonus", CATEGORY_LOOT, 1.0f, 0.0f, 100.0f, "Extra bonus percentage chance of mobs dropping a dakimakura design for each level of looting.\nmobDropChance + (mobDropLootingBonus * lootingLevel)", "config.dakimakuramod:mobDropLootingBonus");
    }

    private void loadCategoryClient(ConfigCategory category) {
        textureMaxSize = config.getInt("textureMaxSize", CATEGORY_CLIENT, 1024, 32, 8192, "Max texture size for dakimakuras.\nThis will be rounded up to the nearest power of 2.\nWill be capped at the GPUs max texture size.", "config.dakimakuramod:textureMaxSize");
        dakiRenderDist = config.getInt("dakiRenderDist", CATEGORY_CLIENT, 64, 32, 256, "The maximum distance away in blocks dakimakuras will render.", "config.dakimakuramod:dakiRenderDist");
        dakiRenderDist *= dakiRenderDist;
        cacheTimeClient = config.getInt("cacheTime", CATEGORY_CLIENT, 20, 1, Integer.MAX_VALUE, "How long in minutes dakimakuras can be loaded into the clients memory without getting used.\nLower values will reduce memory use while higher values will reduce bandwidth usage.", "config.dakimakuramod:cacheTimeClient");
        category.get("cacheTime").setRequiresMcRestart(true);
    }

    private void loadCategoryServer(ConfigCategory category) {
        cacheTimeServer = config.getInt("cacheTime", CATEGORY_SERVER, 30, 1, Integer.MAX_VALUE, "How long in minutes dakimakuras can be loaded into the servers memory without getting used.\nLower values will reduce memory use while higher values will reduce disk access.", "config.dakimakuramod:cacheTimeServer");
        category.get("cacheTime").setRequiresMcRestart(true);
    }

    private int versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.split("\\.");
        String[] vals2 = str2.split("\\.");
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            int diff = Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i]));
            return Integer.signum(diff);
        }
        return Integer.signum(vals1.length - vals2.length);
    }
}

