/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.common.block;

import com.google.common.base.Predicate;
import java.util.Random;
import moe.plushie.dakimakuramod.common.block.AbstractModBlockContainer;
import moe.plushie.dakimakuramod.common.block.ModBlocks;
import moe.plushie.dakimakuramod.common.dakimakura.Daki;
import moe.plushie.dakimakuramod.common.dakimakura.serialize.DakiNbtSerializer;
import moe.plushie.dakimakuramod.common.items.block.ItemBlockDakimakura;
import moe.plushie.dakimakuramod.common.tileentities.TileEntityDakimakura;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockDakimakura
extends AbstractModBlockContainer {
    private static final int META_BIT_STANDING = 0;
    private static final int META_BIT_POS_NEG = 1;
    private static final int META_BIT_X_Z = 2;
    private static final int META_BIT_TOP_BOT = 3;
    public static final PropertyBool PROPERTY_STANDING = PropertyBool.func_177716_a((String)"standing");
    public static final PropertyDirection PROPERTY_DIRECTION = PropertyDirection.func_177712_a((String)"rotation", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final PropertyBool PROPERTY_TOP = PropertyBool.func_177716_a((String)"top");
    public static final PropertyBool PROPERTY_FLIPPED = PropertyBool.func_177716_a((String)"flipped");

    protected BlockDakimakura() {
        super("dakimakura", Material.field_151580_n, SoundType.field_185854_g, true);
        this.func_149711_c(1.0f);
        this.func_149713_g(0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)PROPERTY_DIRECTION, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)PROPERTY_STANDING, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)PROPERTY_TOP, (Comparable)Boolean.valueOf(false)));
        this.field_149785_s = true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{PROPERTY_DIRECTION, PROPERTY_STANDING, PROPERTY_TOP, PROPERTY_FLIPPED});
    }

    public int func_176201_c(IBlockState state) {
        boolean standing = (Boolean)state.func_177229_b((IProperty)PROPERTY_STANDING);
        EnumFacing rotation = (EnumFacing)state.func_177229_b((IProperty)PROPERTY_DIRECTION);
        boolean topPart = (Boolean)state.func_177229_b((IProperty)PROPERTY_TOP);
        int meta = 0;
        meta = BlockDakimakura.setStandingOnMeta(meta, standing);
        meta = BlockDakimakura.setRotationOnMeta(meta, rotation);
        meta = BlockDakimakura.setTopPartOnMeta(meta, topPart);
        return meta;
    }

    public IBlockState func_176203_a(int meta) {
        boolean standing = BlockDakimakura.isStanding(meta);
        EnumFacing rotation = BlockDakimakura.getRotation(meta);
        boolean topPart = BlockDakimakura.isTopPart(meta);
        IBlockState result = this.func_176194_O().func_177621_b();
        result = result.func_177226_a((IProperty)PROPERTY_STANDING, (Comparable)Boolean.valueOf(standing));
        result = result.func_177226_a((IProperty)PROPERTY_DIRECTION, (Comparable)rotation);
        result = result.func_177226_a((IProperty)PROPERTY_TOP, (Comparable)Boolean.valueOf(topPart));
        return result;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileEntity tileEntity;
        if (((Boolean)state.func_177229_b((IProperty)PROPERTY_TOP)).booleanValue()) {
            if (((Boolean)state.func_177229_b((IProperty)PROPERTY_STANDING)).booleanValue()) {
                pos = pos.func_177972_a(EnumFacing.DOWN);
            } else {
                EnumFacing rot = (EnumFacing)state.func_177229_b((IProperty)PROPERTY_DIRECTION);
                pos = pos.func_177972_a(rot.func_176734_d());
            }
        }
        if ((tileEntity = worldIn.func_175625_s(pos)) != null && tileEntity instanceof TileEntityDakimakura) {
            state = state.func_177226_a((IProperty)PROPERTY_FLIPPED, (Comparable)Boolean.valueOf(((TileEntityDakimakura)tileEntity).isFlipped()));
        }
        return state;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            TileEntity tileEntity;
            if (((Boolean)state.func_177229_b((IProperty)PROPERTY_TOP)).booleanValue()) {
                if (((Boolean)state.func_177229_b((IProperty)PROPERTY_STANDING)).booleanValue()) {
                    pos = pos.func_177972_a(EnumFacing.DOWN);
                } else {
                    EnumFacing rot = (EnumFacing)state.func_177229_b((IProperty)PROPERTY_DIRECTION);
                    pos = pos.func_177972_a(rot.func_176734_d());
                }
            }
            if (!worldIn.field_72995_K && (tileEntity = worldIn.func_175625_s(pos)) != null && tileEntity instanceof TileEntityDakimakura) {
                ((TileEntityDakimakura)tileEntity).flip();
            }
            return true;
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack itemStack) {
        TileEntity tileEntity = world.func_175625_s(pos);
        Daki daki = DakiNbtSerializer.deserialize(itemStack.func_77978_p());
        if (tileEntity != null && tileEntity instanceof TileEntityDakimakura) {
            ((TileEntityDakimakura)tileEntity).setDaki(daki);
            ((TileEntityDakimakura)tileEntity).setFlipped(ItemBlockDakimakura.isFlipped(itemStack));
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te;
        if (!world.field_72995_K && !((Boolean)state.func_177229_b((IProperty)PROPERTY_TOP)).booleanValue() && (te = world.func_175625_s(pos)) != null && te instanceof TileEntityDakimakura) {
            ItemStack itemStack = new ItemStack(ModBlocks.blockDakimakura);
            Daki daki = ((TileEntityDakimakura)te).getDaki();
            if (daki != null) {
                itemStack.func_77982_d(DakiNbtSerializer.serialize(daki));
                DakiNbtSerializer.setFlipped(itemStack.func_77978_p(), ((TileEntityDakimakura)te).isFlipped());
            }
            BlockDakimakura.spawnItemInWorld(world, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, itemStack);
        }
        super.func_180663_b(world, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World worldObj, RayTraceResult target, ParticleManager manager) {
        return true;
    }

    private static void spawnItemInWorld(World world, double x, double y, double z, ItemStack itemStack) {
        EntityItem entityItem = new EntityItem(world, x, y, z, itemStack);
        world.func_72838_d((Entity)entityItem);
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        Daki daki;
        ItemStack itemStack = new ItemStack((Block)this, 1, 0);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileEntity instanceof TileEntityDakimakura && (daki = ((TileEntityDakimakura)tileEntity).getDaki()) != null) {
            itemStack.func_77982_d(new NBTTagCompound());
            DakiNbtSerializer.serialize(daki, itemStack.func_77978_p());
        }
        return itemStack;
    }

    private static int getBit(int value, int index) {
        return value >> index & 1;
    }

    private static int setBit(int value, int index, boolean on) {
        if (on) {
            return value | 1 << index;
        }
        return value & ~(1 << index);
    }

    public static int setRotationOnMeta(int meta, EnumFacing rot) {
        if (rot == EnumFacing.NORTH | rot == EnumFacing.WEST) {
            meta = BlockDakimakura.setBit(meta, 1, false);
        } else if (rot == EnumFacing.SOUTH | rot == EnumFacing.EAST) {
            meta = BlockDakimakura.setBit(meta, 1, true);
        }
        if (rot == EnumFacing.EAST | rot == EnumFacing.WEST) {
            meta = BlockDakimakura.setBit(meta, 2, true);
        } else if (rot == EnumFacing.NORTH | rot == EnumFacing.SOUTH) {
            meta = BlockDakimakura.setBit(meta, 2, false);
        }
        return meta;
    }

    public static EnumFacing getRotation(int meta) {
        boolean posNeg;
        boolean xz = BlockDakimakura.getBit(meta, 2) == 1;
        boolean bl = posNeg = BlockDakimakura.getBit(meta, 1) == 1;
        if (posNeg) {
            if (xz) {
                return EnumFacing.EAST;
            }
            return EnumFacing.SOUTH;
        }
        if (xz) {
            return EnumFacing.WEST;
        }
        return EnumFacing.NORTH;
    }

    public static int setStandingOnMeta(int meta, boolean standing) {
        return BlockDakimakura.setBit(meta, 0, standing);
    }

    public static boolean isStanding(int meta) {
        return BlockDakimakura.getBit(meta, 0) == 1;
    }

    public static int setTopPartOnMeta(int meta, boolean topPart) {
        return BlockDakimakura.setBit(meta, 3, topPart);
    }

    public static boolean isTopPart(int meta) {
        return BlockDakimakura.getBit(meta, 3) == 1;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.getBoundingBox(state);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return this.getBoundingBox(blockState);
    }

    public AxisAlignedBB func_180640_a(IBlockState blockState, World worldIn, BlockPos pos) {
        return this.getBoundingBox(blockState).func_186670_a(pos);
    }

    public AxisAlignedBB getBoundingBox(IBlockState blockState) {
        boolean standing = (Boolean)blockState.func_177229_b((IProperty)PROPERTY_STANDING);
        EnumFacing rot = (EnumFacing)blockState.func_177229_b((IProperty)PROPERTY_DIRECTION);
        boolean topPart = (Boolean)blockState.func_177229_b((IProperty)PROPERTY_TOP);
        float w1 = 0.2f;
        float w2 = 0.8f;
        float h1 = 0.01f;
        float h2 = 0.28f;
        float d1 = 0.1f;
        float d2 = 1.8f;
        float x1 = w1;
        float x2 = w2;
        float y1 = h1;
        float y2 = h2;
        float z1 = d1;
        float z2 = d2;
        if (!standing) {
            switch (rot) {
                case NORTH: {
                    z1 = 1.0f - d2;
                    z2 = 1.0f - d1;
                    break;
                }
                case EAST: {
                    x1 = d1;
                    x2 = d2;
                    z1 = w1;
                    z2 = w2;
                    break;
                }
                case WEST: {
                    x1 = 1.0f - d2;
                    x2 = 1.0f - d1;
                    z1 = 1.0f - w2;
                    z2 = 1.0f - w1;
                    break;
                }
            }
        }
        if (standing) {
            y1 = d1;
            y2 = d2;
            switch (rot) {
                case SOUTH: {
                    z1 = 1.0f - h2;
                    z2 = 1.0f - h1;
                    break;
                }
                case NORTH: {
                    z1 = h1;
                    z2 = h2;
                    break;
                }
                case EAST: {
                    x1 = 1.0f - h2;
                    x2 = 1.0f - h1;
                    z1 = w1;
                    z2 = w2;
                    break;
                }
                case WEST: {
                    x1 = h1;
                    x2 = h2;
                    z1 = w1;
                    z2 = w2;
                    break;
                }
            }
        }
        if (!standing) {
            if (!topPart) {
                return new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
            }
            return new AxisAlignedBB((double)(x1 - 1.0f * (float)rot.func_82601_c()), (double)(y1 - 1.0f * (float)rot.func_96559_d()), (double)(z1 - 1.0f * (float)rot.func_82599_e()), (double)(x2 - 1.0f * (float)rot.func_82601_c()), (double)(y2 - 1.0f * (float)rot.func_96559_d()), (double)(z2 - 1.0f * (float)rot.func_82599_e()));
        }
        if (!topPart) {
            return new AxisAlignedBB((double)x1, (double)y1, (double)z1, (double)x2, (double)y2, (double)z2);
        }
        return new AxisAlignedBB((double)x1, (double)(y1 - 1.0f), (double)z1, (double)x2, (double)(y2 - 1.0f), (double)z2);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        IBlockState blockState = worldIn.func_180495_p(pos);
        boolean standing = (Boolean)blockState.func_177229_b((IProperty)PROPERTY_STANDING);
        EnumFacing rotation = (EnumFacing)blockState.func_177229_b((IProperty)PROPERTY_DIRECTION);
        boolean topPart = (Boolean)blockState.func_177229_b((IProperty)PROPERTY_TOP);
        if (!standing) {
            if (!topPart) {
                if (worldIn.func_180495_p(pos.func_177972_a(rotation)).func_177230_c() != this) {
                    worldIn.func_175698_g(pos);
                }
            } else if (worldIn.func_180495_p(pos.func_177972_a(rotation.func_176734_d())).func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            }
        } else if (!topPart) {
            if (worldIn.func_180495_p(pos.func_177972_a(EnumFacing.UP)).func_177230_c() != this) {
                worldIn.func_175698_g(pos);
            }
        } else if (worldIn.func_180495_p(pos.func_177972_a(EnumFacing.DOWN)).func_177230_c() != this) {
            worldIn.func_175698_g(pos);
        }
    }

    public TileEntity func_149915_a(World world, int p_149915_2_) {
        return new TileEntityDakimakura();
    }
}

