/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.client.texture;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.util.ArrayList;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import moe.plushie.dakimakuramod.client.texture.DakiTexture;
import moe.plushie.dakimakuramod.common.config.ConfigHandler;
import moe.plushie.dakimakuramod.common.dakimakura.Daki;
import moe.plushie.dakimakuramod.common.dakimakura.DakiImageData;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DakiTextureManagerClient
implements RemovalListener<Daki, DakiTexture> {
    private final Cache<Daki, DakiTexture> textureCache = CacheBuilder.newBuilder().removalListener((RemovalListener)this).expireAfterAccess((long)ConfigHandler.cacheTimeClient, TimeUnit.MINUTES).build();
    private final AtomicInteger textureRequests = new AtomicInteger(0);
    private final CompletionService<DakiImageData> textureCompletion = new ExecutorCompletionService<DakiImageData>(Executors.newFixedThreadPool(1));
    private final ArrayList<DakiTexture> textureCleanup = new ArrayList();

    public DakiTextureManagerClient() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public DakiTexture getTextureForDaki(Daki daki) {
        DakiTexture dakiTexture = null;
        dakiTexture = (DakiTexture)((Object)this.textureCache.getIfPresent((Object)daki));
        if (dakiTexture == null) {
            dakiTexture = new DakiTexture(daki);
            this.textureCache.put((Object)daki, (Object)dakiTexture);
        }
        return dakiTexture;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT & event.type == TickEvent.Type.CLIENT & event.phase == TickEvent.Phase.END) {
            this.textureCache.cleanUp();
            Future<DakiImageData> futureDakiImageData = this.textureCompletion.poll();
            if (futureDakiImageData != null) {
                try {
                    DakiTexture dakiTexture;
                    DakiImageData dakiImageData = futureDakiImageData.get();
                    if (dakiImageData != null && (dakiTexture = (DakiTexture)((Object)this.textureCache.getIfPresent((Object)dakiImageData.getDaki()))) != null) {
                        dakiTexture.setBufferedImageFull(dakiImageData.getBufferedImageFull());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.deleteTextures();
        }
    }

    public void reloadTextures() {
        this.textureCache.asMap().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTextures() {
        ArrayList<DakiTexture> arrayList = this.textureCleanup;
        synchronized (arrayList) {
            for (int i = 0; i < this.textureCleanup.size(); ++i) {
                DakiTexture texture = this.textureCleanup.get(i);
                if (texture == null) continue;
                texture.func_147631_c();
            }
            this.textureCleanup.clear();
        }
    }

    public AtomicInteger getTextureRequests() {
        return this.textureRequests;
    }

    public void serverSentTextures(DakiImageData imageData) {
        this.textureRequests.decrementAndGet();
        this.textureCompletion.submit(imageData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRemoval(RemovalNotification<Daki, DakiTexture> notification) {
        ArrayList<DakiTexture> arrayList = this.textureCleanup;
        synchronized (arrayList) {
            this.textureCleanup.add((DakiTexture)((Object)notification.getValue()));
        }
    }
}

