/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.client.texture;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import moe.plushie.dakimakuramod.DakimakuraMod;
import moe.plushie.dakimakuramod.client.texture.DakiTextureManagerClient;
import moe.plushie.dakimakuramod.common.dakimakura.Daki;
import moe.plushie.dakimakuramod.common.network.PacketHandler;
import moe.plushie.dakimakuramod.common.network.message.client.MessageClientRequestTextures;
import moe.plushie.dakimakuramod.proxies.ClientProxy;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class DakiTexture
extends AbstractTexture {
    private static long lastLoad;
    private boolean requested = false;
    private final Daki daki;
    private BufferedImage bufferedImageFull;

    public DakiTexture(Daki daki) {
        this.daki = daki;
    }

    public boolean isLoaded() {
        if (this.field_110553_a == -1) {
            if (lastLoad + 25L < System.currentTimeMillis()) {
                if (this.load()) {
                    lastLoad = System.currentTimeMillis();
                } else if (!this.requested) {
                    DakiTextureManagerClient textureManager = ((ClientProxy)DakimakuraMod.getProxy()).getDakiTextureManager();
                    int requests = textureManager.getTextureRequests().get();
                    if (requests < 2) {
                        textureManager.getTextureRequests().incrementAndGet();
                        if (this.daki != null) {
                            this.requested = true;
                            PacketHandler.NETWORK_WRAPPER.sendToServer((IMessage)new MessageClientRequestTextures(this.daki));
                        }
                    }
                } else if (this.bufferedImageFull != null) {
                    this.load();
                }
            }
            return false;
        }
        return true;
    }

    public void setBufferedImageFull(BufferedImage bufferedImageFull) {
        this.bufferedImageFull = bufferedImageFull;
    }

    protected void finalize() throws Throwable {
        this.func_147631_c();
        super.finalize();
    }

    private boolean load() {
        if (this.bufferedImageFull == null) {
            return false;
        }
        this.func_147631_c();
        try {
            int sizeW = this.bufferedImageFull.getWidth();
            int sizeH = this.bufferedImageFull.getHeight();
            TextureUtil.func_110989_a((int)this.func_110552_b(), (BufferedImage)this.bufferedImageFull, (boolean)false, (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private InputStream getMissingTexture() {
        return DakiTexture.class.getClassLoader().getResourceAsStream("assets/dakimakuramod/textures/models/missing.png");
    }

    public void func_110551_a(IResourceManager resourceManager) throws IOException {
    }
}

