/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.client.model;

import moe.plushie.dakimakuramod.DakimakuraMod;
import moe.plushie.dakimakuramod.client.model.ObjModel;
import moe.plushie.dakimakuramod.client.texture.DakiTexture;
import moe.plushie.dakimakuramod.client.texture.DakiTextureManagerClient;
import moe.plushie.dakimakuramod.common.dakimakura.Daki;
import moe.plushie.dakimakuramod.proxies.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ModelDakimakura
extends ModelBase {
    private static final String MODEL_PATH = "models/dakimakura.obj";
    private static final String MODEL_PATH_LOD = "models/dakimakura-lod-%d.obj";
    private static final ResourceLocation TEXTURE_BLANK = new ResourceLocation("dakimakuramod", "textures/models/blank.png");
    private final ObjModel DAKIMAKURA_MODEL = ObjModel.loadModel(new ResourceLocation("dakimakuramod", "models/dakimakura.obj"));
    private final ObjModel[] DAKIMAKURA_MODEL_LODS = new ObjModel[4];
    private final DakiTextureManagerClient dakiTextureManager;
    private final Profiler profiler;

    public ModelDakimakura(DakiTextureManagerClient dakiTextureManager) {
        for (int i = 0; i < this.DAKIMAKURA_MODEL_LODS.length; ++i) {
            this.DAKIMAKURA_MODEL_LODS[i] = ObjModel.loadModel(new ResourceLocation("dakimakuramod", String.format(MODEL_PATH_LOD, i + 1)));
        }
        this.dakiTextureManager = dakiTextureManager;
        this.profiler = Minecraft.func_71410_x().field_71424_I;
    }

    public void render(Daki daki, BlockPos pos) {
        double distance = Minecraft.func_71410_x().field_71439_g.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
        this.render(daki, distance);
    }

    public void render(Daki daki, double x, double y, double z) {
        double distance = Minecraft.func_71410_x().field_71439_g.func_70011_f(x, y, z);
        this.render(daki, distance);
    }

    public void render(Daki daki, double distance) {
        int lod = MathHelper.func_76128_c((double)(distance / 16.0));
        this.render(daki, lod);
    }

    public void render(Daki daki, int lod) {
        lod = MathHelper.func_76125_a((int)lod, (int)0, (int)4);
        this.profiler.func_76320_a("texture");
        if (daki == null) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE_BLANK);
        } else {
            DakiTexture dakiTexture = ((ClientProxy)DakimakuraMod.getProxy()).getDakiTextureManager().getTextureForDaki(daki);
            if (dakiTexture.isLoaded()) {
                GlStateManager.func_179144_i((int)dakiTexture.func_110552_b());
            } else {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE_BLANK);
            }
        }
        this.profiler.func_76318_c("model");
        GlStateManager.func_179117_G();
        GlStateManager.func_179094_E();
        GL11.glPushAttrib((int)8264);
        GlStateManager.func_179108_z();
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179089_o();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)0.55f, (float)0.55f, (float)0.55f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.35f, (float)0.0f);
        GlStateManager.func_179152_a((float)-1.0f, (float)-1.0f, (float)1.0f);
        GL11.glCullFace((int)1029);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)2977);
        GL11.glEnable((int)2896);
        switch (lod) {
            case 0: {
                this.DAKIMAKURA_MODEL.render();
                break;
            }
            case 1: {
                this.DAKIMAKURA_MODEL_LODS[0].render();
                break;
            }
            case 2: {
                this.DAKIMAKURA_MODEL_LODS[1].render();
                break;
            }
            case 3: {
                this.DAKIMAKURA_MODEL_LODS[2].render();
                break;
            }
            case 4: {
                this.DAKIMAKURA_MODEL_LODS[3].render();
                break;
            }
        }
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
        this.profiler.func_76319_b();
    }
}

