/*
 * Decompiled with CFR 0.152.
 */
package moe.plushie.dakimakuramod.client.handler;

import java.io.File;
import java.nio.charset.CharsetEncoder;
import moe.plushie.dakimakuramod.common.lib.LibModInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.Charsets;

@SideOnly(value=Side.CLIENT)
public final class RehostedJarHandler {
    private static final String STOP_MOD_REPOSTS_URL = "http://stopmodreposts.org/";
    private boolean validJar = false;
    private long lastMessagePost = 0L;
    private long messagePostRate = 120000L;

    public RehostedJarHandler(File jarFile, String originalName) {
        this.checkIfJarIsValid(jarFile, originalName);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    private void checkIfJarIsValid(File jarFile, String originalName) {
        if (jarFile == null) {
            return;
        }
        if (jarFile.getName().equals(originalName)) {
            this.validJar = true;
            return;
        }
        CharsetEncoder asciiEncoder = Charsets.US_ASCII.newEncoder();
        if (!asciiEncoder.canEncode(jarFile.getName())) {
            this.validJar = true;
            return;
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (this.validJar) {
            return;
        }
        if (LibModInfo.isDevelopmentVersion()) {
            return;
        }
        if (event.side != Side.CLIENT) {
            return;
        }
        if (event.type != TickEvent.Type.PLAYER) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (this.lastMessagePost + this.messagePostRate > System.currentTimeMillis()) {
            return;
        }
        this.lastMessagePost = System.currentTimeMillis();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        TextComponentTranslation downloadLink = new TextComponentTranslation("chat.dakimakuramod:invalidJarDownload", new Object[]{null});
        downloadLink.func_150256_b().func_150228_d(Boolean.valueOf(true));
        downloadLink.func_150256_b().func_150238_a(TextFormatting.BLUE);
        downloadLink.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("chat.dakimakuramod:invalidJarDownloadTooltip", new Object[]{null})));
        downloadLink.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://minecraft.curseforge.com/projects/dakimakura-mod/files"));
        TextComponentTranslation stopModRepostsLink = new TextComponentTranslation("chat.dakimakuramod:invalidJarStopModReposts", new Object[]{null});
        stopModRepostsLink.func_150256_b().func_150228_d(Boolean.valueOf(true));
        stopModRepostsLink.func_150256_b().func_150238_a(TextFormatting.BLUE);
        stopModRepostsLink.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new TextComponentTranslation("chat.dakimakuramod:invalidJarStopModRepostsTooltip", new Object[]{null})));
        stopModRepostsLink.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, STOP_MOD_REPOSTS_URL));
        TextComponentTranslation updateMessage = new TextComponentTranslation("chat.dakimakuramod:invalidJar", new Object[]{downloadLink, stopModRepostsLink});
        updateMessage.func_150256_b().func_150238_a(TextFormatting.RED);
        player.func_145747_a((ITextComponent)updateMessage);
    }
}

