/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.tools;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.events.TinkerToolEvent;
import slimeknights.tconstruct.library.tools.DualToolHarvestUtils;
import slimeknights.tconstruct.library.tools.ToolCore;
import slimeknights.tconstruct.library.utils.TinkerUtil;
import slimeknights.tconstruct.library.utils.ToolHelper;

public class TraitEvents {
    @SubscribeEvent
    public void mineSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack tool = event.getEntityPlayer().field_71071_by.func_70448_g();
        if (this.isTool(tool) && !ToolHelper.isBroken(tool)) {
            TinkerUtil.getTraitsOrdered(tool).forEach(trait -> trait.miningSpeed(tool, event));
        }
    }

    @SubscribeEvent
    public void blockBreak(BlockEvent.BreakEvent event) {
        ItemStack tool = event.getPlayer().field_71071_by.func_70448_g();
        if (this.isTool(tool) && !ToolHelper.isBroken(tool)) {
            TinkerUtil.getTraitsOrdered(tool).forEach(trait -> trait.beforeBlockBreak(tool, event));
        }
    }

    @SubscribeEvent
    public void blockDropEvent(BlockEvent.HarvestDropsEvent event) {
        if (event.getHarvester() == null) {
            return;
        }
        ItemStack tool = DualToolHarvestUtils.getItemstackToUse((EntityLivingBase)event.getHarvester(), event.getState());
        if (this.isTool(tool) && !ToolHelper.isBroken(tool)) {
            TinkerUtil.getTraitsOrdered(tool).forEach(trait -> trait.blockHarvestDrops(tool, event));
        }
    }

    @SubscribeEvent
    public void playerBlockOrHurtEvent(LivingHurtEvent event) {
        block5: {
            ArrayList<ItemStack> heldTools;
            Entity attacker;
            EntityPlayer player;
            block4: {
                boolean isReflectedDamage;
                boolean isPlayerGettingDamaged = event.getEntityLiving() instanceof EntityPlayer;
                boolean isClient = event.getEntityLiving().func_130014_f_().field_72995_K;
                boolean bl = isReflectedDamage = event.getSource() instanceof EntityDamageSource && ((EntityDamageSource)event.getSource()).func_180139_w();
                if (!isPlayerGettingDamaged || isClient || isReflectedDamage) {
                    return;
                }
                player = (EntityPlayer)event.getEntityLiving();
                attacker = event.getSource().func_76346_g();
                heldTools = new ArrayList<ItemStack>();
                for (ItemStack tool : event.getEntity().func_184214_aD()) {
                    if (!this.isTool(tool) || ToolHelper.isBroken(tool)) continue;
                    heldTools.add(tool);
                }
                if (!player.func_184585_cz()) break block4;
                for (ItemStack tool : heldTools) {
                    if (event.isCanceled()) continue;
                    TinkerUtil.getTraitsOrdered(tool).forEach(trait -> trait.onBlock(tool, player, event));
                }
                break block5;
            }
            if (!(attacker instanceof EntityLivingBase) || attacker.field_70128_L) break block5;
            for (ItemStack tool : heldTools) {
                if (event.isCanceled()) continue;
                TinkerUtil.getTraitsOrdered(tool).forEach(trait -> trait.onPlayerHurt(tool, player, (EntityLivingBase)attacker, event));
            }
        }
    }

    @SubscribeEvent
    public void onRepair(TinkerToolEvent.OnRepair event) {
        ItemStack tool = event.itemStack;
        TinkerUtil.getTraitsOrdered(tool).forEach(trait -> trait.onRepair(tool, event.amount));
    }

    private boolean isTool(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ToolCore;
    }
}

