/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.book.sectiontransformer;

import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.book.data.content.PageContent;
import slimeknights.mantle.client.book.data.element.ImageData;
import slimeknights.mantle.client.book.repository.BookRepository;
import slimeknights.mantle.client.gui.book.element.ElementImage;
import slimeknights.mantle.client.gui.book.element.ElementItem;
import slimeknights.mantle.client.gui.book.element.SizedBookElement;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.book.content.ContentPageIconList;
import slimeknights.tconstruct.library.book.sectiontransformer.SectionTransformer;
import slimeknights.tconstruct.library.materials.Material;

@SideOnly(value=Side.CLIENT)
public abstract class AbstractMaterialSectionTransformer
extends SectionTransformer {
    public AbstractMaterialSectionTransformer(String sectionName) {
        super(sectionName);
    }

    protected abstract boolean isValidMaterial(Material var1);

    protected abstract PageContent getPageContent(Material var1);

    @Override
    public void transform(BookData book, SectionData data) {
        data.source = BookRepository.DUMMY;
        data.parent = book;
        List materialList = TinkerRegistry.getAllMaterials().stream().filter(m -> !m.isHidden()).filter(Material::hasItems).filter(this::isValidMaterial).collect(Collectors.toList());
        if (materialList.isEmpty()) {
            return;
        }
        List<ContentPageIconList> listPages = ContentPageIconList.getPagesNeededForItemCount(materialList.size(), data, book.translate(this.sectionName));
        ListIterator<ContentPageIconList> iter = listPages.listIterator();
        ContentPageIconList overview = iter.next();
        for (Material material : materialList) {
            PageData page = this.addPage(data, material.getIdentifier(), "toolmaterial", this.getPageContent(material));
            Object icon = material.getRepresentativeItem() != null ? new ElementItem(0, 0, 1.0f, material.getRepresentativeItem()) : new ElementImage(ImageData.MISSING);
            while (!overview.addLink((SizedBookElement)icon, material.getLocalizedNameColored(), page)) {
                overview = iter.next();
            }
        }
    }
}

