/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client.gui;

import doggytalents.api.DoggyTalentsAPI;
import doggytalents.api.feature.EnumMode;
import doggytalents.api.inferface.Talent;
import doggytalents.entity.EntityDog;
import doggytalents.lib.ConfigValues;
import doggytalents.network.PacketDispatcher;
import doggytalents.network.client.DogFriendlyFireMessage;
import doggytalents.network.client.DogModeMessage;
import doggytalents.network.client.DogNameMessage;
import doggytalents.network.client.DogObeyMessage;
import doggytalents.network.client.DogTalentMessage;
import doggytalents.network.client.DogTextureMessage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiDogInfo
extends GuiScreen {
    public EntityDog dog;
    public EntityPlayer player;
    private List<GuiTextField> textfieldList = new ArrayList<GuiTextField>();
    private GuiTextField nameTextField;
    public int doggyTex;
    private int currentPage = 0;
    private int maxPages = 1;
    public int btnPerPages = 0;
    private final DecimalFormat dfShort = new DecimalFormat("0.0");
    private final DecimalFormat dfShortDouble = new DecimalFormat("0.00");

    public GuiDogInfo(EntityDog dog, EntityPlayer player) {
        this.dog = dog;
        this.player = player;
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.field_146293_o.clear();
        this.textfieldList.clear();
        super.func_73866_w_();
        Keyboard.enableRepeatEvents((boolean)true);
        int topX = this.field_146294_l / 2;
        int topY = this.field_146295_m / 2;
        GuiTextField nameTextField = new GuiTextField(0, this.field_146289_q, topX - 100, topY + 50, 200, 20){

            public boolean func_146201_a(char character, int keyId) {
                boolean typed = super.func_146201_a(character, keyId);
                if (typed) {
                    PacketDispatcher.sendToServer(new DogNameMessage(GuiDogInfo.this.dog.func_145782_y(), this.func_146179_b()));
                }
                return typed;
            }

            public void func_146175_b(int index) {
                super.func_146175_b(index);
                PacketDispatcher.sendToServer(new DogNameMessage(GuiDogInfo.this.dog.func_145782_y(), this.func_146179_b()));
            }
        };
        nameTextField.func_146195_b(false);
        nameTextField.func_146203_f(32);
        if (this.dog.func_145818_k_()) {
            nameTextField.func_146180_a(this.dog.func_95999_t());
        }
        this.nameTextField = nameTextField;
        this.textfieldList.add(nameTextField);
        this.doggyTex = this.dog.getTameSkin();
        int size = DoggyTalentsAPI.TALENTS.getKeys().size();
        this.btnPerPages = Math.max(MathHelper.func_76128_c((double)((double)(this.field_146295_m - 10) / 21.0)) - 2, 1);
        if (this.btnPerPages < size) {
            this.func_189646_b(new GuiButton(-1, 25, this.btnPerPages * 21 + 10, 20, 20, "<"));
            this.func_189646_b(new GuiButton(-2, 48, this.btnPerPages * 21 + 10, 20, 20, ">"));
        }
        this.maxPages = MathHelper.func_76143_f((double)((double)size / (double)this.btnPerPages));
        if (this.currentPage >= this.maxPages) {
            this.currentPage = 0;
        }
        int i = -1;
        for (Talent talent : DoggyTalentsAPI.TALENTS.getValues()) {
            if (++i < this.currentPage * this.btnPerPages || i >= (this.currentPage + 1) * this.btnPerPages) continue;
            this.func_189646_b(new GuiTalentButton(1 + i, 25, 10 + (i - this.currentPage * this.btnPerPages) * 21, 20, 20, "+", talent));
        }
        if (ConfigValues.USE_DT_TEXTURES) {
            this.func_189646_b(new GuiButton(-3, this.field_146294_l - 42, topY + 30, 20, 20, "+"));
            this.func_189646_b(new GuiButton(-4, this.field_146294_l - 64, topY + 30, 20, 20, "-"));
        }
        if (this.dog.func_152114_e((EntityLivingBase)this.player)) {
            this.func_189646_b(new GuiButton(-5, this.field_146294_l - 64, topY + 65, 42, 20, String.valueOf(this.dog.willObeyOthers())));
        }
        this.func_189646_b(new GuiButton(-7, this.field_146294_l - 64, topY - 5, 42, 20, String.valueOf(this.dog.canPlayersAttack())));
        this.func_189646_b(new GuiButton(-6, topX + 40, topY + 25, 60, 20, I18n.func_135052_a((String)this.dog.MODE.getMode().getUnlocalisedName(), (Object[])new Object[0])));
    }

    public void func_73863_a(int xMouse, int yMouse, float partialTickTime) {
        this.func_146276_q_();
        int topX = this.field_146294_l / 2;
        int topY = this.field_146295_m / 2;
        String health = this.dfShort.format(this.dog.func_110143_aJ());
        String healthMax = this.dfShort.format(this.dog.func_110138_aP());
        String healthRel = this.dfShort.format(this.dog.getHealthRelative() * 100.0);
        String healthState = health + "/" + healthMax + " (" + healthRel + "%)";
        String speedValue = this.dfShortDouble.format(this.dog.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
        String ageValue = this.dfShortDouble.format(this.dog.func_70874_b());
        String ageRel = "";
        ageRel = this.dog.func_70631_g_() ? I18n.func_135052_a((String)"doggui.age.baby", (Object[])new Object[0]) : I18n.func_135052_a((String)"doggui.age.adult", (Object[])new Object[0]);
        String ageString = ageValue + " " + ageRel;
        String tamedString = "";
        if (this.dog.func_70909_n()) {
            tamedString = this.dog.func_152114_e((EntityLivingBase)this.player) ? I18n.func_135052_a((String)"doggui.owner.you", (Object[])new Object[0]) : this.dog.getOwnersName().func_150254_d();
        }
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"doggui.health", (Object[])new Object[0]) + healthState, this.field_146294_l - 160, topY - 110, 0xFFFFFF);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"doggui.speed", (Object[])new Object[0]) + speedValue, this.field_146294_l - 160, topY - 100, 0xFFFFFF);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"doggui.owner", (Object[])new Object[0]) + tamedString, this.field_146294_l - 160, topY - 90, 0xFFFFFF);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"doggui.age", (Object[])new Object[0]) + ageString, this.field_146294_l - 160, topY - 80, 0xFFFFFF);
        if (ConfigValues.DOG_GENDER) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"doggui.gender", (Object[])new Object[0]) + this.dog.GENDER.getGenderName().func_150254_d(), this.field_146294_l - 160, topY - 70, 0xFFFFFF);
        }
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"doggui.newname", (Object[])new Object[0]), topX - 100, topY + 38, 0x404040);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"doggui.level", (Object[])new Object[0]) + " " + this.dog.LEVELS.getLevel(), topX - 65, topY + 75, 16716025);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"doggui.leveldire", (Object[])new Object[0]) + " " + this.dog.LEVELS.getDireLevel(), topX, topY + 75, 16716025);
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"doggui.pointsleft", (Object[])new Object[0]) + " " + this.dog.spendablePoints(), topX - 38, topY + 89, 0xFFFFFF);
        if (ConfigValues.USE_DT_TEXTURES) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"doggui.textureindex", (Object[])new Object[0]), this.field_146294_l - 80, topY + 20, 0xFFFFFF);
        }
        if (this.dog.func_152114_e((EntityLivingBase)this.player)) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"doggui.obeyothers", (Object[])new Object[0]), this.field_146294_l - 76, topY + 55, 0xFFFFFF);
        }
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"doggui.friendlyfire", (Object[])new Object[0]), this.field_146294_l - 76, topY - 15, 0xFFFFFF);
        int i = -1;
        for (Talent talent : DoggyTalentsAPI.TALENTS.getValues()) {
            if (++i < this.currentPage * this.btnPerPages || i >= (this.currentPage + 1) * this.btnPerPages) continue;
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)talent.getTranslationKey(), (Object[])new Object[0]), 50, 17 + (i - this.currentPage * this.btnPerPages) * 21, 0xFFFFFF);
        }
        for (GuiTextField field : this.textfieldList) {
            field.func_146194_f();
        }
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        super.func_73863_a(xMouse, yMouse, partialTickTime);
        RenderHelper.func_74520_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int k = 0; k < this.field_146292_n.size(); ++k) {
            GuiButton button = (GuiButton)this.field_146292_n.get(k);
            if (!button.func_146116_c(this.field_146297_k, xMouse, yMouse)) continue;
            ArrayList<String> list = new ArrayList<String>();
            if (button.field_146127_k >= 1 && button.field_146127_k <= DoggyTalentsAPI.TALENTS.getKeys().size()) {
                Talent talent = button instanceof GuiTalentButton ? ((GuiTalentButton)button).talent : null;
                list.add(TextFormatting.GREEN + I18n.func_135052_a((String)talent.getTranslationKey(), (Object[])new Object[0]));
                list.add("Level: " + this.dog.TALENTS.getLevel(talent));
                list.add(TextFormatting.GRAY + "--------------------------------");
                list.addAll(this.splitInto(I18n.func_135052_a((String)talent.getInfoTranslationKey(), (Object[])new Object[0]), 200, this.field_146297_k.field_71466_p));
            }
            if (button.field_146127_k == -1) {
                list.add(TextFormatting.ITALIC + I18n.func_135052_a((String)"doggui.prevpage", (Object[])new Object[0]));
            } else if (button.field_146127_k == -2) {
                list.add(TextFormatting.ITALIC + I18n.func_135052_a((String)"doggui.nextpage", (Object[])new Object[0]));
            } else if (button.field_146127_k == -6) {
                String str = I18n.func_135052_a((String)this.dog.MODE.getMode().getUnlocalisedInfo(), (Object[])new Object[0]);
                list.addAll(this.splitInto(str, 150, this.field_146297_k.field_71466_p));
                if (this.dog.MODE.isMode(EnumMode.WANDERING)) {
                    if (!this.dog.COORDS.hasBowlPos()) {
                        list.add(TextFormatting.RED + I18n.func_135052_a((String)"dog.mode.docile.nobowl", (Object[])new Object[0]));
                    } else if (this.dog.func_174818_b(this.dog.COORDS.getBowlPos()) > 256.0) {
                        list.add(TextFormatting.RED + I18n.func_135052_a((String)"dog.mode.docile.distance", (Object[])new Object[]{(int)Math.sqrt(this.dog.func_180425_c().func_177951_i((Vec3i)this.dog.COORDS.getBowlPos()))}));
                    } else {
                        list.add(TextFormatting.GREEN + I18n.func_135052_a((String)"dog.mode.docile.bowl", (Object[])new Object[]{(int)Math.sqrt(this.dog.func_180425_c().func_177951_i((Vec3i)this.dog.COORDS.getBowlPos()))}));
                    }
                }
            }
            this.drawHoveringText(list, xMouse, yMouse, this.field_146297_k.field_71466_p);
        }
        GlStateManager.func_179121_F();
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k >= 1 && button.field_146127_k <= DoggyTalentsAPI.TALENTS.getKeys().size()) {
            Talent talent = button instanceof GuiTalentButton ? ((GuiTalentButton)button).talent : null;
            int level = this.dog.TALENTS.getLevel(talent);
            if (level < talent.getHighestLevel(this.dog) && this.dog.spendablePoints() >= talent.getCost(this.dog, level + 1)) {
                PacketDispatcher.sendToServer(new DogTalentMessage(this.dog.func_145782_y(), talent.getRegistryName()));
            }
        } else if (button.field_146127_k == -1) {
            if (this.currentPage > 0) {
                --this.currentPage;
                this.func_73866_w_();
            }
        } else if (button.field_146127_k == -2 && this.currentPage + 1 < this.maxPages) {
            ++this.currentPage;
            this.func_73866_w_();
        }
        if (button.field_146127_k == -4 || button.field_146127_k == -3) {
            this.doggyTex += button.field_146127_k == -3 ? 1 : 127;
            this.doggyTex %= 128;
            PacketDispatcher.sendToServer(new DogTextureMessage(this.dog.func_145782_y(), this.doggyTex));
        }
        if (button.field_146127_k == -5) {
            button.field_146126_j = String.valueOf(!this.dog.willObeyOthers());
            PacketDispatcher.sendToServer(new DogObeyMessage(this.dog.func_145782_y(), !this.dog.willObeyOthers()));
        }
        if (button.field_146127_k == -7) {
            button.field_146126_j = String.valueOf(!this.dog.canPlayersAttack());
            PacketDispatcher.sendToServer(new DogFriendlyFireMessage(this.dog.func_145782_y(), !this.dog.canPlayersAttack()));
        }
        if (button.field_146127_k == -6) {
            EnumMode mode = this.dog.getMode().nextMode();
            button.field_146126_j = mode == EnumMode.WANDERING && !this.dog.COORDS.hasBowlPos() ? TextFormatting.RED + I18n.func_135052_a((String)mode.getUnlocalisedName(), (Object[])new Object[0]) : I18n.func_135052_a((String)mode.getUnlocalisedName(), (Object[])new Object[0]);
            PacketDispatcher.sendToServer(new DogModeMessage(this.dog.func_145782_y(), mode));
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        for (GuiTextField field : this.textfieldList) {
            field.func_146178_a();
        }
    }

    public void func_73864_a(int xMouse, int yMouse, int mouseButton) throws IOException {
        super.func_73864_a(xMouse, yMouse, mouseButton);
        for (GuiTextField field : this.textfieldList) {
            field.func_146192_a(xMouse, yMouse, mouseButton);
        }
    }

    public void func_73869_a(char typedChar, int keyCode) throws IOException {
        for (GuiTextField field : this.textfieldList) {
            field.func_146201_a(typedChar, keyCode);
        }
        super.func_73869_a(typedChar, keyCode);
    }

    public void func_146281_b() {
        super.func_146281_b();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public boolean func_73868_f() {
        return false;
    }

    public List<String> splitInto(String text, int maxLength, FontRenderer font) {
        ArrayList<String> list = new ArrayList<String>();
        String temp = "";
        String[] split = text.split(" ");
        for (int i = 0; i < split.length; ++i) {
            String str = split[i];
            int length = font.func_78256_a(temp + str);
            if (length > maxLength) {
                list.add(temp);
                temp = "";
            }
            temp = temp + str + " ";
            if (i != split.length - 1) continue;
            list.add(temp);
        }
        return list;
    }

    private static class GuiTalentButton
    extends GuiButton {
        protected Talent talent;

        private GuiTalentButton(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Talent talent) {
            super(buttonId, x, y, widthIn, heightIn, buttonText);
            this.talent = talent;
        }
    }
}

