/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.universal.jei;

import com.legacy.aether.api.AetherAPI;
import com.legacy.aether.api.enchantments.AetherEnchantment;
import com.legacy.aether.api.freezables.AetherFreezable;
import com.legacy.aether.blocks.BlocksAether;
import com.legacy.aether.client.gui.GuiEnchanter;
import com.legacy.aether.client.gui.GuiFreezer;
import com.legacy.aether.universal.jei.category.EnchanterRecipeCategory;
import com.legacy.aether.universal.jei.category.FreezerRecipeCategory;
import com.legacy.aether.universal.jei.wrapper.EnchanterRecipeWrapper;
import com.legacy.aether.universal.jei.wrapper.FreezerRecipeWrapper;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class AetherJEIPlugin
implements IModPlugin {
    public void register(IModRegistry registry) {
        registry.handleRecipes(AetherEnchantment.class, (IRecipeWrapperFactory)new IRecipeWrapperFactory<AetherEnchantment>(){

            public IRecipeWrapper getRecipeWrapper(AetherEnchantment recipe) {
                return new EnchanterRecipeWrapper(recipe);
            }
        }, "aether_legacy.enchantment");
        registry.handleRecipes(AetherFreezable.class, (IRecipeWrapperFactory)new IRecipeWrapperFactory<AetherFreezable>(){

            public IRecipeWrapper getRecipeWrapper(AetherFreezable recipe) {
                return new FreezerRecipeWrapper(recipe);
            }
        }, "aether_legacy.freezable");
        registry.addRecipeCatalyst((Object)new ItemStack(BlocksAether.enchanter), new String[]{"aether_legacy.enchantment"});
        registry.addRecipeCatalyst((Object)new ItemStack(BlocksAether.freezer), new String[]{"aether_legacy.freezable"});
        registry.addRecipes(AetherAPI.getInstance().getEnchantmentValues(), "aether_legacy.enchantment");
        registry.addRecipes(AetherAPI.getInstance().getFreezableValues(), "aether_legacy.freezable");
        registry.addRecipeClickArea(GuiFreezer.class, 80, 35, 22, 15, new String[]{"aether_legacy.freezable"});
        registry.addRecipeClickArea(GuiEnchanter.class, 80, 35, 22, 15, new String[]{"aether_legacy.enchantment"});
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new EnchanterRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new FreezerRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
    }
}

