/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.client;

import com.legacy.aether.AetherConfig;
import com.legacy.aether.api.AetherAPI;
import com.legacy.aether.api.player.IPlayerAether;
import com.legacy.aether.client.PlayerGloveRenderer;
import com.legacy.aether.client.gui.AetherLoadingScreen;
import com.legacy.aether.client.gui.GuiEnterAether;
import com.legacy.aether.client.gui.button.GuiAccessoryButton;
import com.legacy.aether.containers.inventory.InventoryAccessories;
import com.legacy.aether.items.ItemsAether;
import com.legacy.aether.networking.AetherNetworkingManager;
import com.legacy.aether.networking.packets.PacketOpenContainer;
import com.legacy.aether.networking.packets.PacketSendJump;
import com.legacy.aether.universal.fastcrafting.FastCraftingUtil;
import com.legacy.aether.universal.pixelmon.PixelmonUtil;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiDownloadTerrain;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class AetherClientEvents {
    private final Minecraft mc = FMLClientHandler.instance().getClient();
    private static boolean wasInAether = false;
    private static final GuiAccessoryButton ACCESSORY_BUTTON = new GuiAccessoryButton(0, 0);
    private static int previousSelectedTabIndex = -1;

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) throws Exception {
        Minecraft mc = Minecraft.func_71410_x();
        TickEvent.Phase phase = event.phase;
        TickEvent.Type type = event.type;
        if (phase == TickEvent.Phase.END && type.equals((Object)TickEvent.Type.CLIENT) && !AetherConfig.visual_options.trivia_disabled && !(mc.field_71461_s instanceof AetherLoadingScreen)) {
            mc.field_71461_s = new AetherLoadingScreen(mc);
        }
        if (mc.field_71439_g != null) {
            if (AetherAPI.getInstance().get((EntityPlayer)mc.field_71439_g).inPortalBlock() && this.mc.field_71462_r instanceof GuiContainer) {
                this.mc.field_71439_g.func_71053_j();
            }
            if (AetherAPI.getInstance().get((EntityPlayer)mc.field_71439_g).shouldPortalSound()) {
                this.mc.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187814_ei, (float)(this.mc.field_71441_e.field_73012_v.nextFloat() * 0.4f + 0.8f)));
                AetherAPI.getInstance().get((EntityPlayer)mc.field_71439_g).shouldPortalSound(false);
            }
        }
    }

    @SubscribeEvent
    public void onUpdateJump(InputUpdateEvent event) {
        boolean isJumping = event.getMovementInput().field_78901_c;
        IPlayerAether playerAether = AetherAPI.getInstance().get(event.getEntityPlayer());
        if (isJumping != playerAether.isJumping()) {
            AetherNetworkingManager.sendToServer(new PacketSendJump(event.getEntityPlayer().func_110124_au(), isJumping));
            playerAether.setJumping(isJumping);
        }
    }

    @SubscribeEvent
    public void onBowPulled(FOVUpdateEvent event) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null || player != null && player.func_184607_cu() == null) {
            return;
        }
        Item item = player.func_184607_cu().func_77973_b();
        if (item == ItemsAether.phoenix_bow) {
            int i = player.func_184612_cw();
            float f1 = (float)i / 20.0f;
            f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
            float original = event.getFov();
            event.setNewfov(original *= 1.0f - f1 * 0.15f);
        }
    }

    @SubscribeEvent
    public void onScreenOpened(GuiScreenEvent.InitGuiEvent.Post event) {
        if (event.getGui() instanceof GuiContainer) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            Class<?> clazz = event.getGui().getClass();
            int guiLeft = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)((GuiContainer)event.getGui()), (String[])new String[]{"guiLeft", "field_147003_i"});
            int guiTop = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)((GuiContainer)event.getGui()), (String[])new String[]{"guiTop", "field_147009_r"});
            if (player.field_71075_bZ.field_75098_d) {
                if (event.getGui() instanceof GuiContainerCreative && ((GuiContainerCreative)event.getGui()).func_147056_g() == CreativeTabs.field_78036_m.func_78021_a()) {
                    event.getButtonList().add(ACCESSORY_BUTTON.setPosition(guiLeft + 73, guiTop + 38));
                    previousSelectedTabIndex = CreativeTabs.field_78036_m.func_78021_a();
                }
            } else if (clazz == GuiInventory.class || FastCraftingUtil.isOverridenGUI(clazz) || PixelmonUtil.isOverridenInventoryGUI(clazz)) {
                event.getButtonList().add(ACCESSORY_BUTTON.setPosition(guiLeft + 26, guiTop + 65));
            }
        }
    }

    @SubscribeEvent
    public void onOpenGui(GuiOpenEvent event) {
        if (this.mc.field_71439_g != null && event.getGui() instanceof GuiDownloadTerrain) {
            GuiEnterAether enterAether = new GuiEnterAether(true);
            GuiEnterAether exitAether = new GuiEnterAether(false);
            if (this.mc.field_71439_g.field_71093_bK == AetherConfig.dimension.aether_dimension_id) {
                event.setGui((GuiScreen)enterAether);
                wasInAether = true;
            } else if (wasInAether) {
                event.setGui((GuiScreen)exitAether);
                wasInAether = false;
            }
        }
    }

    @SubscribeEvent
    public void onMouseClicked(GuiScreenEvent.MouseInputEvent.Post event) {
        if (event.getGui() instanceof GuiContainerCreative) {
            GuiContainerCreative guiScreen = (GuiContainerCreative)event.getGui();
            List buttonList = (List)ObfuscationReflectionHelper.getPrivateValue(GuiScreen.class, (Object)guiScreen, (int)7);
            if (previousSelectedTabIndex != guiScreen.func_147056_g()) {
                if (guiScreen.func_147056_g() == CreativeTabs.field_78036_m.func_78021_a() && !buttonList.contains((Object)ACCESSORY_BUTTON)) {
                    int guiLeft = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)((GuiContainer)event.getGui()), (String[])new String[]{"guiLeft", "field_147003_i"});
                    int guiTop = (Integer)ObfuscationReflectionHelper.getPrivateValue(GuiContainer.class, (Object)((GuiContainer)event.getGui()), (String[])new String[]{"guiTop", "field_147009_r"});
                    buttonList.add(ACCESSORY_BUTTON.setPosition(guiLeft + 73, guiTop + 38));
                } else if (previousSelectedTabIndex == CreativeTabs.field_78036_m.func_78021_a()) {
                    buttonList.remove((Object)ACCESSORY_BUTTON);
                }
                previousSelectedTabIndex = guiScreen.func_147056_g();
            }
        }
    }

    @SubscribeEvent
    public void onButtonPressed(GuiScreenEvent.ActionPerformedEvent.Pre event) {
        Class<?> clazz = event.getGui().getClass();
        if ((clazz == GuiInventory.class || FastCraftingUtil.isOverridenGUI(clazz) || PixelmonUtil.isOverridenInventoryGUI(clazz) || PixelmonUtil.isOverridenCreativeGUI(clazz) || clazz == GuiContainerCreative.class) && event.getButton().field_146127_k == 18067) {
            AetherNetworkingManager.sendToServer(new PacketOpenContainer(1));
        }
    }

    @SubscribeEvent
    public void onRenderHand(RenderSpecificHandEvent event) {
        PlayerGloveRenderer.renderItemFirstPerson((AbstractClientPlayer)Minecraft.func_71410_x().field_71439_g, event.getPartialTicks(), event.getInterpolatedPitch(), event.getHand(), event.getSwingProgress(), event.getItemStack(), event.getEquipProgress());
    }

    @SubscribeEvent
    public void onInvisibilityPlayerUpdate(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        IPlayerAether playerAether = AetherAPI.getInstance().get(player);
        if (playerAether != null && playerAether.getAccessoryInventory().wearingAccessory(new ItemStack(ItemsAether.invisibility_cape))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onTextureStichedEvent(TextureStitchEvent.Pre event) {
        for (int i = 0; i < InventoryAccessories.EMPTY_SLOT_NAMES.length; ++i) {
            event.getMap().func_174942_a(new ResourceLocation("aether_legacy", "items/slots/" + InventoryAccessories.EMPTY_SLOT_NAMES[i]));
        }
    }
}

