/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.aether.api;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryInternal;
import net.minecraftforge.registries.ILockableRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.lang3.Validate;

class NamespacedWrapper<V extends IForgeRegistryEntry<V>>
extends RegistryNamespaced<ResourceLocation, V>
implements ILockableRegistry {
    private boolean locked = false;
    private ForgeRegistry<V> delegate;

    public NamespacedWrapper(ForgeRegistry<V> owner) {
        this.delegate = owner;
    }

    public void register(int id, ResourceLocation key, V value) {
        if (this.locked) {
            throw new IllegalStateException("Can not register to a locked registry. Modder should use Forge Register methods.");
        }
        Validate.notNull(value);
        if (value.getRegistryName() == null) {
            value.setRegistryName(key);
        }
        this.delegate.register(value);
        int realId = this.delegate.getID(value);
        if (realId != id && id != -1) {
            FMLLog.log.warn("Registered object did not get ID it asked for. Name: {} Type: {} Expected: {} Got: {}", (Object)key, (Object)value.getRegistryType().getName(), (Object)id, (Object)realId);
        }
    }

    public void putObject(ResourceLocation key, V value) {
        this.register(-1, key, value);
    }

    @Nullable
    public V getObject(@Nullable ResourceLocation name) {
        return (V)this.delegate.getValue(name);
    }

    @Nullable
    public ResourceLocation getNameForObject(V value) {
        return this.delegate.getKey(value);
    }

    public boolean containsKey(ResourceLocation key) {
        return this.delegate.containsKey(key);
    }

    public int getIDForObject(@Nullable V value) {
        return this.delegate.getID(value);
    }

    @Nullable
    public V getObjectById(int id) {
        return (V)this.delegate.getValue(id);
    }

    public Iterator<V> iterator() {
        return this.delegate.iterator();
    }

    public Set<ResourceLocation> func_148742_b() {
        return this.delegate.getKeys();
    }

    @Nullable
    public V getRandomObject(Random random) {
        List lst = this.delegate.getValues();
        if (lst.isEmpty()) {
            return null;
        }
        return (V)((IForgeRegistryEntry)lst.get(random.nextInt(lst.size())));
    }

    public void lock() {
        this.locked = true;
    }

    public static class Factory<V extends IForgeRegistryEntry<V>>
    implements IForgeRegistry.CreateCallback<V> {
        public static final ResourceLocation ID = new ResourceLocation("forge", "registry_defaulted_wrapper");

        public void onCreate(IForgeRegistryInternal<V> owner, RegistryManager stage) {
            owner.setSlaveMap(ID, new NamespacedWrapper((ForgeRegistry)owner));
        }
    }
}

