/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.network;

import hunternif.mc.atlas.network.AbstractMessage;
import hunternif.mc.atlas.network.bidirectional.DeleteMarkerPacket;
import hunternif.mc.atlas.network.bidirectional.PutBiomeTilePacket;
import hunternif.mc.atlas.network.client.DeleteCustomGlobalTilePacket;
import hunternif.mc.atlas.network.client.IntDimensionUpdatePacket;
import hunternif.mc.atlas.network.client.IntTilesPacket;
import hunternif.mc.atlas.network.client.MapDataPacket;
import hunternif.mc.atlas.network.client.MarkersPacket;
import hunternif.mc.atlas.network.client.OptionalMarkerPacket;
import hunternif.mc.atlas.network.client.ShortDimensionUpdatePacket;
import hunternif.mc.atlas.network.client.ShortTilesPacket;
import hunternif.mc.atlas.network.client.TileGroupsPacket;
import hunternif.mc.atlas.network.client.TileNameIDPacket;
import hunternif.mc.atlas.network.server.AddMarkerPacket;
import hunternif.mc.atlas.network.server.BrowsingPositionPacket;
import hunternif.mc.atlas.network.server.RegisterTileIdPacket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketDispatcher {
    private static byte packetId = 0;
    private static final SimpleNetworkWrapper dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel("antiqueatlas");

    private PacketDispatcher() {
    }

    public static void registerPackets() {
        PacketDispatcher.registerMessage(DeleteMarkerPacket.class);
        PacketDispatcher.registerMessage(PutBiomeTilePacket.class);
        PacketDispatcher.registerMessage(MapDataPacket.class);
        PacketDispatcher.registerMessage(TileGroupsPacket.class);
        PacketDispatcher.registerMessage(ShortDimensionUpdatePacket.class);
        PacketDispatcher.registerMessage(TileNameIDPacket.class);
        PacketDispatcher.registerMessage(ShortTilesPacket.class);
        PacketDispatcher.registerMessage(MarkersPacket.class);
        PacketDispatcher.registerMessage(DeleteCustomGlobalTilePacket.class);
        PacketDispatcher.registerMessage(AddMarkerPacket.class);
        PacketDispatcher.registerMessage(RegisterTileIdPacket.class);
        PacketDispatcher.registerMessage(BrowsingPositionPacket.class);
        PacketDispatcher.registerMessage(IntTilesPacket.class);
        PacketDispatcher.registerMessage(IntDimensionUpdatePacket.class);
        PacketDispatcher.registerMessage(OptionalMarkerPacket.class);
    }

    private static <T extends AbstractMessage<T>> void registerMessage(Class<T> clazz) {
        if (AbstractMessage.AbstractClientMessage.class.isAssignableFrom(clazz)) {
            byte by = packetId;
            packetId = (byte)(by + 1);
            dispatcher.registerMessage(clazz, clazz, (int)by, Side.CLIENT);
        } else if (AbstractMessage.AbstractServerMessage.class.isAssignableFrom(clazz)) {
            byte by = packetId;
            packetId = (byte)(by + 1);
            dispatcher.registerMessage(clazz, clazz, (int)by, Side.SERVER);
        } else {
            dispatcher.registerMessage(clazz, clazz, (int)packetId, Side.CLIENT);
            byte by = packetId;
            packetId = (byte)(by + 1);
            dispatcher.registerMessage(clazz, clazz, (int)by, Side.SERVER);
        }
    }

    public static void sendToAll(IMessage message) {
        dispatcher.sendToAll(message);
    }

    public static void sendTo(IMessage message, EntityPlayerMP player) {
        dispatcher.sendTo(message, player);
    }

    private static void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        dispatcher.sendToAllAround(message, point);
    }

    private static void sendToAllAround(IMessage message, int dimension, double x, double y, double z, double range) {
        PacketDispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, range));
    }

    public static void sendToAllAround(IMessage message, EntityPlayer player, double range) {
        PacketDispatcher.sendToAllAround(message, player.func_130014_f_().field_73011_w.getDimension(), player.field_70165_t, player.field_70163_u, player.field_70161_v, range);
    }

    public static void sendToDimension(IMessage message, int dimensionId) {
        dispatcher.sendToDimension(message, dimensionId);
    }

    public static void sendToServer(IMessage message) {
        dispatcher.sendToServer(message);
    }
}

