/*
 * Decompiled with CFR 0.152.
 */
package hunternif.mc.atlas.client;

import hunternif.mc.atlas.client.TextureSet;
import hunternif.mc.atlas.core.Tile;
import hunternif.mc.atlas.util.Log;
import hunternif.mc.atlas.util.SaveData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BiomeTextureMap
extends SaveData {
    private static final BiomeTextureMap INSTANCE = new BiomeTextureMap();
    final Map<Biome, TextureSet> biomeTextureMap = new HashMap<Biome, TextureSet>();
    final Map<Integer, TextureSet> pseudoBiomeTextureMap = new HashMap<Integer, TextureSet>();
    public static final TextureSet defaultTexture = TextureSet.PLAINS;

    public static BiomeTextureMap instance() {
        return INSTANCE;
    }

    public void setTexture(Biome biome, TextureSet textureSet) {
        if (textureSet == null) {
            if (this.biomeTextureMap.remove(biome) != null) {
                Log.warn("Removing old texture for biome %s", biome.getRegistryName());
            }
            return;
        }
        TextureSet previous = this.biomeTextureMap.put(biome, textureSet);
        if (previous == null) {
            this.markDirty();
        } else if (!previous.equals(textureSet)) {
            Log.warn("Overwriting texture set for biome %s", biome.getRegistryName());
            this.markDirty();
        }
    }

    public void setTexture(int pseudoID, TextureSet textureSet) {
        if (textureSet == null) {
            if (this.pseudoBiomeTextureMap.remove(pseudoID) != null) {
                Log.warn("Removing old texture for pseudo-biome %d", pseudoID);
            }
            return;
        }
        TextureSet previous = this.pseudoBiomeTextureMap.put(pseudoID, textureSet);
        if (previous == null) {
            this.markDirty();
        } else if (!previous.equals(textureSet)) {
            Log.warn("Overwriting texture set for pseudo-biome %d", pseudoID);
            this.markDirty();
        }
    }

    private void autoRegister(Biome biome) {
        if (biome == null) {
            Log.warn("Biome is null", new Object[0]);
            return;
        }
        Set types = BiomeDictionary.getTypes((Biome)biome);
        if (types.contains(BiomeDictionary.Type.SWAMP)) {
            if (types.contains(BiomeDictionary.Type.HILLS)) {
                this.setTexture(biome, TextureSet.SWAMP_HILLS);
            } else {
                this.setTexture(biome, TextureSet.SWAMP);
            }
        } else if (types.contains(BiomeDictionary.Type.WATER) || types.contains(BiomeDictionary.Type.RIVER)) {
            if (types.contains(BiomeDictionary.Type.FOREST) || types.contains(BiomeDictionary.Type.JUNGLE)) {
                if (types.contains(BiomeDictionary.Type.HILLS)) {
                    this.setTexture(biome, TextureSet.SWAMP_HILLS);
                } else {
                    this.setTexture(biome, TextureSet.SWAMP);
                }
            } else if (types.contains(BiomeDictionary.Type.SNOWY)) {
                this.setTexture(biome, TextureSet.ICE);
            } else {
                this.setTexture(biome, TextureSet.WATER);
            }
        } else if (types.contains(BiomeDictionary.Type.BEACH)) {
            if (types.contains(BiomeDictionary.Type.MOUNTAIN)) {
                this.setTexture(biome, TextureSet.ROCK_SHORE);
            } else {
                this.setTexture(biome, TextureSet.SHORE);
            }
        } else if (types.contains(BiomeDictionary.Type.JUNGLE)) {
            if (types.contains(BiomeDictionary.Type.MOUNTAIN)) {
                this.setTexture(biome, TextureSet.JUNGLE_CLIFFS);
            } else if (types.contains(BiomeDictionary.Type.HILLS)) {
                this.setTexture(biome, TextureSet.JUNGLE_HILLS);
            } else {
                this.setTexture(biome, TextureSet.JUNGLE);
            }
        } else if (types.contains(BiomeDictionary.Type.SAVANNA)) {
            if (types.contains(BiomeDictionary.Type.MOUNTAIN) || types.contains(BiomeDictionary.Type.HILLS)) {
                this.setTexture(biome, TextureSet.SAVANNA_CLIFFS);
            } else {
                this.setTexture(biome, TextureSet.SAVANNA);
            }
        } else if (types.contains(BiomeDictionary.Type.CONIFEROUS)) {
            if (types.contains(BiomeDictionary.Type.MOUNTAIN) || types.contains(BiomeDictionary.Type.HILLS)) {
                this.setTexture(biome, TextureSet.PINES_HILLS);
            } else {
                this.setTexture(biome, TextureSet.PINES);
            }
        } else if (types.contains(BiomeDictionary.Type.MESA)) {
            if (types.contains(BiomeDictionary.Type.FOREST)) {
                this.setTexture(biome, TextureSet.PLATEAU_MESA_TREES);
            } else {
                this.setTexture(biome, TextureSet.PLATEAU_MESA);
            }
        } else if (types.contains(BiomeDictionary.Type.FOREST)) {
            if (types.contains(BiomeDictionary.Type.SNOWY)) {
                if (types.contains(BiomeDictionary.Type.HILLS)) {
                    this.setTexture(biome, TextureSet.SNOW_PINES_HILLS);
                } else {
                    this.setTexture(biome, TextureSet.SNOW_PINES);
                }
            } else if (types.contains(BiomeDictionary.Type.SPARSE)) {
                if (types.contains(BiomeDictionary.Type.HILLS)) {
                    this.setTexture(biome, TextureSet.SPARSE_FOREST_HILLS);
                } else {
                    this.setTexture(biome, TextureSet.SPARSE_FOREST);
                }
            } else if (types.contains(BiomeDictionary.Type.DENSE)) {
                if (types.contains(BiomeDictionary.Type.HILLS)) {
                    this.setTexture(biome, TextureSet.DENSE_FOREST_HILLS);
                } else {
                    this.setTexture(biome, TextureSet.DENSE_FOREST);
                }
            } else if (types.contains(BiomeDictionary.Type.HILLS)) {
                this.setTexture(biome, TextureSet.FOREST_HILLS);
            } else {
                this.setTexture(biome, TextureSet.FOREST);
            }
        } else if (types.contains(BiomeDictionary.Type.PLAINS) || types.contains(BiomeDictionary.Type.WASTELAND)) {
            if (types.contains(BiomeDictionary.Type.SNOWY) || types.contains(BiomeDictionary.Type.COLD)) {
                if (types.contains(BiomeDictionary.Type.MOUNTAIN)) {
                    this.setTexture(biome, TextureSet.MOUNTAINS_SNOW_CAPS);
                } else if (types.contains(BiomeDictionary.Type.HILLS)) {
                    this.setTexture(biome, TextureSet.SNOW_HILLS);
                } else {
                    this.setTexture(biome, TextureSet.SNOW);
                }
            } else if (types.contains(BiomeDictionary.Type.HOT)) {
                if (types.contains(BiomeDictionary.Type.HILLS) || types.contains(BiomeDictionary.Type.MOUNTAIN)) {
                    this.setTexture(biome, TextureSet.DESERT_HILLS);
                } else {
                    this.setTexture(biome, TextureSet.DESERT);
                }
            } else if (types.contains(BiomeDictionary.Type.HILLS) || types.contains(BiomeDictionary.Type.MOUNTAIN)) {
                this.setTexture(biome, TextureSet.HILLS);
            } else {
                this.setTexture(biome, TextureSet.PLAINS);
            }
        } else if (types.contains(BiomeDictionary.Type.MOUNTAIN)) {
            this.setTexture(biome, TextureSet.MOUNTAINS_NAKED);
        } else if (types.contains(BiomeDictionary.Type.HILLS)) {
            if (types.contains(BiomeDictionary.Type.SNOWY) || types.contains(BiomeDictionary.Type.COLD)) {
                this.setTexture(biome, TextureSet.SNOW_HILLS);
            } else if (types.contains(BiomeDictionary.Type.SANDY)) {
                this.setTexture(biome, TextureSet.DESERT_HILLS);
            } else {
                this.setTexture(biome, TextureSet.HILLS);
            }
        } else {
            this.setTexture(biome, defaultTexture);
        }
        Log.info("Auto-registered standard texture set for biome %s", biome.getRegistryName().toString());
    }

    public void checkRegistration(Biome biome) {
        if (!this.isRegistered(biome)) {
            this.autoRegister(biome);
            this.markDirty();
        }
    }

    private void checkRegistration(int pseudoID) {
        if (!this.isRegistered(pseudoID)) {
            this.setTexture(pseudoID, defaultTexture);
        }
    }

    public boolean isRegistered(Biome biome) {
        return this.biomeTextureMap.containsKey(biome);
    }

    public boolean isRegistered(int pseudoID) {
        return this.pseudoBiomeTextureMap.containsKey(pseudoID);
    }

    public TextureSet getTextureSet(Tile tile) {
        if (tile == null) {
            return defaultTexture;
        }
        if (tile.biomeID >= 0) {
            Biome biome = Biome.func_185357_a((int)tile.biomeID);
            this.checkRegistration(biome);
            return this.biomeTextureMap.getOrDefault(biome, defaultTexture);
        }
        this.checkRegistration(tile.biomeID);
        return this.pseudoBiomeTextureMap.get(tile.biomeID);
    }

    public ResourceLocation getTexture(Tile tile) {
        TextureSet set = this.getTextureSet(tile);
        int i = MathHelper.func_76141_d((float)((float)tile.getVariationNumber() / 32767.0f * (float)set.textures.length));
        return set.textures[i];
    }

    public List<ResourceLocation> getAllTextures() {
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(this.biomeTextureMap.size());
        for (Map.Entry<Biome, TextureSet> entry : this.biomeTextureMap.entrySet()) {
            list.addAll(Arrays.asList(entry.getValue().textures));
        }
        for (Map.Entry<Object, TextureSet> entry : this.pseudoBiomeTextureMap.entrySet()) {
            list.addAll(Arrays.asList(entry.getValue().textures));
        }
        return list;
    }
}

