/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import nc.util.CollectionHelper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class BlockPosHelper {
    private final BlockPos pos;
    private static final EnumFacing[] ADJACENTS = EnumFacing.field_82609_l;
    private static final EnumFacing[] HORIZONTALS_X = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.SOUTH};
    private static final EnumFacing[] HORIZONTALS_Y = EnumFacing.field_176754_o;
    private static final EnumFacing[] HORIZONTALS_Z = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP, EnumFacing.WEST, EnumFacing.EAST};
    private static final EnumFacing[] AXIALS_X = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST};
    private static final EnumFacing[] AXIALS_Y = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP};
    private static final EnumFacing[] AXIALS_Z = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH};
    private static final EnumFacing[] VERTEX_DNW = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.WEST};
    private static final EnumFacing[] VERTEX_DNE = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.EAST};
    private static final EnumFacing[] VERTEX_DSW = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.WEST};
    private static final EnumFacing[] VERTEX_DSE = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.EAST};
    private static final EnumFacing[] VERTEX_UNW = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.WEST};
    private static final EnumFacing[] VERTEX_UNE = new EnumFacing[]{EnumFacing.UP, EnumFacing.NORTH, EnumFacing.EAST};
    private static final EnumFacing[] VERTEX_USW = new EnumFacing[]{EnumFacing.UP, EnumFacing.SOUTH, EnumFacing.WEST};
    private static final EnumFacing[] VERTEX_USE = new EnumFacing[]{EnumFacing.UP, EnumFacing.SOUTH, EnumFacing.EAST};

    public BlockPosHelper(BlockPos pos) {
        this.pos = pos;
    }

    public BlockPosHelper(int x, int y, int z) {
        this.pos = new BlockPos(x, y, z);
    }

    public BlockPos[] offsets(EnumFacing[] sides, int dist) {
        BlockPos[] posList = new BlockPos[sides.length];
        for (int i = 0; i < sides.length; ++i) {
            posList[i] = this.pos.func_177967_a(sides[i], dist);
        }
        return posList;
    }

    private BlockPos position(int x, int y, int z) {
        return new BlockPos(this.pos.func_177958_n() + x, this.pos.func_177956_o() + y, this.pos.func_177952_p() + z);
    }

    public BlockPos[] adjacents(int dist) {
        return this.offsets(ADJACENTS, dist);
    }

    public BlockPos[] adjacents() {
        return this.adjacents(1);
    }

    public BlockPos[] horizontalsX(int dist) {
        return this.offsets(HORIZONTALS_X, dist);
    }

    public BlockPos[] horizontalsX() {
        return this.horizontalsX(1);
    }

    public BlockPos[] horizontalsY(int dist) {
        return this.offsets(HORIZONTALS_Y, dist);
    }

    public BlockPos[] horizontalsY() {
        return this.horizontalsY(1);
    }

    public BlockPos[] horizontalsZ(int dist) {
        return this.offsets(HORIZONTALS_Z, dist);
    }

    public BlockPos[] horizontalsZ() {
        return this.horizontalsZ(1);
    }

    public List<BlockPos[]> horizontalsList(int dist) {
        return Lists.newArrayList((Object[])new BlockPos[][]{this.horizontalsX(dist), this.horizontalsY(dist), this.horizontalsZ(dist)});
    }

    public List<BlockPos[]> horizontalsList() {
        return this.horizontalsList(1);
    }

    public static EnumFacing[] getHorizontals(EnumFacing dir) {
        switch (dir) {
            case DOWN: {
                return HORIZONTALS_Y;
            }
            case UP: {
                return HORIZONTALS_Y;
            }
            case NORTH: {
                return HORIZONTALS_Z;
            }
            case SOUTH: {
                return HORIZONTALS_Z;
            }
            case WEST: {
                return HORIZONTALS_X;
            }
            case EAST: {
                return HORIZONTALS_X;
            }
        }
        return HORIZONTALS_Y;
    }

    public BlockPos[] axialsX(int dist) {
        return this.offsets(AXIALS_X, dist);
    }

    public BlockPos[] axialsX() {
        return this.axialsX(1);
    }

    public BlockPos[] axialsY(int dist) {
        return this.offsets(AXIALS_Y, dist);
    }

    public BlockPos[] axialsY() {
        return this.axialsY(1);
    }

    public BlockPos[] axialsZ(int dist) {
        return this.offsets(AXIALS_Z, dist);
    }

    public BlockPos[] axialsZ() {
        return this.axialsZ(1);
    }

    public List<BlockPos[]> axialsList(int dist) {
        return Lists.newArrayList((Object[])new BlockPos[][]{this.axialsX(dist), this.axialsY(dist), this.axialsZ(dist)});
    }

    public List<BlockPos[]> axialsList() {
        return this.axialsList(1);
    }

    public static List<EnumFacing[]> axialsDirList() {
        return Lists.newArrayList((Object[])new EnumFacing[][]{AXIALS_X, AXIALS_Y, AXIALS_Z});
    }

    public static EnumFacing[] getAxials(EnumFacing dir) {
        switch (dir) {
            case DOWN: {
                return AXIALS_Y;
            }
            case UP: {
                return AXIALS_Y;
            }
            case NORTH: {
                return AXIALS_Z;
            }
            case SOUTH: {
                return AXIALS_Z;
            }
            case WEST: {
                return AXIALS_X;
            }
            case EAST: {
                return AXIALS_X;
            }
        }
        return AXIALS_Y;
    }

    public BlockPos[] vertexDNW() {
        return this.offsets(VERTEX_DNW, 1);
    }

    public BlockPos[] vertexDNE() {
        return this.offsets(VERTEX_DNE, 1);
    }

    public BlockPos[] vertexDSW() {
        return this.offsets(VERTEX_DSW, 1);
    }

    public BlockPos[] vertexDSE() {
        return this.offsets(VERTEX_DSE, 1);
    }

    public BlockPos[] vertexUNW() {
        return this.offsets(VERTEX_UNW, 1);
    }

    public BlockPos[] vertexUNE() {
        return this.offsets(VERTEX_UNE, 1);
    }

    public BlockPos[] vertexUSW() {
        return this.offsets(VERTEX_USW, 1);
    }

    public BlockPos[] vertexUSE() {
        return this.offsets(VERTEX_USE, 1);
    }

    public List<BlockPos[]> vertexList() {
        return Lists.newArrayList((Object[])new BlockPos[][]{this.vertexDNW(), this.vertexDNE(), this.vertexDSW(), this.vertexDSE(), this.vertexUNW(), this.vertexUNE(), this.vertexUSW(), this.vertexUSE()});
    }

    public static List<EnumFacing[]> vertexDirList() {
        return Lists.newArrayList((Object[])new EnumFacing[][]{VERTEX_DNW, VERTEX_DNE, VERTEX_DSW, VERTEX_DSE, VERTEX_UNW, VERTEX_UNE, VERTEX_USW, VERTEX_USE});
    }

    public List<BlockPos> squareRing(int radius, int height) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (int i = -radius; i < radius; ++i) {
            posList.add(this.position(i, height, radius));
            posList.add(this.position(-i, height, -radius));
            posList.add(this.position(radius, height, -i));
            posList.add(this.position(-radius, height, i));
        }
        return posList;
    }

    public List<BlockPos> cutoffRing(int radius, int height) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (int i = -radius + 1; i < radius; ++i) {
            posList.add(this.position(i, height, radius));
            posList.add(this.position(-i, height, -radius));
            posList.add(this.position(radius, height, -i));
            posList.add(this.position(-radius, height, i));
        }
        return posList;
    }

    public List<BlockPos> squareTube(int radius, int height) {
        return CollectionHelper.concatenate(this.squareRing(radius - 1, height), this.squareRing(radius, height - 1), this.squareRing(radius, height + 1), this.squareRing(radius + 1, height));
    }

    public List<BlockPos> squareTubeDiagonals(int radius, int height) {
        return CollectionHelper.concatenate(this.squareRing(radius - 1, height - 1), this.squareRing(radius - 1, height + 1), this.squareRing(radius + 1, height - 1), this.squareRing(radius + 1, height + 1));
    }

    public List<BlockPos> squareTubeNotHidden(int radius, int height) {
        return CollectionHelper.concatenate(this.cutoffRing(radius - 1, height), this.squareRing(radius, height - 1), this.squareRing(radius, height + 1), this.squareRing(radius + 1, height));
    }

    public List<BlockPos> cuboid(int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.position(x1, y1, z1), (BlockPos)this.position(x2, y2, z2))) {
            posList.add(pos);
        }
        return posList;
    }

    public static String stringPos(BlockPos pos) {
        return "[" + pos.func_177958_n() + ", " + pos.func_177956_o() + ", " + pos.func_177952_p() + "]";
    }

    public static BlockPos[] getOtherPlaneCorners(BlockPos pos1, BlockPos pos2) {
        if (pos1.func_177958_n() == pos2.func_177958_n()) {
            return new BlockPos[]{new BlockPos(pos1.func_177958_n(), pos2.func_177956_o(), pos1.func_177952_p()), new BlockPos(pos1.func_177958_n(), pos1.func_177956_o(), pos2.func_177952_p())};
        }
        if (pos1.func_177956_o() == pos2.func_177956_o()) {
            return new BlockPos[]{new BlockPos(pos1.func_177958_n(), pos1.func_177956_o(), pos2.func_177952_p()), new BlockPos(pos2.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p())};
        }
        if (pos1.func_177952_p() == pos2.func_177952_p()) {
            return new BlockPos[]{new BlockPos(pos2.func_177958_n(), pos1.func_177956_o(), pos1.func_177952_p()), new BlockPos(pos1.func_177958_n(), pos2.func_177956_o(), pos1.func_177952_p())};
        }
        return new BlockPos[]{pos1, pos2};
    }
}

