/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.multiblock;

import nc.config.NCConfig;
import nc.recipe.ProcessorRecipeHandler;

public class HeatExchangerRecipes
extends ProcessorRecipeHandler {
    private static final String[] COOLANTS = new String[]{"", "redstone_", "quartz_", "gold_", "glowstone_", "lapis_", "diamond_", "liquidhelium_", "ender_", "cryotheum_", "iron_", "emerald_", "copper_", "tin_", "magnesium_"};

    public HeatExchangerRecipes() {
        super("heat_exchanger", 0, 1, 0, 1);
    }

    @Override
    public void addRecipes() {
        for (int i = 0; i < COOLANTS.length; ++i) {
            this.addRecipe(HeatExchangerRecipes.fluidStack(COOLANTS[i] + "nak_hot", 20), HeatExchangerRecipes.fluidStack(COOLANTS[i] + "nak", 20), NCConfig.salt_fission_cooling_rate[i] * NCConfig.heat_exchanger_coolant_mult, 700, 300);
        }
        this.addRecipe(HeatExchangerRecipes.fluidStack("water", 200), HeatExchangerRecipes.fluidStack("high_pressure_steam", 1000), 32000.0, 300, 1200);
        this.addRecipe(HeatExchangerRecipes.fluidStack("preheated_water", 200), HeatExchangerRecipes.fluidStack("high_pressure_steam", 1000), 16000.0, 400, 1200);
        if (!NCConfig.heat_exchanger_alternate_exhaust_recipe) {
            this.addRecipe(HeatExchangerRecipes.fluidStack("exhaust_steam", 1000), HeatExchangerRecipes.fluidStack("low_pressure_steam", 1000), 4000.0, 500, 800);
        } else {
            this.addRecipe(HeatExchangerRecipes.fluidStack("exhaust_steam", 1000), HeatExchangerRecipes.fluidStack("steam", 1000), 4000.0, 500, 800);
        }
        this.addRecipe(HeatExchangerRecipes.fluidStack("high_pressure_steam", 250), HeatExchangerRecipes.fluidStack("steam", 1000), 4000.0, 1200, 800);
        this.addRecipe(HeatExchangerRecipes.fluidStack("condensate_water", 1000), HeatExchangerRecipes.fluidStack("preheated_water", 1000), 32000.0, 300, 400);
    }
}

