/*
 * Decompiled with CFR 0.152.
 */
package nc.radiation;

import java.util.ArrayList;
import java.util.List;
import nc.config.NCConfig;
import nc.recipe.NCRecipes;
import nc.recipe.ProcessorRecipeHandler;
import nc.util.RegistryHelper;
import nc.util.StringHelper;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;

public class RadBlockEffects
extends ProcessorRecipeHandler {
    public static final List<MaterialQuery> MATERIAL_QUERIES = new ArrayList<MaterialQuery>();
    public static boolean hasRecipes = false;
    private static final String[] ARGS = new String[]{"isLiquid", "isSolid", "blocksLight", "blocksMovement", "getCanBurn", "isReplaceable", "isOpaque", "isToolNotRequired", "getPushReaction", "materialMapColor"};

    public RadBlockEffects() {
        super("rad_block_mutations", 1, 0, 1, 0);
    }

    @Override
    public void addRecipes() {
    }

    public static void init() {
        for (String effectInfo : NCConfig.radiation_block_effects) {
            IBlockState result;
            String s;
            int puncPos2;
            int puncPos = effectInfo.lastIndexOf(95);
            if (puncPos == -1 || (puncPos2 = (s = effectInfo.substring(0, puncPos)).lastIndexOf(95)) == -1 || (result = RegistryHelper.blockStateFromRegistry(s.substring(0, puncPos2))) == null) continue;
            effectInfo = effectInfo.substring(puncPos + 1);
            MaterialQuery query = new MaterialQuery(result, Double.parseDouble(s.substring(puncPos2 + 1)));
            boolean end = false;
            block1: while (!end) {
                for (int i = 0; i < ARGS.length; ++i) {
                    if (!StringHelper.beginsWith(effectInfo, ARGS[i])) continue;
                    puncPos = (effectInfo = effectInfo.substring(ARGS[i].length() + 1)).indexOf(44);
                    if (puncPos == -1) {
                        puncPos = effectInfo.length();
                        end = true;
                    }
                    String value = effectInfo.substring(0, puncPos);
                    if (i == 0) {
                        query.isLiquid = new Boolean(Boolean.parseBoolean(value));
                    } else if (i == 1) {
                        query.isSolid = new Boolean(Boolean.parseBoolean(value));
                    } else if (i == 2) {
                        query.blocksLight = new Boolean(Boolean.parseBoolean(value));
                    } else if (i == 3) {
                        query.blocksMovement = new Boolean(Boolean.parseBoolean(value));
                    } else if (i == 4) {
                        query.getCanBurn = new Boolean(Boolean.parseBoolean(value));
                    } else if (i == 5) {
                        query.isReplaceable = new Boolean(Boolean.parseBoolean(value));
                    } else if (i == 6) {
                        query.isOpaque = new Boolean(Boolean.parseBoolean(value));
                    } else if (i == 7) {
                        query.isToolNotRequired = new Boolean(Boolean.parseBoolean(value));
                    } else if (i == 8) {
                        if (value.equalsIgnoreCase("normal")) {
                            query.getPushReaction = EnumPushReaction.NORMAL;
                        } else if (value.equalsIgnoreCase("destroy")) {
                            query.getPushReaction = EnumPushReaction.DESTROY;
                        } else if (value.equalsIgnoreCase("block")) {
                            query.getPushReaction = EnumPushReaction.BLOCK;
                        } else if (value.equalsIgnoreCase("ignore")) {
                            query.getPushReaction = EnumPushReaction.IGNORE;
                        } else if (value.equalsIgnoreCase("pushOnly")) {
                            query.getPushReaction = EnumPushReaction.PUSH_ONLY;
                        }
                    } else if (i == 9) {
                        query.materialMapColor = new Integer(Integer.parseInt(value));
                    }
                    if (end) continue block1;
                    effectInfo = effectInfo.substring(puncPos + 1);
                    continue block1;
                }
            }
            MATERIAL_QUERIES.add(query);
        }
        hasRecipes = !NCRecipes.radiation_block_mutations.getRecipeList().isEmpty();
    }

    public static class MaterialQuery {
        public final IBlockState result;
        public final double threshold;
        public Boolean isLiquid = null;
        public Boolean isSolid = null;
        public Boolean blocksLight = null;
        public Boolean blocksMovement = null;
        public Boolean getCanBurn = null;
        public Boolean isReplaceable = null;
        public Boolean isOpaque = null;
        public Boolean isToolNotRequired = null;
        public EnumPushReaction getPushReaction = null;
        public Integer materialMapColor = null;

        public MaterialQuery(IBlockState result, double threshold) {
            this.result = result;
            this.threshold = threshold;
        }

        public boolean matches(Material target, double radiation) {
            return !(!(radiation >= this.threshold) || this.isLiquid != null && this.isLiquid.booleanValue() != target.func_76224_d() || this.isSolid != null && this.isSolid.booleanValue() != target.func_76220_a() || this.blocksLight != null && this.blocksLight.booleanValue() != target.func_76228_b() || this.blocksMovement != null && this.blocksMovement.booleanValue() != target.func_76230_c() || this.getCanBurn != null && this.getCanBurn.booleanValue() != target.func_76217_h() || this.isReplaceable != null && this.isReplaceable.booleanValue() != target.func_76222_j() || this.isOpaque != null && this.isOpaque.booleanValue() != target.func_76218_k() || this.isToolNotRequired != null && this.isToolNotRequired.booleanValue() != target.func_76229_l() || this.getPushReaction != null && this.getPushReaction != target.func_186274_m() || this.materialMapColor != null && this.materialMapColor != target.func_151565_r().field_76291_p);
        }
    }
}

