/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.heatExchanger;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Iterator;
import java.util.Set;
import nc.config.NCConfig;
import nc.multiblock.IMultiblockFluid;
import nc.multiblock.IMultiblockPart;
import nc.multiblock.MultiblockBase;
import nc.multiblock.TileBeefBase;
import nc.multiblock.container.ContainerHeatExchangerController;
import nc.multiblock.cuboidal.CuboidalMultiblockBase;
import nc.multiblock.heatExchanger.tile.TileHeatExchangerCondenserTube;
import nc.multiblock.heatExchanger.tile.TileHeatExchangerController;
import nc.multiblock.heatExchanger.tile.TileHeatExchangerTube;
import nc.multiblock.heatExchanger.tile.TileHeatExchangerVent;
import nc.multiblock.network.HeatExchangerUpdatePacket;
import nc.multiblock.validation.IMultiblockValidator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class HeatExchanger
extends CuboidalMultiblockBase<HeatExchangerUpdatePacket>
implements IMultiblockFluid {
    protected Set<TileHeatExchangerController> controllers = new ObjectOpenHashSet();
    protected Set<TileHeatExchangerVent> vents = new ObjectOpenHashSet();
    protected Set<TileHeatExchangerTube> tubes = new ObjectOpenHashSet();
    protected Set<TileHeatExchangerCondenserTube> condenserTubes = new ObjectOpenHashSet();
    protected TileHeatExchangerController controller;
    protected int updateCount = 0;
    public boolean isHeatExchangerOn;
    public boolean computerActivated;
    public double fractionOfTubesActive;
    public double efficiency;
    public double maxEfficiency;

    public HeatExchanger(World world) {
        super(world);
    }

    public Set<TileHeatExchangerController> getControllers() {
        return this.controllers;
    }

    public Set<TileHeatExchangerVent> getVents() {
        return this.vents;
    }

    public Set<TileHeatExchangerTube> getTubes() {
        return this.tubes;
    }

    public Set<TileHeatExchangerCondenserTube> getCondenserTubes() {
        return this.condenserTubes;
    }

    @Override
    protected int getMinimumInteriorLength() {
        return NCConfig.heat_exchanger_min_size;
    }

    @Override
    protected int getMaximumInteriorLength() {
        return NCConfig.heat_exchanger_max_size;
    }

    @Override
    public void onAttachedPartWithMultiblockData(IMultiblockPart part, NBTTagCompound data) {
        this.syncDataFrom(data, TileBeefBase.SyncReason.FullSync);
    }

    @Override
    protected void onBlockAdded(IMultiblockPart newPart) {
        if (newPart instanceof TileHeatExchangerController) {
            this.controllers.add((TileHeatExchangerController)newPart);
        }
        if (newPart instanceof TileHeatExchangerVent) {
            this.vents.add((TileHeatExchangerVent)newPart);
        }
        if (newPart instanceof TileHeatExchangerTube) {
            this.tubes.add((TileHeatExchangerTube)newPart);
        }
        if (newPart instanceof TileHeatExchangerCondenserTube) {
            this.condenserTubes.add((TileHeatExchangerCondenserTube)newPart);
        }
    }

    @Override
    protected void onBlockRemoved(IMultiblockPart oldPart) {
        if (oldPart instanceof TileHeatExchangerController) {
            this.controllers.remove(oldPart);
        }
        if (oldPart instanceof TileHeatExchangerVent) {
            this.vents.remove(oldPart);
        }
        if (oldPart instanceof TileHeatExchangerTube) {
            this.tubes.remove(oldPart);
        }
        if (oldPart instanceof TileHeatExchangerCondenserTube) {
            this.condenserTubes.remove(oldPart);
        }
    }

    @Override
    protected void onMachineAssembled() {
        Iterator<TileHeatExchangerController> iterator = this.controllers.iterator();
        while (iterator.hasNext()) {
            TileHeatExchangerController contr;
            this.controller = contr = iterator.next();
        }
        this.onHeatExchangerFormed();
    }

    @Override
    protected void onMachineRestored() {
        this.onHeatExchangerFormed();
    }

    protected void onHeatExchangerFormed() {
        this.setIsHeatExchangerOn();
        for (TileHeatExchangerTube tube : this.tubes) {
            tube.updateFlowDir();
        }
        for (TileHeatExchangerCondenserTube condenserTube : this.condenserTubes) {
            condenserTube.updateAdjacentTemperatures();
        }
        this.updateHeatExchangerStats();
    }

    @Override
    protected void onMachinePaused() {
    }

    @Override
    protected void onMachineDisassembled() {
        this.isHeatExchangerOn = false;
        if (this.controller != null) {
            this.controller.updateBlockState(false);
        }
        this.maxEfficiency = 0.0;
        this.efficiency = 0.0;
        this.fractionOfTubesActive = 0.0;
    }

    @Override
    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        if (this.controllers.size() == 0) {
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.no_controller", null, new Object[0]);
            return false;
        }
        if (this.controllers.size() > 1) {
            validatorCallback.setLastError("nuclearcraft.multiblock_validation.too_many_controllers", null, new Object[0]);
            return false;
        }
        return super.isMachineWhole(validatorCallback);
    }

    @Override
    protected void onAssimilate(MultiblockBase assimilated) {
    }

    @Override
    protected void onAssimilated(MultiblockBase assimilator) {
    }

    @Override
    protected boolean updateServer() {
        if (this.shouldUpdate()) {
            this.updateHeatExchangerStats();
        }
        if (this.shouldUpdate()) {
            this.sendUpdateToListeningPlayers();
        }
        this.incrementUpdateCount();
        return true;
    }

    public void setIsHeatExchangerOn() {
        boolean oldIsHeatExchangerOn = this.isHeatExchangerOn;
        boolean bl = this.isHeatExchangerOn = (this.isRedstonePowered() || this.computerActivated) && this.isAssembled();
        if (this.isHeatExchangerOn != oldIsHeatExchangerOn) {
            if (this.controller != null) {
                this.controller.updateBlockState(this.isHeatExchangerOn);
            }
            this.sendUpdateToAllPlayers();
        }
    }

    protected boolean isRedstonePowered() {
        return this.controller != null && this.controller.checkIsRedstonePowered(this.WORLD, this.controller.func_174877_v());
    }

    protected void updateHeatExchangerStats() {
        int numberOfTubes = this.tubes.size() + this.condenserTubes.size();
        if (numberOfTubes < 1) {
            this.maxEfficiency = 0.0;
            this.efficiency = 0.0;
            this.fractionOfTubesActive = 0.0;
            return;
        }
        int activeCount = 0;
        int efficiencyCount = 0;
        int maxEfficiencyCount = 0;
        for (TileHeatExchangerTube tube : this.tubes) {
            int[] eff = tube.checkPosition();
            if (eff[0] > 0) {
                ++activeCount;
            }
            efficiencyCount += eff[0];
            maxEfficiencyCount += eff[1];
        }
        for (TileHeatExchangerCondenserTube condenserTube : this.condenserTubes) {
            int eff = condenserTube.checkPosition();
            if (eff > 0) {
                ++activeCount;
            }
            efficiencyCount += eff;
            maxEfficiencyCount += eff;
        }
        this.fractionOfTubesActive = (double)activeCount / (double)numberOfTubes;
        this.efficiency = activeCount == 0 ? 0.0 : (double)efficiencyCount / (double)activeCount;
        this.maxEfficiency = (double)maxEfficiencyCount / (double)numberOfTubes;
    }

    protected void incrementUpdateCount() {
        ++this.updateCount;
        this.updateCount %= HeatExchanger.updateTime();
    }

    protected static int updateTime() {
        return NCConfig.machine_update_rate;
    }

    protected boolean shouldUpdate() {
        return this.updateCount == 0;
    }

    @Override
    protected void updateClient() {
    }

    @Override
    protected void syncDataTo(NBTTagCompound data, TileBeefBase.SyncReason syncReason) {
        data.func_74757_a("isHeatExchangerOn", this.isHeatExchangerOn);
        data.func_74757_a("computerActivated", this.computerActivated);
        data.func_74780_a("fractionOfTubesActive", this.fractionOfTubesActive);
        data.func_74780_a("efficiency", this.efficiency);
        data.func_74780_a("maxEfficiency", this.maxEfficiency);
    }

    @Override
    protected void syncDataFrom(NBTTagCompound data, TileBeefBase.SyncReason syncReason) {
        this.isHeatExchangerOn = data.func_74767_n("isHeatExchangerOn");
        this.computerActivated = data.func_74767_n("computerActivated");
        this.fractionOfTubesActive = data.func_74769_h("fractionOfTubesActive");
        this.efficiency = data.func_74769_h("efficiency");
        this.maxEfficiency = data.func_74769_h("maxEfficiency");
    }

    @Override
    protected HeatExchangerUpdatePacket getUpdatePacket() {
        return new HeatExchangerUpdatePacket(this.controller.func_174877_v(), this.isHeatExchangerOn, this.fractionOfTubesActive, this.efficiency, this.maxEfficiency);
    }

    @Override
    public void onPacket(HeatExchangerUpdatePacket message) {
        this.isHeatExchangerOn = message.isHeatExchangerOn;
        this.fractionOfTubesActive = message.fractionOfTubesActive;
        this.efficiency = message.efficiency;
        this.maxEfficiency = message.maxEfficiency;
    }

    public Container getContainer(EntityPlayer player) {
        return new ContainerHeatExchangerController(player, this.controller);
    }

    @Override
    public void clearAllFluids() {
        for (TileHeatExchangerVent vent : this.vents) {
            vent.clearAllTanks();
        }
        for (TileHeatExchangerTube tube : this.tubes) {
            tube.clearAllTanks();
        }
        for (TileHeatExchangerCondenserTube condenserTube : this.condenserTubes) {
            condenserTube.clearAllTanks();
        }
    }

    @Override
    protected boolean isBlockGoodForInterior(World world, int x, int y, int z, IMultiblockValidator validatorCallback) {
        return true;
    }
}

