/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.extraalchemy.potion.potion;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import zabi.minecraft.extraalchemy.ExtraAlchemy;
import zabi.minecraft.extraalchemy.ModConfig;
import zabi.minecraft.extraalchemy.lib.Log;
import zabi.minecraft.extraalchemy.potion.PotionBase;
import zabi.minecraft.extraalchemy.potion.PotionReference;

public class PotionCheatDeath
extends PotionBase {
    protected static List<ItemStack> noItems = ImmutableList.copyOf(new ArrayList());
    private static DamageSource DEATH_REVENGE = new DamageSource("death_revenge"){

        public ITextComponent func_151519_b(EntityLivingBase entityLivingBaseIn) {
            return new TextComponentTranslation("death.attack." + this.field_76373_n + ".player", new Object[]{entityLivingBaseIn.func_145748_c_(), entityLivingBaseIn.func_145748_c_()});
        }
    };
    public static ArrayList<String> blacklist = new ArrayList();

    public int func_76401_j() {
        if (ModConfig.client.rainbowCheatDeath) {
            return ExtraAlchemy.proxy.getRainbow(super.func_76401_j());
        }
        return super.func_76401_j();
    }

    public PotionCheatDeath(boolean isBadEffectIn, int liquidColorIn) {
        super(isBadEffectIn, liquidColorIn, "cheatDeath_" + (isBadEffectIn ? "active" : "quiescent"));
        this.func_76399_b(this.func_76398_f() ? 6 : 7, 0);
    }

    public void func_76394_a(EntityLivingBase e, int amp) {
        super.func_76394_a(e, amp);
        if (e instanceof EntityPlayer && ((EntityPlayer)e).func_175149_v()) {
            return;
        }
        if (!e.func_130014_f_().field_72995_K && !e.field_70128_L) {
            int duration = e.func_70660_b((Potion)PotionReference.INSTANCE.CHEAT_DEATH_POTION_ACTIVE).func_76459_b();
            if (ModConfig.options.cheatDeathRandom) {
                double probability = 0.01;
                if (duration < 200) {
                    probability = 0.05;
                } else if (duration < 400) {
                    probability = 0.0125;
                }
                double rand = e.func_70681_au().nextDouble();
                Log.i(probability + " " + rand);
                if (rand < probability) {
                    e.func_70097_a(DEATH_REVENGE, 2.1474836E9f);
                    Log.d("Applying death at: " + duration + " ticks remaining. r" + rand + "p" + probability);
                }
            } else {
                e.func_70097_a(DEATH_REVENGE, 2.1474836E9f);
            }
        }
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return this.func_76398_f() && (ModConfig.options.cheatDeathRandom && duration % 10 == 0 || duration == 1);
    }

    static {
        blacklist.add(PotionCheatDeath.DEATH_REVENGE.field_76373_n);
        blacklist.add("bloodMagic");
    }

    public static class PotionCheatDeathHandler {
        @SubscribeEvent(receiveCanceled=false, priority=EventPriority.HIGH)
        public void onLivingDeath(LivingDeathEvent evt) {
            if (blacklist.contains(evt.getSource().field_76373_n)) {
                Log.d("Damage in blacklist, ignoring cheat death protection");
                return;
            }
            if (evt.getEntityLiving().func_70660_b((Potion)PotionReference.INSTANCE.CHEAT_DEATH_POTION_ACTIVE) == null && evt.getEntityLiving().func_70660_b((Potion)PotionReference.INSTANCE.CHEAT_DEATH_POTION) != null && !evt.getSource().func_76357_e()) {
                evt.setCanceled(true);
                Log.d("Prevented death, good effect to bad");
                evt.getEntityLiving().func_70606_j(evt.getEntityLiving().func_110138_aP() / 2.0f + 1.0f);
                evt.getEntityLiving().func_70690_d(new PotionEffect(PotionReference.INSTANCE.CHEAT_DEATH_POTION_ACTIVE, evt.getEntityLiving().func_70660_b((Potion)PotionReference.INSTANCE.CHEAT_DEATH_POTION).func_76459_b() / 2, 0){

                    public List<ItemStack> getCurativeItems() {
                        return noItems;
                    }
                });
                evt.getEntityLiving().func_184589_d((Potion)PotionReference.INSTANCE.CHEAT_DEATH_POTION);
                return;
            }
            if (evt.getEntityLiving().func_70660_b((Potion)PotionReference.INSTANCE.CHEAT_DEATH_POTION) == null && evt.getEntityLiving().func_70660_b((Potion)PotionReference.INSTANCE.CHEAT_DEATH_POTION_ACTIVE) != null && evt.getSource() != DEATH_REVENGE && !evt.getSource().func_76357_e()) {
                evt.getEntityLiving().func_70606_j(evt.getEntityLiving().func_110138_aP() / 5.0f + 1.0f);
                evt.setCanceled(true);
                Log.d("Prevented death, bad effect");
            }
        }

        @SubscribeEvent
        public void onLivingDrops(LivingDropsEvent evt) {
            if (ModConfig.options.hardcoreCheatDeath && evt.getEntityLiving().func_70660_b((Potion)PotionReference.INSTANCE.CHEAT_DEATH_POTION_ACTIVE) != null) {
                evt.setCanceled(true);
                Log.d("Stopped items from dropping");
            }
        }
    }
}

