/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.monster.boss;

import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.entities.ai.combat.AICultistHurtByTarget;
import thaumcraft.common.entities.ai.combat.AILongRangeAttack;
import thaumcraft.common.entities.monster.boss.EntityThaumcraftBoss;
import thaumcraft.common.entities.monster.cult.EntityCultist;
import thaumcraft.common.entities.monster.cult.EntityCultistCleric;
import thaumcraft.common.entities.monster.cult.EntityCultistKnight;
import thaumcraft.common.entities.monster.mods.ChampionModifier;
import thaumcraft.common.entities.projectile.EntityGolemOrb;
import thaumcraft.common.lib.SoundsTC;
import thaumcraft.common.lib.utils.EntityUtils;

public class EntityCultistLeader
extends EntityThaumcraftBoss
implements IRangedAttackMob {
    private static final DataParameter<Byte> NAME = EntityDataManager.func_187226_a(EntityCultistLeader.class, (DataSerializer)DataSerializers.field_187191_a);
    String[] titles = new String[]{"Alberic", "Anselm", "Bastian", "Beturian", "Chabier", "Chorache", "Chuse", "Dodorol", "Ebardo", "Ferrando", "Fertus", "Guillen", "Larpe", "Obano", "Zelipe"};

    public EntityCultistLeader(World p_i1745_1_) {
        super(p_i1745_1_);
        this.func_70105_a(0.75f, 2.25f);
        this.field_70728_aV = 40;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AILongRangeAttack(this, 16.0, 1.0, 30, 40, 24.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.1, false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AICultistHurtByTarget((EntityCreature)this, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.32);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(150.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(NAME, (Object)0);
    }

    @Override
    public void generateName() {
        int t = (int)this.func_110148_a(ThaumcraftApiHelper.CHAMPION_MOD).func_111126_e();
        if (t >= 0) {
            this.func_96094_a(String.format(I18n.func_74838_a((String)"entity.Thaumcraft.CultistLeader.name.custom"), this.getTitle(), ChampionModifier.mods[t].getModNameLocalized()));
        }
    }

    private String getTitle() {
        return this.titles[(Byte)this.func_184212_Q().func_187225_a(NAME)];
    }

    private void setTitle(int title) {
        this.func_184212_Q().func_187227_b(NAME, (Object)((byte)title));
    }

    @Override
    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74774_a("title", ((Byte)this.func_184212_Q().func_187225_a(NAME)).byteValue());
    }

    @Override
    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.setTitle(nbt.func_74771_c("title"));
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ItemsTC.crimsonPraetorHelm));
        this.func_184201_a(EntityEquipmentSlot.CHEST, new ItemStack(ItemsTC.crimsonPraetorChest));
        this.func_184201_a(EntityEquipmentSlot.LEGS, new ItemStack(ItemsTC.crimsonPraetorLegs));
        this.func_184201_a(EntityEquipmentSlot.FEET, new ItemStack(ItemsTC.crimsonBoots));
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.EASY) {
            this.func_184611_a(this.func_184600_cs(), new ItemStack(ItemsTC.voidSword));
        } else {
            this.func_184611_a(this.func_184600_cs(), new ItemStack(ItemsTC.crimsonBlade));
        }
    }

    @Override
    protected void func_180483_b(DifficultyInstance diff) {
        float f = diff.func_180170_c();
        if (this.func_184614_ca() != null && this.field_70146_Z.nextFloat() < 0.5f * f) {
            EnchantmentHelper.func_77504_a((Random)this.field_70146_Z, (ItemStack)this.func_184614_ca(), (int)((int)(7.0f + f * (float)this.field_70146_Z.nextInt(22))), (boolean)false);
        }
    }

    @Override
    public boolean func_184191_r(Entity el) {
        return el instanceof EntityCultist || el instanceof EntityCultistLeader;
    }

    public boolean func_70686_a(Class clazz) {
        if (clazz == EntityCultistCleric.class || clazz == EntityCultistLeader.class || clazz == EntityCultistKnight.class) {
            return false;
        }
        return super.func_70686_a(clazz);
    }

    protected Item func_146068_u() {
        return Item.func_150899_d((int)0);
    }

    @Override
    protected void func_70628_a(boolean flag, int i) {
        this.func_70099_a(new ItemStack(ItemsTC.lootBag, 1, 2), 1.5f);
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance diff, IEntityLivingData data) {
        this.func_180481_a(diff);
        this.func_180483_b(diff);
        this.setTitle(this.field_70146_Z.nextInt(this.titles.length));
        return super.func_180482_a(diff, data);
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
        List<EntityCultist> list = EntityUtils.getEntitiesInRange(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, (Entity)this, EntityCultist.class, 8.0);
        for (Entity entity : list) {
            try {
                if (!(entity instanceof EntityCultist) || ((EntityCultist)entity).func_70644_a(MobEffects.field_76428_l)) continue;
                ((EntityCultist)entity).func_70690_d(new PotionEffect(MobEffects.field_76428_l, 60, 1));
            }
            catch (Exception exception) {}
        }
    }

    public void func_82196_d(EntityLivingBase entitylivingbase, float f) {
        if (this.func_70685_l((Entity)entitylivingbase)) {
            this.func_184609_a(this.func_184600_cs());
            this.func_70671_ap().func_75650_a(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 2.0f), entitylivingbase.field_70161_v, 30.0f, 30.0f);
            EntityGolemOrb blast = new EntityGolemOrb(this.field_70170_p, (EntityLivingBase)this, entitylivingbase, true);
            blast.field_70165_t += blast.field_70159_w / 2.0;
            blast.field_70161_v += blast.field_70179_y / 2.0;
            blast.func_70107_b(blast.field_70165_t, blast.field_70163_u, blast.field_70161_v);
            double d0 = entitylivingbase.field_70165_t - this.field_70165_t;
            double d1 = entitylivingbase.func_174813_aQ().field_72338_b + (double)(entitylivingbase.field_70131_O / 2.0f) - (this.field_70163_u + (double)(this.field_70131_O / 2.0f));
            double d2 = entitylivingbase.field_70161_v - this.field_70161_v;
            blast.func_70186_c(d0, d1 + 2.0, d2, 0.66f, 3.0f);
            this.func_184185_a(SoundsTC.egattack, 1.0f, 1.0f + this.field_70146_Z.nextFloat() * 0.1f);
            this.field_70170_p.func_72838_d((Entity)blast);
        }
    }

    public void func_70656_aK() {
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.05;
                double d1 = this.field_70146_Z.nextGaussian() * 0.05;
                double d2 = this.field_70146_Z.nextGaussian() * 0.05;
                double d3 = 2.0;
                FXDispatcher.INSTANCE.cultistSpawn(this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N + d0 * d3, this.field_70163_u + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O) + d1 * d3, this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N + d2 * d3, d0, d1, d2);
            }
        } else {
            this.field_70170_p.func_72960_a((Entity)this, (byte)20);
        }
    }

    public void func_184724_a(boolean swingingArms) {
    }
}

