/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.minerva.client.hud;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import zabi.minecraft.minerva.client.hud.EnumHudAnchor;
import zabi.minecraft.minerva.client.hud.GuiEditMode;
import zabi.minecraft.minerva.client.hud.IHudComponent;
import zabi.minecraft.minerva.client.hud.internal.ComponentWrapper;
import zabi.minecraft.minerva.client.hud.internal.DataStorage;

@SideOnly(value=Side.CLIENT)
public class HudController {
    public static final HudController INSTANCE = new HudController();
    public ArrayList<ComponentWrapper> components = new ArrayList();
    public ComponentWrapper movingComponent = null;
    public ComponentWrapper resizingComponent = null;
    private boolean shouldShowHud = false;
    private int grabX = 0;
    private int grabY = 0;
    private long lastMouseEvent = 0L;

    private HudController() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void drawRedOverlay(double x, double y, int w, int h) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buff = tessellator.func_178180_c();
        buff.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        buff.func_181662_b(x, y + (double)h, 0.0).func_181666_a(0.8f, 0.0f, 0.0f, 0.4f).func_181675_d();
        buff.func_181662_b(x + (double)w, y + (double)h, 0.0).func_181666_a(0.8f, 0.0f, 0.0f, 0.4f).func_181675_d();
        buff.func_181662_b(x + (double)w, y, 0.0).func_181666_a(0.8f, 0.0f, 0.0f, 0.4f).func_181675_d();
        buff.func_181662_b(x, y, 0.0).func_181666_a(0.8f, 0.0f, 0.0f, 0.4f).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public static void registerNewComponent(IHudComponent hud, int defaultX, int defaultY, int defaultWidth, int defaultHeight, EnumHudAnchor defaultHorizontalAnchor, EnumHudAnchor defaultVerticalAnchor, boolean visibleByDefault) {
        ComponentWrapper wrapper = new ComponentWrapper(hud, defaultX, defaultY, defaultWidth, defaultHeight, defaultHorizontalAnchor, defaultVerticalAnchor, visibleByDefault);
        HudController.INSTANCE.components.add(wrapper);
        DataStorage.getInstance().restoreData(wrapper);
    }

    @SubscribeEvent
    public void tickClient(TickEvent.ClientTickEvent evt) {
        if (this.shouldShowHud) {
            this.shouldShowHud = false;
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiEditMode());
        }
    }

    @SubscribeEvent
    public void renderEvent(RenderGameOverlayEvent evt) {
        if (!this.isEditModeActive() && evt.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            this.render(evt.getPartialTicks());
        }
    }

    @SubscribeEvent
    public void handleMouse(GuiScreenEvent.MouseInputEvent evt) {
        if (!Mouse.getEventButtonState() && Mouse.getEventButton() != -1 && !this.isEditModeActive() && this.lastMouseEvent != Mouse.getEventNanoseconds()) {
            ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
            int mouseX = Mouse.getX() * sr.func_78326_a() / Minecraft.func_71410_x().field_71443_c;
            int mouseY = sr.func_78328_b() - Mouse.getY() * sr.func_78328_b() / Minecraft.func_71410_x().field_71440_d - 1;
            this.onMouseInteraction(mouseX, mouseY, Mouse.getEventButton());
            this.lastMouseEvent = Mouse.getEventNanoseconds();
        }
    }

    public void render(float pticks) {
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen == null || currentScreen instanceof GuiChat || currentScreen instanceof GuiEditMode) {
            ComponentWrapper hud;
            ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
            int screenWidth = sr.func_78326_a();
            int screenHeight = sr.func_78328_b();
            int mouseX = Mouse.getX() * sr.func_78326_a() / Minecraft.func_71410_x().field_71443_c;
            int mouseY = sr.func_78328_b() - Mouse.getY() * sr.func_78328_b() / Minecraft.func_71410_x().field_71440_d - 1;
            this.components.forEach(c -> this.drawComponent((ComponentWrapper)c, screenWidth, screenHeight, mouseX, mouseY));
            if (this.isEditModeActive() && this.movingComponent != null) {
                GlStateManager.func_179147_l();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.6f);
                this.movingComponent.drawAt(mouseX - this.grabX, mouseY - this.grabY, this.movingComponent.getStatus().getWidth(), this.movingComponent.getStatus().getHeight(), IHudComponent.RenderMode.MOVING);
                GlStateManager.func_179084_k();
                this.drawAnchor(mouseX - this.grabX, mouseY - this.grabY, this.movingComponent.getStatus().getWidth(), this.movingComponent.getStatus().getHeight(), false, screenWidth, screenHeight);
            } else if (Minecraft.func_71410_x().field_71462_r != null && (hud = this.getComponentAt(mouseX, mouseY, !this.isEditModeActive())) != null) {
                int effectiveMouseY = mouseY;
                if (effectiveMouseY < 18) {
                    effectiveMouseY = 18;
                }
                if (this.isEditModeActive()) {
                    if (this.movingComponent == null) {
                        this.drawEditTooltip(hud, mouseX, effectiveMouseY, currentScreen);
                    }
                } else if (currentScreen instanceof GuiChat) {
                    this.drawHudTooltip(hud, mouseX, effectiveMouseY, currentScreen);
                }
            }
            GlStateManager.func_179147_l();
        }
        GlStateManager.func_179140_f();
    }

    public void drawComponent(ComponentWrapper c, int screenWidth, int screenHeight, int mouseX, int mouseY) {
        if (this.isEditModeActive()) {
            this.drawAnchor(c.getStatus().getX(), c.getStatus().getY(), c.getStatus().getWidth(), c.getStatus().getHeight(), true, screenWidth, screenHeight);
        }
        if (c.getStatus().isEnabled() && c.isShown() || this.isEditModeActive()) {
            c.drawAt(c.getStatus().getX(), c.getStatus().getY(), c.getStatus().getWidth(), c.getStatus().getHeight(), this.isEditModeActive() ? IHudComponent.RenderMode.DUMMY : IHudComponent.RenderMode.NORMAL);
        }
        if (this.isEditModeActive() && !c.getStatus().isEnabled()) {
            HudController.drawRedOverlay(c.getStatus().getX(), c.getStatus().getY(), c.getStatus().getWidth(), c.getStatus().getHeight());
        }
    }

    private void drawEditTooltip(ComponentWrapper hud, int mouseX, int mouseY, GuiScreen screen) {
        if (screen != null) {
            ArrayList ttp = Lists.newArrayList((Object[])new String[]{TextFormatting.BOLD + I18n.func_135052_a((String)hud.getTitleTranslationKey(), (Object[])new Object[0]), "", TextFormatting.ITALIC.toString() + TextFormatting.GRAY + I18n.func_135052_a((String)this.getModName(hud), (Object[])new Object[0]), ""});
            if (hud.canMove()) {
                ttp.add(I18n.func_135052_a((String)"gui.mvguicfg.pick", (Object[])new Object[0]));
            }
            if (hud.canHide()) {
                ttp.add(I18n.func_135052_a((String)"gui.mvguicfg.hide", (Object[])new Object[0]));
            }
            if (hud.canResize()) {
                ttp.add(I18n.func_135052_a((String)"gui.mvguicfg.size", (Object[])new Object[0]));
            }
            ttp.add(I18n.func_135052_a((String)"gui.mvguicfg.orig", (Object[])new Object[0]));
            ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
            GuiUtils.drawHoveringText((List)ttp, (int)mouseX, (int)mouseY, (int)sr.func_78326_a(), (int)sr.func_78328_b(), (int)(sr.func_78326_a() / 2), (FontRenderer)Minecraft.func_71410_x().field_71466_p);
        }
    }

    private String getModName(ComponentWrapper hud) {
        ModContainer mod = (ModContainer)Loader.instance().getIndexedModList().get(hud.getIdentifier().func_110624_b());
        if (mod != null) {
            return mod.getName();
        }
        return hud.getIdentifier().func_110624_b();
    }

    private void drawHudTooltip(ComponentWrapper hud, int mouseX, int mouseY, GuiScreen screen) {
        if (hud.getStatus().isEnabled() && hud.isShown() && screen != null) {
            List<String> ttip = hud.getTooltip((ITooltipFlag)(Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
            ArrayList lines = Lists.newArrayList((Object[])new String[]{TextFormatting.BOLD + I18n.func_135052_a((String)hud.getTitleTranslationKey(), (Object[])new Object[0])});
            if (ttip != null) {
                lines.add("");
                lines.addAll(ttip);
            }
            ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
            GuiUtils.drawHoveringText((List)lines, (int)mouseX, (int)mouseY, (int)sr.func_78326_a(), (int)sr.func_78328_b(), (int)(sr.func_78326_a() / 2), (FontRenderer)Minecraft.func_71410_x().field_71466_p);
        }
    }

    private void drawAnchor(int i, int j, int w, int h, boolean fixed, int screenWidth, int screenHeight) {
        EnumHudAnchor hor = this.getHorizontalAlignmentForPoint(i, w, screenWidth);
        EnumHudAnchor ver = this.getVerticalAlignmentForPoint(j, h, screenHeight);
        this.drawAnchor(i, j, w, h, fixed, hor, ver, screenWidth, screenHeight);
    }

    private void drawAnchor(int i, int j, int w, int h, boolean fixed, EnumHudAnchor hor, EnumHudAnchor ver, int screenWidth, int screenHeight) {
        int k = j;
        int sourceX = 0;
        int sourceY = 0;
        if (hor == EnumHudAnchor.CENTER_ABSOLUTE || hor == EnumHudAnchor.CENTER_RELATIVE) {
            sourceX = screenWidth / 2;
            i += w / 2;
        } else if (hor == EnumHudAnchor.END_ABSOLUTE || hor == EnumHudAnchor.END_RELATIVE) {
            sourceX = screenWidth;
            i += w;
        }
        if (ver == EnumHudAnchor.CENTER_ABSOLUTE || ver == EnumHudAnchor.CENTER_RELATIVE) {
            sourceY = screenHeight / 2;
            k += h / 2;
        } else if (ver == EnumHudAnchor.END_ABSOLUTE || ver == EnumHudAnchor.END_RELATIVE) {
            sourceY = screenHeight;
            k += h;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179140_f();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buf = tessellator.func_178180_c();
        GlStateManager.func_187441_d((float)3.0f);
        buf.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        if (fixed) {
            buf.func_181662_b((double)sourceX, (double)sourceY, 0.0).func_181666_a(0.0f, 0.8f, 0.0f, 1.0f).func_181675_d();
            buf.func_181662_b((double)i, (double)k, 0.0).func_181666_a(0.0f, 0.8f, 0.0f, 1.0f).func_181675_d();
        } else {
            buf.func_181662_b((double)sourceX, (double)sourceY, 0.0).func_181666_a(0.8f, 0.8f, 0.0f, 0.7f).func_181675_d();
            buf.func_181662_b((double)i, (double)k, 0.0).func_181666_a(0.8f, 0.8f, 0.0f, 0.7f).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    public void onMouseInteraction(int clickX, int clickY, int mouseButton) {
        if (this.isEditModeActive()) {
            ComponentWrapper hud;
            ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
            boolean clickIntercepted = false;
            if (this.movingComponent != null) {
                clickIntercepted = true;
                EnumHudAnchor hor = this.getHorizontalAlignmentForPoint(clickX - this.grabX, this.movingComponent.getStatus().getWidth(), sr.func_78326_a());
                EnumHudAnchor ver = this.getVerticalAlignmentForPoint(clickY - this.grabY, this.movingComponent.getStatus().getHeight(), sr.func_78328_b());
                this.movingComponent.getStatus().setPosition(hor.pixelToData(clickX - this.grabX, this.movingComponent.getStatus().getWidth(), sr.func_78326_a()), ver.pixelToData(clickY - this.grabY, this.movingComponent.getStatus().getHeight(), sr.func_78328_b()), hor, ver);
                DataStorage.getInstance().updateData(this.movingComponent);
                this.movingComponent.onMoved(this.movingComponent.getStatus().getX(), this.movingComponent.getStatus().getY());
                this.movingComponent = null;
            }
            if (!clickIntercepted && (hud = this.getComponentAt(clickX, clickY, false)) != null) {
                switch (mouseButton) {
                    case 0: {
                        this.handleLeftClick(clickX, clickY, hud);
                        break;
                    }
                    case 1: {
                        this.handleRightClick(hud, clickX, clickY);
                        break;
                    }
                    case 2: {
                        this.handleMidClick(hud, clickX, clickY);
                        break;
                    }
                }
            }
        } else {
            ComponentWrapper hud = this.getComponentAt(clickX, clickY, true);
            if (hud != null) {
                hud.onClick(clickX, clickY);
            }
        }
    }

    private void handleMidClick(ComponentWrapper hud, int clickX, int clickY) {
        if (hud.canResize()) {
            hud.getStatus().scaleUp();
            DataStorage.getInstance().updateData(hud);
            hud.onResized(hud.getStatus().getWidth(), hud.getStatus().getHeight());
        }
    }

    private void handleRightClick(ComponentWrapper hud, int clickX, int clickY) {
        if (hud.canResize()) {
            hud.getStatus().scaleDown();
            DataStorage.getInstance().updateData(hud);
            hud.onResized(hud.getStatus().getWidth(), hud.getStatus().getHeight());
        }
    }

    private void handleLeftClick(int clickX, int clickY, ComponentWrapper hud) {
        if (this.resizingComponent != null) {
            this.resizingComponent = null;
        } else if (GuiScreen.func_175283_s()) {
            hud.getStatus().reset();
            DataStorage.getInstance().updateData(hud);
            hud.onMoved(hud.getStatus().getX(), hud.getStatus().getY());
            hud.onResized(hud.getStatus().getWidth(), hud.getStatus().getHeight());
        } else if (GuiScreen.func_146272_n()) {
            if (hud.canHide()) {
                hud.getStatus().toggle();
                DataStorage.getInstance().updateData(hud);
                hud.onVisibilityChanged(hud.getStatus().isEnabled());
            }
        } else if (hud.canMove()) {
            this.movingComponent = hud;
            this.grabX = clickX - hud.getStatus().getX();
            this.grabY = clickY - hud.getStatus().getY();
        }
    }

    private EnumHudAnchor getVerticalAlignmentForPoint(int y, int h, int scaledHeight) {
        if (y + h < scaledHeight * 1 / 3) {
            return EnumHudAnchor.START_ABSOULTE;
        }
        if (y > scaledHeight * 2 / 3) {
            return EnumHudAnchor.END_ABSOLUTE;
        }
        return EnumHudAnchor.CENTER_ABSOLUTE;
    }

    private EnumHudAnchor getHorizontalAlignmentForPoint(int x, int w, int scaledWidth) {
        if (x + w < scaledWidth * 1 / 3) {
            return EnumHudAnchor.START_ABSOULTE;
        }
        if (x > scaledWidth * 2 / 3) {
            return EnumHudAnchor.END_ABSOLUTE;
        }
        return EnumHudAnchor.CENTER_ABSOLUTE;
    }

    public ComponentWrapper getComponentAt(int x, int y, boolean onlyActive) {
        for (ComponentWrapper c : this.components) {
            if (onlyActive && (!c.isShown() || !c.getStatus().isEnabled()) || !this.isHovered(c, x, y)) continue;
            return c;
        }
        return null;
    }

    public boolean isEditModeActive() {
        return Minecraft.func_71410_x().field_71462_r instanceof GuiEditMode;
    }

    public void ungrab() {
        this.movingComponent = null;
        this.resizingComponent = null;
    }

    public void showHud() {
        this.shouldShowHud = true;
    }

    public boolean isHovered(ComponentWrapper component, int mx, int my) {
        return component.getStatus().getX() < mx && component.getStatus().getX() + component.getStatus().getWidth() > mx && component.getStatus().getY() < my && component.getStatus().getY() + component.getStatus().getHeight() > my;
    }
}

