/*
 * Decompiled with CFR 0.152.
 */
package zabi.minecraft.minerva.client.hud;

import zabi.minecraft.minerva.client.hud.internal.AbsoluteCenterHelper;
import zabi.minecraft.minerva.client.hud.internal.AbsoluteEndHelper;
import zabi.minecraft.minerva.client.hud.internal.AbsoluteStartHelper;
import zabi.minecraft.minerva.client.hud.internal.AnchorHelper;
import zabi.minecraft.minerva.client.hud.internal.RelativeVersion;

public enum EnumHudAnchor {
    START_RELATIVE,
    CENTER_RELATIVE,
    END_RELATIVE,
    START_ABSOULTE,
    CENTER_ABSOLUTE,
    END_ABSOLUTE;

    private AnchorHelper ah = null;

    public void setHelper(AnchorHelper in) {
        if (this.ah != null) {
            throw new IllegalStateException("Only one anchor helper can exist!");
        }
        this.ah = in;
    }

    public int dataToPixel(double data, int componentSize, int screeScaledSize) {
        return this.ah.getPixel(data, screeScaledSize, componentSize);
    }

    public double pixelToData(double pixel, int componentSize, int screeScaledSize) {
        return this.ah.getData(pixel, screeScaledSize, componentSize);
    }

    static {
        START_RELATIVE.setHelper(new RelativeVersion(new AbsoluteStartHelper()));
        CENTER_RELATIVE.setHelper(new RelativeVersion(new AbsoluteCenterHelper()));
        END_RELATIVE.setHelper(new RelativeVersion(new AbsoluteEndHelper()));
        START_ABSOULTE.setHelper(new AbsoluteStartHelper());
        CENTER_ABSOLUTE.setHelper(new AbsoluteCenterHelper());
        END_ABSOLUTE.setHelper(new AbsoluteEndHelper());
    }
}

