/*
 * Decompiled with CFR 0.152.
 */
package primetoxinz.coralreef;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import primetoxinz.coralreef.BlockCoral;
import primetoxinz.coralreef.BlockReef;
import primetoxinz.coralreef.GeneratorReef;
import primetoxinz.coralreef.ItemBlockMeta;

@Mod.EventBusSubscriber(modid="coralreef")
@Mod(modid="coralreef", name="CoralReef", version="2.0", acceptedMinecraftVersions="[1.12, 1.13)")
public class CoralReef {
    public static final String MODID = "coralreef";
    public static final String NAME = "CoralReef";
    public static final String VERSION = "2.0";
    public static BlockCoral CORAL = (BlockCoral)((Block)new BlockCoral().setRegistryName("coral")).func_149663_c("coral");
    public static BlockReef REEF = (BlockReef)((Block)new BlockReef().setRegistryName("reef")).func_149663_c("reef");
    @SidedProxy(clientSide="primetoxinz.coralreef.CoralReef$ClientProxy", serverSide="primetoxinz.coralreef.CoralReef$CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)new GeneratorReef(), (int)1);
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{CORAL, REEF});
    }

    @SubscribeEvent
    public static void registerItem(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new ItemBlockMeta(CORAL).setRegistryName(CORAL.getRegistryName()), (Item)new ItemBlockMeta(REEF).setRegistryName(REEF.getRegistryName())});
        proxy.registerItems();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        OreDictionary.registerOre((String)"dyeOrange", (ItemStack)new ItemStack((Block)CORAL, 1, 0));
        OreDictionary.registerOre((String)"dyeMagenta", (ItemStack)new ItemStack((Block)CORAL, 1, 1));
        OreDictionary.registerOre((String)"dyePink", (ItemStack)new ItemStack((Block)CORAL, 1, 2));
        OreDictionary.registerOre((String)"dyeCyan", (ItemStack)new ItemStack((Block)CORAL, 1, 3));
        OreDictionary.registerOre((String)"dyeGreen", (ItemStack)new ItemStack((Block)CORAL, 1, 4));
        OreDictionary.registerOre((String)"dyeGray", (ItemStack)new ItemStack((Block)CORAL, 1, 5));
    }

    @SubscribeEvent
    public static void onConfigChange(ConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    public static class ClientProxy
    extends CommonProxy {
        @Override
        public void registerItems() {
            int i;
            ModelLoader.setCustomStateMapper((Block)CORAL, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{BlockLiquid.field_176367_b}).func_178441_a());
            for (i = 0; i <= 5; ++i) {
                this.registerItemModel(Item.func_150898_a((Block)CORAL), i, "coralreef:coral" + i, "inventory");
            }
            for (i = 0; i <= 1; ++i) {
                this.registerItemModel(Item.func_150898_a((Block)REEF), i, "coralreef:reef", "types=" + i);
            }
        }

        public void registerItemModel(Item item, int meta, String name, String type) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(name, type));
        }
    }

    public static class CommonProxy {
        public void registerItems() {
        }
    }

    @Config(modid="coralreef")
    public static class ConfigHandler {
        @Config.Comment(value={"Array of dimension ids in which Coral Reefs will spawn. Empty will allow all dimensions"})
        public static int[] dimensions = new int[]{0};
        @Config.Comment(value={"Light level of coral"})
        @Config.RequiresMcRestart
        public static int coralLightLevel = 15;
        @Config.Comment(value={"Array of biomes which will allow coral reefs to spawn if there is water. Empty will allow all biomes"})
        public static String[] biomes = new String[]{"ocean", "deep ocean", "beach"};
        @Config.Comment(value={"Bubble Particles from coral"})
        public static boolean bubbles = true;
        public static Reef reef = new Reef();
        public static Rock rock = new Rock();

        public static class Rock {
            @Config.Comment(value={"Chance for a Dry Reef to spawn"})
            public double chance = 0.5;
        }

        public static class Reef {
            @Config.RangeDouble(min=0.0, max=1.0)
            @Config.Comment(value={"Percentage of the sparsity of the coral on a reef"})
            public double coralSparsity = 0.9;
            @Config.RangeDouble(min=0.0, max=1.0)
            @Config.Comment(value={"Percentage of the sparsity of the reef blocks"})
            public double reefSparsity = 0.9;
        }
    }
}

