/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.expression;

import javax.annotation.Nonnull;
import org.orecruncher.lib.expression.IVariant;
import org.orecruncher.lib.expression.Variant;

public class StringValue
extends Variant {
    protected String value;

    public StringValue() {
        this.value = "";
    }

    public StringValue(@Nonnull String v) {
        this.value = v;
    }

    public StringValue(@Nonnull String name, @Nonnull String value) {
        super(name);
        this.value = value;
    }

    @Override
    public float asNumber() {
        return Float.parseFloat(this.value);
    }

    @Override
    @Nonnull
    public String asString() {
        return this.value;
    }

    @Override
    public boolean asBoolean() {
        return "TRUE".equalsIgnoreCase(this.value);
    }

    @Override
    public int compareTo(@Nonnull IVariant variant) {
        return this.value.compareTo(variant.asString());
    }

    @Override
    @Nonnull
    public IVariant add(@Nonnull IVariant term) {
        return new StringValue(this.value.concat(term.asString()));
    }
}

