/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.retro;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;

@Mod(modid="railcraftretrogen", name="Railcraft Retrogen", acceptableRemoteVersions="*", acceptedMinecraftVersions="*", dependencies="required-after:railcraft")
@ParametersAreNonnullByDefault
public class WorldRetrogenRailcraft {
    private Multimap<String, String> markers = HashMultimap.create();
    private Map<String, TargetWorldWrapper> delegates;
    private Map<World, ListMultimap<ChunkPos, String>> pendingWork;
    private Map<World, ListMultimap<ChunkPos, String>> completedWork;
    private ConcurrentMap<World, Semaphore> completedWorkLocks;
    private int maxPerTick;
    private Map<String, String> retros = Maps.newHashMap();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        Configuration cfg = new Configuration(evt.getSuggestedConfigurationFile(), null, true);
        cfg.load();
        Property property = cfg.get("general", "maxPerTick", 100);
        property.setComment("Maximum number of retrogens to run in a single tick");
        this.maxPerTick = property.getInt(100);
        if (cfg.hasChanged()) {
            cfg.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new LastTick());
        this.delegates = Maps.newHashMap();
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent evt) {
        this.pendingWork = new MapMaker().weakKeys().makeMap();
        this.completedWork = new MapMaker().weakKeys().makeMap();
        this.completedWorkLocks = new MapMaker().weakKeys().makeMap();
        this.markers.clear();
        Set worldGens = (Set)ObfuscationReflectionHelper.getPrivateValue(GameRegistry.class, null, (String[])new String[]{"worldGenerators"});
        Map worldGenIdx = (Map)ObfuscationReflectionHelper.getPrivateValue(GameRegistry.class, null, (String[])new String[]{"worldGeneratorIndex"});
        HashSet<TargetWorldWrapper> wrappers = new HashSet<TargetWorldWrapper>();
        Iterator iterator = worldGens.iterator();
        while (iterator.hasNext()) {
            IWorldGenerator wg = (IWorldGenerator)iterator.next();
            if (!wg.getClass().getSimpleName().equals("GeneratorRailcraftOre") || !(wg instanceof BooleanSupplier) || !(wg instanceof Supplier) || !(wg instanceof IForgeRegistryEntry)) continue;
            boolean retrogenEnabled = ((BooleanSupplier)wg).getAsBoolean();
            String retrogenMarker = (String)((Supplier)wg).get();
            ResourceLocation name = ((IForgeRegistryEntry)wg).getRegistryName();
            if (!retrogenEnabled || this.delegates.containsKey(name.toString())) continue;
            FMLLog.info((String)"Substituting worldgenerator %s with delegate", (Object[])new Object[]{name});
            iterator.remove();
            TargetWorldWrapper tww = new TargetWorldWrapper();
            tww.delegate = wg;
            tww.tag = name.toString();
            wrappers.add(tww);
            Integer idx = (Integer)worldGenIdx.remove(wg);
            worldGenIdx.put(tww, idx);
            FMLLog.info((String)"Successfully substituted %s with delegate", (Object[])new Object[]{name});
            this.delegates.put(name.toString(), tww);
            this.markers.put((Object)retrogenMarker, (Object)name.toString());
            this.retros.put(name.toString(), retrogenMarker);
        }
        worldGens.addAll(wrappers);
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent evt) {
        Set worldGens = (Set)ObfuscationReflectionHelper.getPrivateValue(GameRegistry.class, null, (String[])new String[]{"worldGenerators"});
        Map worldGenIdx = (Map)ObfuscationReflectionHelper.getPrivateValue(GameRegistry.class, null, (String[])new String[]{"worldGeneratorIndex"});
        for (TargetWorldWrapper tww : this.delegates.values()) {
            worldGens.remove(tww);
            Integer idx = (Integer)worldGenIdx.remove(tww);
            worldGens.add(tww.delegate);
            worldGenIdx.put(tww.delegate, idx);
        }
        this.delegates.clear();
    }

    private Semaphore getSemaphoreFor(World w) {
        this.completedWorkLocks.putIfAbsent(w, new Semaphore(1));
        return (Semaphore)this.completedWorkLocks.get(w);
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load chunkevt) {
        World w = chunkevt.getWorld();
        if (!(w instanceof WorldServer)) {
            return;
        }
        this.getSemaphoreFor(w);
        Chunk chk = chunkevt.getChunk();
        HashSet existingGens = Sets.newHashSet();
        NBTTagCompound data = chunkevt.getData();
        for (String m : this.markers.keySet()) {
            NBTTagCompound marker = data.func_74775_l(m);
            NBTTagList tagList = marker.func_150295_c("list", 8);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                existingGens.add(tagList.func_150307_f(i));
            }
            Sets.SetView difference = Sets.difference(new HashSet(this.markers.get((Object)m)), (Set)existingGens);
            for (String retro : difference) {
                if (!this.retros.containsKey(retro)) continue;
                this.queueRetrogen(retro, w, chk.func_76632_l());
            }
        }
        for (String retro : existingGens) {
            this.completeRetrogen(chk.func_76632_l(), w, retro);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save chunkevt) {
        World w = chunkevt.getWorld();
        if (!(w instanceof WorldServer)) {
            return;
        }
        this.getSemaphoreFor(w).acquireUninterruptibly();
        try {
            if (this.completedWork.containsKey(w)) {
                ListMultimap<ChunkPos, String> doneChunks = this.completedWork.get(w);
                List retroClassList = doneChunks.get((Object)chunkevt.getChunk().func_76632_l());
                if (retroClassList.isEmpty()) {
                    return;
                }
                NBTTagCompound data = chunkevt.getData();
                for (String retroClass : retroClassList) {
                    NBTTagList lst;
                    String marker = this.retros.get(retroClass);
                    if (marker == null) {
                        FMLLog.log((Level)Level.DEBUG, (String)"Encountered retrogen class %s with no existing marker, removing from chunk. You probably removed it from the active configuration", (Object[])new Object[]{retroClass});
                        continue;
                    }
                    if (data.func_74764_b(marker)) {
                        lst = data.func_74775_l(marker).func_150295_c("list", 8);
                    } else {
                        NBTTagCompound retro = new NBTTagCompound();
                        lst = new NBTTagList();
                        retro.func_74782_a("list", (NBTBase)lst);
                        data.func_74782_a(marker, (NBTBase)retro);
                    }
                    lst.func_74742_a((NBTBase)new NBTTagString(retroClass));
                }
            }
        }
        finally {
            this.getSemaphoreFor(w).release();
        }
    }

    private void queueRetrogen(String retro, World world, ChunkPos chunkCoords) {
        if (world instanceof WorldServer) {
            ListMultimap currentWork = this.pendingWork.computeIfAbsent(world, k -> ArrayListMultimap.create());
            currentWork.put((Object)chunkCoords, (Object)retro);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeRetrogen(ChunkPos chunkCoords, World world, String retroClass) {
        ListMultimap<ChunkPos, String> pendingMap = this.pendingWork.get(world);
        if (pendingMap != null && pendingMap.containsKey((Object)chunkCoords)) {
            pendingMap.remove((Object)chunkCoords, (Object)retroClass);
        }
        this.getSemaphoreFor(world).acquireUninterruptibly();
        try {
            ListMultimap completedMap = this.completedWork.computeIfAbsent(world, k -> ArrayListMultimap.create());
            completedMap.put((Object)chunkCoords, (Object)retroClass);
        }
        finally {
            this.getSemaphoreFor(world).release();
        }
    }

    private void runRetrogen(WorldServer world, ChunkPos chunkCoords, String retroClass) {
        long worldSeed = world.func_72905_C();
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkCoords.field_77276_a + zSeed * (long)chunkCoords.field_77275_b ^ worldSeed;
        fmlRandom.setSeed(chunkSeed);
        ChunkProviderServer providerServer = world.func_72863_F();
        IChunkGenerator generator = (IChunkGenerator)ObfuscationReflectionHelper.getPrivateValue(ChunkProviderServer.class, (Object)providerServer, (String[])new String[]{"field_186029_c", "chunkGenerator"});
        this.delegates.get(retroClass).delegate.generate(fmlRandom, chunkCoords.field_77276_a, chunkCoords.field_77275_b, (World)world, generator, (IChunkProvider)providerServer);
        FMLLog.fine((String)"Retrogenerated chunk for %s", (Object[])new Object[]{retroClass});
        this.completeRetrogen(chunkCoords, (World)world, retroClass);
    }

    private class TargetWorldWrapper
    implements IWorldGenerator {
        private IWorldGenerator delegate;
        private String tag;

        private TargetWorldWrapper() {
        }

        public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
            FMLLog.fine((String)"Passing generation for %s through to underlying generator", (Object[])new Object[]{this.tag});
            this.delegate.generate(random, chunkX, chunkZ, world, chunkGenerator, chunkProvider);
            ChunkPos chunkCoordIntPair = new ChunkPos(chunkX, chunkZ);
            WorldRetrogenRailcraft.this.completeRetrogen(chunkCoordIntPair, world, this.tag);
        }
    }

    private class LastTick {
        private int counter = 0;

        private LastTick() {
        }

        @SubscribeEvent
        public void tickStart(TickEvent.WorldTickEvent tick) {
            World w = tick.world;
            if (!(w instanceof WorldServer)) {
                return;
            }
            if (tick.phase == TickEvent.Phase.START) {
                this.counter = 0;
                WorldRetrogenRailcraft.this.getSemaphoreFor(w);
            } else {
                ListMultimap pending = (ListMultimap)WorldRetrogenRailcraft.this.pendingWork.get(w);
                if (pending == null) {
                    return;
                }
                ImmutableList forProcessing = ImmutableList.copyOf((Iterable)Iterables.limit((Iterable)pending.entries(), (int)(WorldRetrogenRailcraft.this.maxPerTick + 1)));
                for (Map.Entry entry : forProcessing) {
                    if (this.counter++ > WorldRetrogenRailcraft.this.maxPerTick) {
                        FMLLog.fine((String)"Completed %d retrogens this tick. There are %d left for world %s", (Object[])new Object[]{this.counter, pending.size(), w.func_72912_H().func_76065_j()});
                        return;
                    }
                    WorldRetrogenRailcraft.this.runRetrogen((WorldServer)w, (ChunkPos)entry.getKey(), (String)entry.getValue());
                }
            }
        }
    }
}

