/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.jeivillagers.jei;

import com.buuz135.jeivillagers.Jeivillagers;
import com.buuz135.jeivillagers.config.VillagerConfig;
import com.buuz135.jeivillagers.jei.VillagerPlugin;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class VillagerRecipe
implements IRecipeWrapper {
    private final VillagerRegistry.VillagerCareer career;
    private final Jeivillagers.VillagerTradeInfo tradeInfo;

    public VillagerRecipe(VillagerRegistry.VillagerCareer career, Jeivillagers.VillagerTradeInfo tradeInfo) {
        this.career = career;
        this.tradeInfo = tradeInfo;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputs(ItemStack.class, Arrays.asList(this.tradeInfo.firstInput, this.tradeInfo.secondInput));
        ingredients.setOutput(ItemStack.class, (Object)this.tradeInfo.outputStack);
        ingredients.setOutput(VillagerRegistry.VillagerCareer.class, (Object)this.career);
        ingredients.setInput(VillagerRegistry.VillagerCareer.class, (Object)this.career);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        int y = 38;
        this.drawStringCentered(minecraft.field_71466_p, TextFormatting.DARK_GRAY + (VillagerConfig.CompactMode ? "" : "Career: ") + new TextComponentTranslation("entity.Villager." + this.career.getName(), new Object[0]).func_150261_e(), 53, -1);
        if (this.tradeInfo.first != null) {
            if (VillagerConfig.CompactMode) {
                this.drawStringCentered(minecraft.field_71466_p, TextFormatting.DARK_GRAY + "" + this.tradeInfo.first.func_76341_a() + "-" + this.tradeInfo.first.func_76340_b(), -18, 18);
            } else {
                this.drawStringCentered(minecraft.field_71466_p, TextFormatting.DARK_GRAY + "First input range: " + this.tradeInfo.first.func_76341_a() + "-" + this.tradeInfo.first.func_76340_b(), 53, y);
                y += minecraft.field_71466_p.field_78288_b + 2;
            }
        }
        if (this.tradeInfo.second != null) {
            if (VillagerConfig.CompactMode) {
                this.drawStringCentered(minecraft.field_71466_p, TextFormatting.DARK_GRAY + "" + this.tradeInfo.second.func_76341_a() + "-" + this.tradeInfo.second.func_76340_b(), 36, 34);
            } else {
                this.drawStringCentered(minecraft.field_71466_p, TextFormatting.DARK_GRAY + "Second input range: " + this.tradeInfo.second.func_76341_a() + "-" + this.tradeInfo.second.func_76340_b(), 53, y);
                y += minecraft.field_71466_p.field_78288_b + 2;
            }
        }
        if (this.tradeInfo.output != null) {
            if (VillagerConfig.CompactMode) {
                this.drawStringCentered(minecraft.field_71466_p, TextFormatting.DARK_GRAY + "" + this.tradeInfo.output.func_76341_a() + "-" + this.tradeInfo.output.func_76340_b(), 126, 18);
            } else {
                this.drawStringCentered(minecraft.field_71466_p, TextFormatting.DARK_GRAY + "Output range: " + this.tradeInfo.output.func_76341_a() + "-" + this.tradeInfo.output.func_76340_b(), 53, y);
            }
        }
        if (this.tradeInfo.outputStack.func_77948_v() || this.tradeInfo.outputStack.func_77973_b().equals(Items.field_151134_bR)) {
            if (VillagerConfig.CompactMode) {
                this.drawStringCentered(minecraft.field_71466_p, TextFormatting.DARK_GRAY + "random", 95, y);
            } else {
                this.drawStringCentered(minecraft.field_71466_p, TextFormatting.DARK_GRAY + "Output with random enchant", 53, y);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void drawStringCentered(FontRenderer fontRenderer, String text, int x, int y) {
        fontRenderer.func_78276_b(text, x - fontRenderer.func_78256_a(text) / 2, y, 0);
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        int x = 53;
        int y = 0;
        int size = Minecraft.func_71410_x().field_71466_p.func_78256_a(TextFormatting.DARK_GRAY + "Career: " + new TextComponentTranslation("entity.Villager." + this.career.getName(), new Object[0]).func_150261_e());
        if (mouseX > x - size / 2 - 4 && mouseX < x + size / 2 + 4 && mouseY > y - 4 && mouseY < y + Minecraft.func_71410_x().field_71466_p.field_78288_b) {
            return Arrays.asList("Show recipes for " + new TextComponentTranslation("entity.Villager." + this.career.getName(), new Object[0]).func_150261_e() + " career");
        }
        return null;
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        int x = 53;
        int y = 0;
        int size = Minecraft.func_71410_x().field_71466_p.func_78256_a(TextFormatting.DARK_GRAY + "Career: " + new TextComponentTranslation("entity.Villager." + this.career.getName(), new Object[0]).func_150261_e());
        if (mouseX > x - size / 2 - 4 && mouseX < x + size / 2 + 4 && mouseY > y - 4 && mouseY < y + Minecraft.func_71410_x().field_71466_p.field_78288_b) {
            VillagerPlugin.showUses(this.career);
            return true;
        }
        return false;
    }
}

