/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecalculation.gui.guis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import me.towdium.jecalculation.data.Controller;
import me.towdium.jecalculation.data.label.ILabel;
import me.towdium.jecalculation.data.structure.CostList;
import me.towdium.jecalculation.data.structure.Recipe;
import me.towdium.jecalculation.gui.JecaGui;
import me.towdium.jecalculation.gui.Resource;
import me.towdium.jecalculation.gui.guis.GuiDisamb;
import me.towdium.jecalculation.gui.guis.GuiLabel;
import me.towdium.jecalculation.gui.guis.IGui;
import me.towdium.jecalculation.gui.widgets.IWidget;
import me.towdium.jecalculation.gui.widgets.WButton;
import me.towdium.jecalculation.gui.widgets.WButtonIcon;
import me.towdium.jecalculation.gui.widgets.WContainer;
import me.towdium.jecalculation.gui.widgets.WHelp;
import me.towdium.jecalculation.gui.widgets.WIcon;
import me.towdium.jecalculation.gui.widgets.WLabel;
import me.towdium.jecalculation.gui.widgets.WLabelGroup;
import me.towdium.jecalculation.gui.widgets.WLine;
import me.towdium.jecalculation.gui.widgets.WPanel;
import me.towdium.jecalculation.gui.widgets.WSwitcher;
import me.towdium.jecalculation.gui.widgets.WTextField;
import me.towdium.jecalculation.jei.JecaPlugin;
import me.towdium.jecalculation.utils.Utilities;
import me.towdium.jecalculation.utils.wrappers.Pair;
import me.towdium.jecalculation.utils.wrappers.Trio;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GuiRecipe
extends WContainer
implements IGui {
    Pair<String, Integer> dest;
    HashMap<Integer, List<ILabel>> disambCache = new HashMap();
    WSwitcher group = new WSwitcher(7, 7, 162, Controller.getGroups()).setListener(i -> this.refresh());
    WTextField text = new WTextField(49, 32, 119);
    WLabelGroup catalyst = new WLabelGroup(29, 87, 7, 1, 20, 20, WLabel.Mode.EDITOR).setListener((i, v) -> {
        this.disambCache.remove(v + 14);
        this.refresh();
    });
    WLabelGroup input = new WLabelGroup(29, 111, 7, 2, 20, 20, WLabel.Mode.EDITOR).setListener((i, v) -> {
        this.disambCache.remove(v);
        this.refresh();
    });
    WLabelGroup output = new WLabelGroup(29, 63, 7, 1, 20, 20, WLabel.Mode.EDITOR).setListener((i, v) -> {
        this.disambCache.remove(v + 21);
        this.refresh();
    });
    WButton disamb = new WButtonIcon(102, 32, 20, 20, Resource.BTN_DISAMB, "recipe.disamb").setListener(i -> {
        if (this.disambCache != null) {
            JecaGui.displayGui(new GuiDisamb(new ArrayList<List<ILabel>>(this.disambCache.values())).setCallback(l -> {
                JecaGui.displayParent();
                JecaGui.getCurrent().hand = l;
            }));
        }
    });
    WButton clear = new WButtonIcon(64, 32, 20, 20, Resource.BTN_DEL, "recipe.clear").setListener(i -> this.reset());
    WButton copy = new WButtonIcon(83, 32, 20, 20, Resource.BTN_COPY, "recipe.copy").setListener(i -> {
        Controller.addRecipe(this.group.getText(), this.toRecipe());
        JecaGui.displayParent();
    });
    WButton label = new WButtonIcon(45, 32, 20, 20, Resource.BTN_LABEL, "recipe.label").setListener(i -> JecaGui.displayGui(new GuiLabel(l -> {
        JecaGui.displayParent();
        JecaGui.getCurrent().hand = l;
    })));
    WButton save = new WButtonIcon(26, 32, 20, 20, Resource.BTN_SAVE, "recipe.save").setDisabled(true).setListener(i -> {
        if (this.dest == null) {
            Controller.addRecipe(this.group.getText(), this.toRecipe());
        } else {
            String group = this.group.getText();
            if (group.equals(this.dest.one)) {
                Controller.setRecipe((String)this.dest.one, (Integer)this.dest.two, this.toRecipe());
            } else {
                Controller.setRecipe(group, (String)this.dest.one, (Integer)this.dest.two, this.toRecipe());
            }
        }
        JecaGui.displayParent();
    });
    WButton yes = new WButtonIcon(7, 32, 20, 20, Resource.BTN_YES, "recipe.confirm").setDisabled(true).setListener(i -> {
        this.group.setText(this.text.getText());
        this.text.setText("");
        this.setNewGroup(false);
        this.refresh();
    });
    WButton no = new WButtonIcon(26, 32, 20, 20, Resource.BTN_NO, "common.cancel").setListener(i -> this.setNewGroup(false));
    WButton neu = new WButtonIcon(7, 32, 20, 20, Resource.BTN_NEW, "recipe.new").setListener(i -> this.setNewGroup(true));

    public GuiRecipe(String group, int index) {
        this();
        this.dest = new Pair<String, Integer>(group, index);
        Recipe r = Controller.getRecipe(group, index);
        this.fromRecipe(r);
        this.group.setIndex(Controller.getGroups().indexOf(group));
        this.refresh();
    }

    public GuiRecipe() {
        this.add(new WHelp("recipe"), new WPanel());
        this.add((IWidget)new WIcon(7, 63, 22, 20, Resource.ICN_OUTPUT, "common.output"));
        this.add((IWidget)new WIcon(7, 87, 22, 20, Resource.ICN_CATALYST, "common.catalyst"));
        this.add((IWidget)new WIcon(7, 111, 22, 40, Resource.ICN_INPUT, "common.input"));
        this.add((IWidget)new WLine(57));
        this.add(this.input, this.catalyst, this.output, this.group);
        if (this.group.getTexts().isEmpty()) {
            this.group.setText(Utilities.I18n.get("gui.common.default", new Object[0]));
        }
        String last = Controller.getLast();
        int index = -1;
        if (last != null) {
            index = this.group.getTexts().indexOf(last);
        }
        if (index != -1) {
            this.group.setIndex(index);
        }
        this.setNewGroup(false);
        this.copy.setDisabled(true);
        this.disamb.setDisabled(true);
        this.text.setListener(i -> this.yes.setDisabled(i.getText().isEmpty()));
    }

    @Override
    public boolean onKey(JecaGui gui, char ch, int code) {
        if (code == 1 && this.contains(this.text)) {
            this.setNewGroup(false);
            return true;
        }
        return super.onKey(gui, ch, code);
    }

    public void setNewGroup(boolean b) {
        if (b) {
            this.remove(this.neu, this.label, this.clear, this.copy, this.save, this.disamb);
            this.add(this.yes, this.no, this.text);
        } else {
            this.add(this.neu, this.label, this.clear, this.copy, this.save, this.disamb);
            this.remove(this.yes, this.no, this.text);
            this.text.setText("");
            this.yes.setDisabled(true);
        }
    }

    public void reset() {
        this.input.setLabel(Collections.nCopies(14, ILabel.EMPTY), 0);
        this.catalyst.setLabel(Collections.nCopies(7, ILabel.EMPTY), 0);
        this.output.setLabel(Collections.nCopies(7, ILabel.EMPTY), 0);
        this.disambCache.clear();
        this.refresh();
    }

    public void transfer(IRecipeLayout recipe) {
        ArrayList<Trio<ILabel, CostList, CostList>> input = new ArrayList<Trio<ILabel, CostList, CostList>>();
        ArrayList<Trio<ILabel, CostList, CostList>> output = new ArrayList<Trio<ILabel, CostList, CostList>>();
        this.disambCache = new HashMap();
        Stream.of(recipe.getFluidStacks(), recipe.getItemStacks()).flatMap(i -> i.getGuiIngredients().values().stream()).forEach(i -> this.merge(i.isInput() ? input : output, (IGuiIngredient<?>)i, recipe));
        List<ILabel> catalysts = JecaPlugin.runtime.getRecipeRegistry().getRecipeCatalysts(recipe.getRecipeCategory()).stream().map(ILabel.Converter::from).collect(Collectors.toList());
        if (catalysts.size() == 1) {
            this.catalyst.setLabel((ILabel)catalysts.get(0), 0);
        } else if (catalysts.size() > 1) {
            this.catalyst.setLabel(ILabel.CONVERTER.first(catalysts, recipe), 0);
            this.disambCache.put(14, catalysts);
        }
        this.input.setLabel(this.sort(input, 0), 0);
        this.output.setLabel(this.sort(output, 21), 0);
        this.refresh();
    }

    private void merge(ArrayList<Trio<ILabel, CostList, CostList>> dst, IGuiIngredient<?> gi, IRecipeLayout context) {
        List list = gi.getAllIngredients().stream().map(ILabel.Converter::from).collect(Collectors.toList());
        if (list.isEmpty()) {
            return;
        }
        dst.stream().filter(p -> {
            CostList cl = new CostList(list);
            if (((CostList)p.three).equals(cl)) {
                ILabel.MERGER.merge((ILabel)p.one, ILabel.CONVERTER.first(list, context)).ifPresent(i -> {
                    p.one = i;
                    Object cfr_ignored_0 = p.one;
                });
                p.two = ((CostList)p.two).merge(cl, true, false);
                return true;
            }
            return false;
        }).findAny().orElseGet(() -> {
            Trio<ILabel, CostList, CostList> ret = new Trio<ILabel, CostList, CostList>(ILabel.CONVERTER.first(list, context), new CostList(list), new CostList(list));
            dst.add(ret);
            return ret;
        });
    }

    private ArrayList<ILabel> sort(ArrayList<Trio<ILabel, CostList, CostList>> src, int offset) {
        ArrayList<ILabel> ret = new ArrayList<ILabel>();
        for (int i = 0; i < src.size(); ++i) {
            Trio<ILabel, CostList, CostList> p = src.get(i);
            ret.add((ILabel)p.one);
            if (((CostList)p.two).getLabels().size() <= 1) continue;
            this.disambCache.put(i + offset, ((CostList)p.two).getLabels());
        }
        return ret;
    }

    private Recipe toRecipe() {
        return new Recipe(this.input.getLabels(), this.catalyst.getLabels(), this.output.getLabels());
    }

    void fromRecipe(Recipe r) {
        this.input.setLabel(Arrays.stream(r.getLabel(Recipe.IO.INPUT)).map(ILabel::copy).collect(Collectors.toList()), 0);
        this.catalyst.setLabel(Arrays.stream(r.getLabel(Recipe.IO.CATALYST)).map(ILabel::copy).collect(Collectors.toList()), 0);
        this.output.setLabel(Arrays.stream(r.getLabel(Recipe.IO.OUTPUT)).map(ILabel::copy).collect(Collectors.toList()), 0);
    }

    void refresh() {
        this.disamb.setDisabled(this.disambCache.isEmpty());
        try {
            Recipe r = this.toRecipe();
            boolean d = this.dest == null ? Controller.hasDuplicate(r) : Controller.hasDuplicate(r, (String)this.dest.one, (Integer)this.dest.two);
            this.save.setDisabled(d);
            if (this.dest != null) {
                this.copy.setDisabled(d);
            }
        }
        catch (IllegalArgumentException e) {
            this.save.setDisabled(true);
            this.copy.setDisabled(true);
        }
    }
}

