/*
 * Decompiled with CFR 0.152.
 */
package c4.comforts.common.blocks;

import c4.comforts.common.ConfigHandler;
import c4.comforts.common.blocks.BlockHammock;
import c4.comforts.common.tileentities.TileEntityHammock;
import c4.comforts.common.util.ComfortsUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBase
extends BlockHorizontal {
    public static final PropertyBool OCCUPIED = PropertyBool.func_177716_a((String)"occupied");
    protected float explosivePower = 5.0f;
    protected String textOccupied;
    protected String textNoSleep;
    protected String textNotSafe;
    protected String textTooFar;
    protected int color;

    public BlockBase(String name, EnumDyeColor color) {
        super(Material.field_151580_n);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT).func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(false)));
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149711_c(0.2f);
        this.color = color.func_176765_a();
        this.setRegistryName(name + "_" + color.func_176610_l());
        this.func_149663_c("comforts." + name + "." + color.func_176610_l());
        this.setTextComponents(name);
        this.func_149649_H();
    }

    private void setTextComponents(String name) {
        this.textOccupied = "tile." + name + ".occupied";
        this.textNoSleep = "tile." + name + ".noSleep";
        this.textNotSafe = "tile." + name + ".notSafe";
        this.textTooFar = "tile." + name + ".tooFarAway";
    }

    protected void setExplosivePower(float power) {
        this.explosivePower = power;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            this.doSleep(worldIn, pos, state, playerIn);
        }
        return true;
    }

    public EntityPlayer.SleepResult doSleep(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn) {
        BlockPos originalPos = pos;
        if (state.func_177229_b((IProperty)BlockBed.field_176472_a) != BlockBed.EnumPartType.HEAD && (state = worldIn.func_180495_p(pos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)))).func_177230_c() != this) {
            return EntityPlayer.SleepResult.OTHER_PROBLEM;
        }
        WorldProvider.WorldSleepResult sleepResult = worldIn.field_73011_w.canSleepAt(playerIn, pos);
        if (sleepResult != WorldProvider.WorldSleepResult.BED_EXPLODES) {
            EntityPlayer.SleepResult entityplayer$sleepresult;
            if (sleepResult == WorldProvider.WorldSleepResult.DENY) {
                return EntityPlayer.SleepResult.OTHER_PROBLEM;
            }
            if (state.func_177230_c() instanceof BlockHammock) {
                TileEntity tileentity = worldIn.func_175625_s(originalPos);
                TileEntity tileentity2 = worldIn.func_175625_s(pos);
                if (tileentity instanceof TileEntityHammock && tileentity2 instanceof TileEntityHammock && (((TileEntityHammock)tileentity).isOccupied() || ((TileEntityHammock)tileentity2).isOccupied())) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(this.textOccupied, new Object[0]), true);
                    return EntityPlayer.SleepResult.OTHER_PROBLEM;
                }
            }
            if (((Boolean)state.func_177229_b((IProperty)OCCUPIED)).booleanValue()) {
                EntityPlayer entityplayer = this.getPlayerInComfort(worldIn, pos);
                if (entityplayer != null) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(this.textOccupied, new Object[0]), true);
                    return EntityPlayer.SleepResult.OTHER_PROBLEM;
                }
                state = state.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(false));
                worldIn.func_180501_a(pos, state, 4);
            }
            if ((entityplayer$sleepresult = playerIn.func_180469_a(pos)) == EntityPlayer.SleepResult.OK) {
                state = state.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(true));
                worldIn.func_180501_a(pos, state, 4);
            } else if (entityplayer$sleepresult == EntityPlayer.SleepResult.NOT_POSSIBLE_NOW) {
                if (this instanceof BlockHammock && ConfigHandler.nightHammocks) {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(this.textNoSleep + "Custom", new Object[0]), true);
                } else {
                    playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(this.textNoSleep, new Object[0]), true);
                }
            } else if (entityplayer$sleepresult == EntityPlayer.SleepResult.NOT_SAFE) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(this.textNotSafe, new Object[0]), true);
            } else if (entityplayer$sleepresult == EntityPlayer.SleepResult.TOO_FAR_AWAY) {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation(this.textTooFar, new Object[0]), true);
            }
            return entityplayer$sleepresult;
        }
        worldIn.func_175698_g(pos);
        BlockPos blockpos = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176734_d());
        if (worldIn.func_180495_p(blockpos).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }
        worldIn.func_72885_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, this.explosivePower, true, true);
        return EntityPlayer.SleepResult.OTHER_PROBLEM;
    }

    public int func_180651_a(IBlockState state) {
        return this.color;
    }

    @Nullable
    protected EntityPlayer getPlayerInComfort(World worldIn, BlockPos pos) {
        for (EntityPlayer entityplayer : worldIn.field_73010_i) {
            if (!entityplayer.func_70608_bn() || entityplayer.field_71081_bT == null || !entityplayer.field_71081_bT.equals((Object)pos)) continue;
            return entityplayer;
        }
        return null;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public void func_180653_a(World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state, float chance, int fortune) {
        if (state.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.HEAD) {
            super.func_180653_a(worldIn, pos, state, chance, 0);
        }
    }

    @Nonnull
    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        BlockPos blockpos;
        if (player.field_71075_bZ.field_75098_d && state.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.FOOT && worldIn.func_180495_p(blockpos = pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D))).func_177230_c() == this) {
            worldIn.func_175698_g(blockpos);
        }
    }

    @Nonnull
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        IBlockState iblockstate;
        if (state.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.FOOT && (iblockstate = worldIn.func_180495_p(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)))).func_177230_c() == this) {
            state = state.func_177226_a((IProperty)OCCUPIED, iblockstate.func_177229_b((IProperty)OCCUPIED));
        }
        return state;
    }

    @Nonnull
    public IBlockState func_185499_a(@Nonnull IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    @Nonnull
    public IBlockState func_185471_a(@Nonnull IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_176731_b((int)meta);
        return (meta & 8) > 0 ? this.func_176223_P().func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.HEAD).func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing).func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf((meta & 4) > 0)) : this.func_176223_P().func_177226_a((IProperty)BlockBed.field_176472_a, (Comparable)BlockBed.EnumPartType.FOOT).func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b();
        if (state.func_177229_b((IProperty)BlockBed.field_176472_a) == BlockBed.EnumPartType.HEAD) {
            i |= 8;
            if (((Boolean)state.func_177229_b((IProperty)OCCUPIED)).booleanValue()) {
                i |= 4;
            }
        }
        return i;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, BlockBed.field_176472_a, OCCUPIED});
    }

    public boolean isBed(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable Entity player) {
        return true;
    }

    public void setBedOccupied(IBlockAccess world, @Nonnull BlockPos pos, EntityPlayer player, boolean occupied) {
        if (world instanceof World) {
            IBlockState state = world.func_180495_p(pos);
            state = state.func_177230_c().func_176221_a(state, world, pos);
            state = state.func_177226_a((IProperty)OCCUPIED, (Comparable)Boolean.valueOf(occupied));
            ((World)world).func_180501_a(pos, state, 4);
        }
    }

    @Nonnull
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public IBlockColor colorMultiplier() {
        return (state, worldIn, pos, tintIndex) -> ComfortsUtil.getColor(this.color);
    }
}

