/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.init;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.EmittersInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adchimneys.compat.Buildcraft;
import com.endertech.minecraft.mods.adchimneys.compat.TConstruct;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import com.endertech.minecraft.mods.adchimneys.smoke.ISmokeEmitter;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Emitters
extends EmittersInit<Emitter, BuiltInEmitters> {
    public Emitters(ForgeMod mod) {
        super(mod, BuiltInEmitters.class);
    }

    public Emitter createCustomUnitFrom(UnitConfig config, String name) {
        UnitId relatedBlockId = UnitId.from((Path)config.getConfigFile().toPath());
        Smoke smoke = new Smoke(config, 10.0f, 1.0f, 2.0f);
        return new Emitter(config, relatedBlockId, smoke, Smoke.defaultColor, true, true, "", "", false, new String[0]);
    }

    public Emitter createDefaultUnitFrom(UnitConfig config, BuiltInEmitters e) {
        UnitId id = e.id.isEmpty() ? UnitId.from((Enum)e, (boolean)true) : UnitId.from((String)e.id);
        Smoke smoke = new Smoke(config, (float)e.smokeAmount, e.smokeIntencity, 2.0f);
        return e.createEmitter(config, id, smoke);
    }

    @Nullable
    public Emitter findBy(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block instanceof ISmokeEmitter) {
            return ((ISmokeEmitter)block).getEmitter(world, pos);
        }
        return (Emitter)super.findBy(world, pos);
    }

    static enum BuiltInEmitters implements IForgeEnum
    {
        actuallyadditions$powered_furnace("actuallyadditions:block_furnace_double:[on=true]", 4, 1.0f, 0, true),
        actuallyadditions$block_coal_generator("", 5, 1.0f, 295128853, true, true, "BurnTime"),
        actuallyadditions$block_oil_generator("", 3, 1.0f, 290670888, true, true, "BurnTime"),
        advgenerators$syngas_controller("", 4, 1.0f, 0, true, true, "heat"),
        advancedrocketry$arcfurnace("", 4, 1.0f, 0, true, false, "enabled"),
        advancedrocketry$crystallizer("", 4, 1.0f, 0, true, false, "enabled"),
        advancedrocketry$cuttingmachine("", 4, 1.0f, 0, true, false, "enabled"),
        advancedrocketry$rocketbuilder("", 4, 1.0f, 0, true, false, "building"),
        advancedrocketry$rollingmachine("", 4, 1.0f, 0, true, false, "enabled"),
        atum$limestone_furnace_lit("", 4, 1.0f, 299285393, true),
        atum$kiln("atum:kiln:[is_burning=true]", 2, 0.5f, 299285393, true, true, "", "", new String[]{"atum:kiln_fake:*"}),
        betterboilers$controller("betterboilers:controller:1", 4, 1.0f, 288628507, true),
        betterwithmods$stoked_flame("", 1, 0.0f, 855673328, false),
        buildcraft$engine_combustion("buildcraftcore:engine:2", 3, 1.0f, 0x11C8C8C8, true, true, "burnTime"){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id, Smoke smoke) {
                return new Buildcraft.CombustionEngine(config, id, smoke, this.color, this.canEmitAside, this.emitWithoutChimney, this.activeStateTag, this.identityTag, this.useDroppedItemMeta, this.relatedBlocks);
            }
        }
        ,
        buildcraft$engine_stirling("buildcraftcore:engine:1", 3, 1.0f, 0x11767676, true, true, "burnTime"){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id, Smoke smoke) {
                return new Buildcraft.StirlingEngine(config, id, smoke, this.color, this.canEmitAside, this.emitWithoutChimney, this.activeStateTag, this.identityTag, this.useDroppedItemMeta, this.relatedBlocks);
            }
        }
        ,
        cfm$fire_pit_on("", 2, 1.0f, 587163136, false, false),
        cfm$oven("", 4, 1.0f, 298701525, true, false, "cookingTime"),
        cookingforblockheads$oven("", 3, 1.0f, 0, true, true, "BurnTime"),
        dawnoftime$open_fireplace("dawnoftimebuilder:fireplace:[burning=true]", 2, 0.0f, 587163136, true, true, "", "", new String[]{"dawnoftimebuilder:fireplace:*"}),
        dawnoftime$limestone_fireplace("dawnoftimebuilder:limestone_fireplace:[burning=true]", 2, 0.0f, 587163136, true, true, "", "", new String[]{"dawnoftimebuilder:limestone_fireplace:*"}),
        draconicevolution$generator("", 4, 1.0f, 288439113, true, true, "BCManagedData/active"),
        dumpsterdiving$reingotor("dumpsterdiving:trash_furn:*", 4, 1.0f, 290019876, true, true, "BurnTime"),
        dumpsterdiving$reprocessor("dumpsterdiving:trash_furn_n:*", 4, 1.0f, 290019876, true, true, "BurnTime"),
        dumpsterdiving$regrinder("dumpsterdiving:trash_furn_g:*", 4, 1.0f, 290019876, true, true, "BurnTime"),
        embers$ember_bore("", 3, 1.0f, 292906328, true, true, "fueled", "", new String[]{"embers:mech_edge:*", "embers:mech_core"}),
        embers$melter("embers:block_furnace:0", 3, 1.0f, 289816369, true, false, "progress", "", new String[]{"embers:block_furnace:*"}),
        enderio$block_stirling_generator("", 4, 1.0f, 0, true, true, "burnTime"),
        enderio$block_combustion_generator("", 4, 1.0f, 0, true, true, "active"),
        engineersdecor$small_lab_furnace("", 4, 1.0f, 0, true, true, "BurnTime"),
        engineersdecor$small_electrical_furnace("", 3, 1.0f, 0, true, true, "BurnTime"),
        engineersdecor$small_mineral_smelter("", 2, 1.0f, 0, true, true, "progress"),
        gadgetrycore$alloy_furnace("", 4, 1.0f, 294659858, true, true, "ticks"),
        gadgetrymachines$furnace_gen("", 4, 1.0f, 300037397, true, true, "ticks"),
        galacticraft$coal_generator("galacticraftcore:machine:[type=coal_generator]", 4, 1.0f, 290015293, true, true, "itemCookTime"),
        galacticraft$ingot_comressor("galacticraftcore:machine:[type=ingot_compressor]", 4, 1.0f, 290015293, true, true, "smeltingTicks"),
        foundry$alloyfurnace("", 4, 1.0f, 294345262, true, true, "BurnTime"),
        foundry$burnerheater("", 4, 1.0f, 298344984, true, true, "BurnTime"),
        foundry$moldstation("", 4, 1.0f, 298628500, true, true, "BurnTime"),
        funores$alloysmelter("", 4, 1.0f, 291443216, true, true, "BurnTime"),
        funores$metalfurnace("", 4, 1.0f, 298608384, true, true, "BurnTime"),
        furnace3d$lit_furnace("", 5, 1.2f, 0x11808080, true),
        furnaceoverhaul$iron_furnace("", 4, 1.0f, 300538816, true, true, "burn_time"),
        furnaceoverhaul$gold_furnace("", 6, 1.5f, 300471142, true, true, "burn_time"),
        furnaceoverhaul$diamond_furnace("", 8, 2.0f, 285261492, true, true, "burn_time"),
        furnaceoverhaul$emerald_furnace("", 10, 2.5f, 287749192, true, true, "burn_time"),
        furnaceoverhaul$end_furnace("", 12, 3.0f, 286883171, true, true, "burn_time"),
        furnaceoverhaul$zenith_furnace("", 16, 4.0f, 299106304, true, true, "burn_time"),
        furnus$furnus("", 4, 1.0f, 290864674, true, true, "fuel"),
        furnus$pulvus("", 4, 1.0f, 296921731, true, true, "fuel"),
        giacomosfoundry$foundry_lit("", 4, 1.0f, 0, true),
        gregtech_ce$machines("gregtech:machine:*", 4, 1.0f, 0, true, true, "MetaTileEntity/FuelBurnTimeLeft"),
        ic2$_common_0("ic2:te:0"),
        ic2$_common_1("ic2:te:1"),
        ic2$generator("ic2:te:3", 4, 1.0f, 297517764, true, true, "active"),
        ic2$solid_heat_generator("ic2:te:15", 4, 1.0f, 297517764, true, true, "active"),
        ic2$iron_furnace("ic2:te:46", 4, 1.0f, 0x11E4E4E4, true, true, "active"),
        ic2classic$iron_furnace("ic2:blockmachinelv:1", 4, 1.0f, 0x11EEEEEE, true, true, "fuel"),
        ic2classic$stone_macerator("ic2:blockmachinelv:15", 4, 1.0f, 0x11919191, true, true, "Fuel"),
        ic2classic$wood_gasificator("ic2:blockmachinelv2:0", 4, 1.0f, 299757551, true, true, "Fuel"),
        ic2classic$generator("ic2:blockgenerator:0", 4, 1.0f, 299757551, true, true, "Fuel"),
        ic2classic$liquid_fuel("ic2:blockgenerator:10", 4, 1.0f, 299757551, true, true, "Fuel"),
        ic2classic$slag("ic2:blockgenerator:11", 4, 1.0f, 299757551, true, true, "Fuel"),
        ic2classic$fuel_boiler("ic2:blockgenerator:14", 4, 1.0f, 299757551, true, true, "Fuel"),
        immcraft$furnace("", 4, 1.0f, 0x11808080, true, true, "burnTime"),
        immersiveengineering$alloy_kiln("immersiveengineering:stone_device:7", 3, 1.0f, 293159744, true, false, "active"),
        immersiveengineering$coke_oven("immersiveengineering:stone_device:0", 3, 1.0f, 0x11333333, true, false, "active"),
        immersiveengineering$blast_furnace("immersiveengineering:stone_device:1", 3, 1.0f, 291450657, true, false, "active"),
        immersiveengineering$improved_blast_furnace("immersiveengineering:stone_device:2", 3, 1.0f, 291450657, false, false, "active"),
        immersiveengineering$diesel_generator("immersiveengineering:metal_multiblock:10", 3, 1.0f, 0x11353535, true, false, "active"),
        immersivetech$coke_oven_advanced("immersivetech:stone_multiblock:0", 3, 1.0f, 0x11353535, true, false, "active", "", new String[]{"immersivetech:stone_multiblock:1"}),
        ironfurnaces$iron_furnace_active("", 4, 1.0f, 0x22999999, true),
        ironfurnaces$gold_furnace_active("", 6, 1.5f, 0x22FFFF00, true),
        ironfurnaces$diamond_furnace_active("", 8, 2.0f, 573820159, true),
        ironfurnaces$glass_furnace_active("", 10, 2.5f, 288607487, true),
        ironfurnaces$obsidian_furnace_active("", 12, 3.0f, 577123225, true),
        libvulpes$coal_generator("libvulpes:coalgenerator:[state=true]", 4, 1.0f, 0x11808080, true),
        lucraftcore$furnace_generator("", 4, 1.0f, 0x113A3A3A, true, true, "Fuel"),
        machines$mythril_furnace_lit("", 4, 1.0f, 856656071, true),
        machines$onyx_furnace_lit("", 4, 1.0f, 0x332A2A2A, true),
        mekanism$fuelwood_heater("mekanism:machineblock3:6", 4, 1.0f, 0, true, true, "isActive"),
        metallurgy$alloyer("metallurgy:alloyer:[burning=true]", 4, 1.0f, 300145739, true),
        metallurgy$crusher("metallurgy:crusher:[burning=true]", 4, 1.0f, 297556297, true),
        minecraft$lit_furnace("", 4, 1.0f, 0x11808080, true),
        minecraftfuture$blast_furnace("minecraftfuture:blast_furnace:[lit=true]", 6, 1.6f, 289291585, true),
        minecraftfuture$smoker("minecraftfuture:smoker:[lit=true]", 6, 1.6f, 291851819, true),
        morefurnaces$iron_furnace("morefurnaces:furnaceblock:0", 4, 1.0f, 0x33999999, true, true, "isActive"),
        morefurnaces$golden_furnace("morefurnaces:furnaceblock:1", 5, 1.1f, 0x33FFFF00, true, true, "isActive"),
        morefurnaces$diamond_furnace("morefurnaces:furnaceblock:2", 7, 1.3f, 0x3333CCFF, true, true, "isActive"),
        morefurnaces$obsidian_furnace("morefurnaces:furnaceblock:3", 8, 1.4f, 0x33663399, true, true, "isActive"),
        morefurnaces$netherrack_furnace("morefurnaces:furnaceblock:4", 9, 1.5f, 0x33993333, true, true, "isActive"),
        mysticalagriculture$seed_reprocessor("", 2, 0.0f, -1722658212, true, true, "Progress"),
        mysticalagriculture$inferium_furnace_active("", 4, 1.3f, 859589120, true),
        mysticalagriculture$prudentium_furnace_active("", 5, 1.6f, 856114702, true),
        mysticalagriculture$intermedium_furnace_active("", 6, 2.0f, 862596352, true),
        mysticalagriculture$superium_furnace_active("", 7, 2.3f, 855849576, true),
        mysticalagriculture$supremium_furnace_active("", 10, 2.6f, 862783753, true),
        mysticalagriculture$ultimate_furnace_active("", 12, 3.0f, 0x33282828, true),
        natura$lit_netherrack_furnace("", 4, 1.0f, 294869080, true),
        vimmersion$lit_furnace("", 5, 1.5f, 0x11808080, true),
        omegacraft$combustion_generator("omegacraft:gen_coalb:*", 4, 1.0f, 293535744, true, true, "fuel"),
        omegacraft$hungry_generator("omegacraft:gen_foodb:*", 2, 0.5f, 285245198, true, true, "fuel"),
        omegacraft$lava_generator("omegacraft:gen_lavab:*", 2, 0.5f, 299062272, true, true, "fuel"),
        pneumaticcraft$air_compressor("pneumaticcraft:air_compressor:[on=true]", 4, 1.0f, 0x11808080, true),
        pneumaticcraft$advanced_air_compressor("pneumaticcraft:advanced_air_compressor:[on=true]", 4, 1.0f, 0x11484848, true),
        primal$hibachi("primal:hibachi:[lit=true]", 3, 0.7f, 0, false),
        primal$kiln_adobe("primal:kiln_adobe:[lit=true]", 4, 1.0f, 299086219, true),
        primal$smelter("primal:smelter:[lit=true]", 2, 0.4f, 0, false),
        projecte$dm_furnace_lit("", 8, 3.0f, 0x11151515, true),
        projecte$rm_furnace_lit("", 12, 4.0f, 290063364, true),
        pyrotech$bloomery("pyrotech:bloomery:[type=bottom_lit]", 3, 0.8f, 292377912, true),
        pyrotech$campfire("", 2, 1.0f, 296961280, false, true, "active"),
        pyrotech$brick_crucible("pyrotech:brick_crucible:[type=bottom_lit]", 4, 1.0f, 288696601, true),
        pyrotech$brick_kiln("pyrotech:brick_kiln:[type=bottom_lit]", 4, 1.0f, 288696601, true),
        pyrotech$brick_oven("pyrotech:brick_oven:[type=bottom_lit]", 4, 1.0f, 288696601, true),
        pyrotech$brick_sawmill("pyrotech:brick_sawmill:[type=bottom_lit]", 4, 1.0f, 288696601, true),
        pyrotech$stone_crucible("pyrotech:stone_crucible:[type=bottom_lit]", 4, 1.0f, 0x11999999, true),
        pyrotech$stone_kiln("pyrotech:stone_kiln:[type=bottom_lit]", 4, 1.0f, 0x11999999, true),
        pyrotech$stone_oven("pyrotech:stone_oven:[type=bottom_lit]", 4, 1.0f, 0x11999999, true),
        pyrotech$stone_sawmill("pyrotech:stone_sawmill:[type=bottom_lit]", 4, 1.0f, 0x11999999, true),
        pyrotech$wither_forge("pyrotech:wither_forge:[type=bottom_lit]", 4, 1.0f, 288496415, true),
        railcraft$blast_furnace("", 3, 1.0f, 0x11474144, true, false, "burnTime", "master=1b"),
        railcraft$boiler_firebox_fluid("", 3, 1.0f, 0x116A6A6A, true, false, "burnTime", "master=1b"),
        railcraft$boiler_firebox_solid("", 3, 1.0f, 0x114E4E4E, true, false, "burnTime", "master=1b"),
        railcraft$coke_oven("", 3, 1.0f, 296454499, true, false, "cooking", "master=1b"),
        railcraft$coke_oven_red("", 3, 1.0f, 290075177, true, false, "cooking", "master=1b"),
        rockhounding_oretiers$bloomery("", 2, 0.7f, 298926080, true, false, "CastTime"),
        rftools$coalgenerator("", 4, 1.0f, 0x11787878, true, true, "burning"),
        tcomplement$melter("", 3, 0.7f, 0, true, true, "", "", new String[]{"tcomplement:melter:*", "tconstruct:seared_tank:*"}){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id, Smoke smoke) {
                return new TConstruct.HeatingStructure(config, id, smoke, this.color, this.canEmitAside, this.emitWithoutChimney, this.identityTag, this.useDroppedItemMeta, this.relatedBlocks);
            }
        }
        ,
        tcomplement$high_oven_controller("", 4, 1.0f, 289222168, true, true, "", "", new String[]{"tcomplement:scorched_block:*", "tcomplement:high_oven_io:*"}){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id, Smoke smoke) {
                return new TConstruct.HeatingStructure(config, id, smoke, this.color, this.canEmitAside, this.emitWithoutChimney, this.identityTag, this.useDroppedItemMeta, this.relatedBlocks);
            }
        }
        ,
        tcomplement$porcelain_melter("", 3, 0.7f, 0x11B9BBBB, true, true, "", "", new String[]{"tcomplement:melter:*", "tconstruct:seared_tank:*"}){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id, Smoke smoke) {
                return new TConstruct.HeatingStructure(config, id, smoke, this.color, this.canEmitAside, this.emitWithoutChimney, this.identityTag, this.useDroppedItemMeta, this.relatedBlocks);
            }
        }
        ,
        tconstruct$smeltery_controller("", 4, 1.0f, 0, true, true, "", "", new String[]{"tconstruct:seared:*", "tconstruct:seared_tank:*", "tconstruct:seared_glass:*", "tconstruct:smeltery_io:*"}){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id, Smoke smoke) {
                return new TConstruct.HeatingStructure(config, id, smoke, this.color, this.canEmitAside, this.emitWithoutChimney, this.identityTag, this.useDroppedItemMeta, this.relatedBlocks);
            }
        }
        ,
        tconstruct$seared_furnace_controller("", 4, 1.0f, 0, true, true, "", "", new String[]{"tconstruct:seared:*", "tconstruct:seared_tank:*", "tconstruct:seared_glass:*"}){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id, Smoke smoke) {
                return new TConstruct.HeatingStructure(config, id, smoke, this.color, this.canEmitAside, this.emitWithoutChimney, this.identityTag, this.useDroppedItemMeta, this.relatedBlocks);
            }
        }
        ,
        teastory$lit_tea_stove("", 4, 1.0f, 0, true),
        techreborn$solid_fuel_generator("techreborn:solid_fuel_generator:[active=true]", 4, 1.0f, 299688420, true),
        techreborn$industrial_blast_furnace("techreborn:industrial_blast_furnace:[active=true]", 5, 1.5f, 299688420, true, false),
        techreborn$iron_alloy_furnace("techreborn:iron_alloy_furnace:[active=true]", 4, 1.0f, 0x11E2E2E2, true),
        techreborn$iron_furnace("techreborn:iron_furnace:[active=true]", 4, 1.0f, 0x11E2E2E2, true),
        teckle$alloy_furnace("teckle:alloyfurnace:[lit=true]", 4, 1.0f, 293356854, true),
        thaumcraft$infernal_furnace("", 8, 2.0f, 289547305, true, true, "CookTime", "", new String[]{"thaumcraft:placeholder_obsidian", "thaumcraft:placeholder_brick"}),
        thaumcraft$smelter_basic("", 4, 1.0f, 289226043, true, true, "BurnTime"),
        thaumcraft$smelter_thaumium("", 5, 1.2f, 287842358, true, true, "BurnTime"),
        thaumcraft$smelter_void("", 6, 1.4f, 286328858, true, true, "BurnTime"),
        thermalexpansion$redstone_furnace("thermalexpansion:machine:0", 4, 1.0f, 0x33FF0000, true, true, "Active"),
        thermalexpansion$induction_smelter("thermalexpansion:machine:3", 4, 1.0f, 0x33FF0000, true, true, "Active"),
        toughasnails$campfire("toughasnails:campfire:[burning=true]", 2, 0.4f, 587163136, false),
        zenfoundry$burner_heater("foundry:burner_heater:[state=on]", 4, 1.0f, 298344984, true, true),
        zenfoundry$mold_station("foundry:mold_station:[state=on]", 4, 1.0f, 0x11D4D4D4, true, true);

        final String id;
        final int smokeAmount;
        final float smokeIntencity;
        final ColorARGB color;
        final boolean canEmitAside;
        final boolean emitWithoutChimney;
        final String activeStateTag;
        final String identityTag;
        final boolean useDroppedItemMeta;
        final String[] relatedBlocks;

        private BuiltInEmitters(String id) {
            this(id, 0, 0.0f, 0, false, false, "", "", new String[0], true);
        }

        private BuiltInEmitters(String id, int smokeAmount, float smokeIntencity, int argbColor, boolean canEmitAside) {
            this(id, smokeAmount, smokeIntencity, argbColor, canEmitAside, true);
        }

        private BuiltInEmitters(String id, int smokeAmount, float smokeIntencity, int argbColor, boolean canEmitAside, boolean emitWithoutChimney) {
            this(id, smokeAmount, smokeIntencity, argbColor, canEmitAside, emitWithoutChimney, "");
        }

        private BuiltInEmitters(String id, int smokeAmount, float smokeIntencity, int argbColor, boolean canEmitAside, boolean emitWithoutChimney, String activeStateTag) {
            this(id, smokeAmount, smokeIntencity, argbColor, canEmitAside, emitWithoutChimney, activeStateTag, "");
        }

        private BuiltInEmitters(String id, int smokeAmount, float smokeIntencity, int argbColor, boolean canEmitAside, boolean emitWithoutChimney, String activeStateTag, String identityTag) {
            this(id, smokeAmount, smokeIntencity, argbColor, canEmitAside, emitWithoutChimney, activeStateTag, identityTag, new String[0]);
        }

        private BuiltInEmitters(String id, int smokeAmount, float smokeIntencity, int argbColor, boolean canEmitAside, boolean emitWithoutChimney, String activeStateTag, String identityTag, String[] relatedBlocks) {
            this(id, smokeAmount, smokeIntencity, argbColor, canEmitAside, emitWithoutChimney, activeStateTag, identityTag, relatedBlocks, false);
        }

        private BuiltInEmitters(String id, int smokeAmount, float smokeIntencity, int argbColor, boolean canEmitAside, boolean emitWithoutChimney, String activeStateTag, String identityTag, String[] relatedBlocks, boolean useDroppedItemMeta) {
            this.id = id;
            this.smokeAmount = smokeAmount;
            this.smokeIntencity = smokeIntencity;
            this.color = ColorARGB.from((int)argbColor);
            this.canEmitAside = canEmitAside;
            this.emitWithoutChimney = emitWithoutChimney;
            this.activeStateTag = activeStateTag;
            this.identityTag = identityTag;
            this.useDroppedItemMeta = useDroppedItemMeta;
            this.relatedBlocks = relatedBlocks;
        }

        public String func_176610_l() {
            return this.name();
        }

        Emitter createEmitter(UnitConfig config, UnitId id, Smoke smoke) {
            return new Emitter(config, id, smoke, this.color, this.canEmitAside, this.emitWithoutChimney, this.activeStateTag, this.identityTag, this.useDroppedItemMeta, this.relatedBlocks);
        }
    }
}

