/*
 * Decompiled with CFR 0.152.
 */
package com.Axeryok.ColorUtility;

import com.Axeryok.ColorUtility.ModLog;
import com.Axeryok.ColorUtility.adapter.ChatAllowedCharactersAdapter;
import com.Axeryok.ColorUtility.adapter.GuiEditSignAdapter;
import com.Axeryok.ColorUtility.adapter.GuiScreenBookAdapter;
import com.Axeryok.ColorUtility.adapter.NetHandlerPlayServerAdapter;
import java.io.FileOutputStream;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ColorUtilityTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.network.NetHandlerPlayServer")) {
            ModLog.log("Open NetHandlerPlayServer.", new Object[0]);
            return this.transformNetHandlerPlayServer(basicClass);
        }
        if (transformedName.equals("net.minecraft.util.ChatAllowedCharacters")) {
            ModLog.log("Open ChatAllowedCharacters.", new Object[0]);
            return this.transformChatAllowedCharacters(basicClass);
        }
        if (transformedName.equals("net.minecraft.client.gui.inventory.GuiEditSign")) {
            ModLog.log("open GuiEditSign", new Object[0]);
            return this.transformGuiEditSign(basicClass);
        }
        if (transformedName.equals("net.minecraft.client.gui.GuiScreenBook")) {
            ModLog.log("open GuiScreenBook", new Object[0]);
            return this.transformGuiScreenBook(basicClass);
        }
        return basicClass;
    }

    private byte[] transformNetHandlerPlayServer(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassWriter cw = new ClassWriter(1);
        NetHandlerPlayServerAdapter cv = new NetHandlerPlayServerAdapter((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private byte[] transformChatAllowedCharacters(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassWriter cw = new ClassWriter(1);
        ChatAllowedCharactersAdapter cv = new ChatAllowedCharactersAdapter((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private byte[] transformGuiEditSign(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassWriter cw = new ClassWriter(1);
        GuiEditSignAdapter cv = new GuiEditSignAdapter((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private byte[] transformGuiScreenBook(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        ClassWriter cw = new ClassWriter(1);
        GuiScreenBookAdapter cv = new GuiScreenBookAdapter((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private void debugFilePut(byte[] bytes) {
        try {
            FileOutputStream output = new FileOutputStream("test.class");
            output.write(bytes);
            output.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

