/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements;

import com.brandon3055.brandonscore.client.BCClientEventHandler;
import com.brandon3055.brandonscore.client.BCTextures;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.LayoutHelper;
import com.brandon3055.brandonscore.client.gui.modulargui.markdown.mdelements.MDElementBase;
import com.brandon3055.brandonscore.integration.JeiHelper;
import com.brandon3055.brandonscore.integration.PIHelper;
import com.brandon3055.brandonscore.lib.StackReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Mouse;

public class StackElement
extends MDElementBase<StackElement> {
    private ItemStack[] stacks;
    public boolean drawSlot = false;

    public StackElement(String stackString) {
        this.enableTooltip = true;
        this.size = 16;
        boolean isOre = OreDictionary.doesOreNameExist((String)stackString);
        ArrayList<ItemStack> baseStacks = new ArrayList<ItemStack>();
        if (isOre) {
            baseStacks.addAll((Collection<ItemStack>)OreDictionary.getOres((String)stackString));
        } else {
            ItemStack stack;
            StackReference stackRef = StackReference.fromString(stackString);
            if (stackRef == null || (stack = stackRef.createStack()).func_190926_b()) {
                this.error("[Broken Stack. Specified Item or Block could not be found!]");
                return;
            }
            baseStacks.add(stack);
        }
        NonNullList finalStacks = NonNullList.func_191196_a();
        for (ItemStack stack : baseStacks) {
            if (stack.func_77960_j() == Short.MAX_VALUE && stack.func_77981_g()) {
                stack.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, finalStacks);
                continue;
            }
            finalStacks.add((Object)stack);
        }
        this.stacks = (ItemStack[])finalStacks.toArray((Object[])new ItemStack[finalStacks.size()]);
    }

    @Override
    public void layoutElement(LayoutHelper layout, List<MDElementBase> lineElement) {
        this.setSize(this.size, this.size);
        super.layoutElement(layout, lineElement);
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.stacks.length == 0) {
            return;
        }
        GlStateManager.func_179094_E();
        if (this.drawSlot) {
            this.bindTexture(BCTextures.MODULAR_GUI);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.drawScaledCustomSizeModalRect(this.xPos(), this.yPos(), 0.0, 0.0, 18.0, 18.0, this.xSize(), this.ySize(), 255.0, 255.0);
        }
        double scale = (double)this.size / 18.0;
        ItemStack stack = this.stacks[BCClientEventHandler.elapsedTicks / 40 % this.stacks.length];
        RenderHelper.func_74520_c();
        GlStateManager.func_179137_b((double)((double)this.xPos() + scale), (double)((double)this.yPos() + scale), (double)(this.getRenderZLevel() - 80.0));
        GlStateManager.func_179139_a((double)scale, (double)scale, (double)1.0);
        minecraft.func_175599_af().func_175042_a(stack, 0, 0);
        if (stack.func_190916_E() > 1) {
            String s = "\u00a7f" + stack.func_190916_E() + "" + "\u00a7" + "f";
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(-(this.getRenderZLevel() - 80.0)));
            this.zOffset += 45.0;
            this.drawString(this.fontRenderer, s, 18 - this.fontRenderer.func_78256_a(s) - 1, this.fontRenderer.field_78288_b, 0xFFFFFF, true);
            this.zOffset -= 45.0;
        }
        GlStateManager.func_179131_c((float)this.fontRenderer.field_78291_n, (float)this.fontRenderer.field_78292_o, (float)this.fontRenderer.field_78306_p, (float)1.0f);
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.enableTooltip && this.isMouseOver(mouseX, mouseY)) {
            if (this.tooltip.isEmpty()) {
                ItemStack stack = this.stacks[BCClientEventHandler.elapsedTicks / 40 % this.stacks.length];
                List list = stack.func_82840_a((EntityPlayer)this.mc.field_71439_g, (ITooltipFlag)(this.mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
                for (int i = 0; i < list.size(); ++i) {
                    if (i == 0) {
                        list.set(i, stack.func_77953_t().field_77937_e + (String)list.get(i));
                        continue;
                    }
                    list.set(i, TextFormatting.GRAY + (String)list.get(i));
                }
                GuiUtils.preItemToolTip((ItemStack)stack);
                this.drawHoveringText(stack, list, mouseX, mouseY, this.screenWidth, this.screenHeight, -1, this.fontRenderer);
                GuiUtils.postItemToolTip();
            } else {
                this.drawHoveringText(this.tooltip, mouseX, mouseY, this.fontRenderer, this.screenWidth, this.screenHeight);
            }
            return true;
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.isMouseOver(mouseX, mouseY) && (mouseButton == 0 || mouseButton == 1)) {
            ItemStack stack = this.stacks[BCClientEventHandler.elapsedTicks / 40 % this.stacks.length];
            JeiHelper.openJEIRecipe(stack, mouseButton == 1);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    protected boolean keyTyped(char typedChar, int keyCode) throws IOException {
        int mouseY;
        int mouseX = Mouse.getX() * this.screenWidth / this.mc.field_71443_c;
        if (this.isMouseOver(mouseX, mouseY = this.screenHeight - Mouse.getY() * this.screenHeight / this.mc.field_71440_d - 1)) {
            List<String> pages;
            ItemStack stack = this.stacks[BCClientEventHandler.elapsedTicks / 40 % this.stacks.length];
            if (keyCode == JeiHelper.getRecipeKey(false)) {
                JeiHelper.openJEIRecipe(stack, false);
                return true;
            }
            if (keyCode == JeiHelper.getRecipeKey(true)) {
                JeiHelper.openJEIRecipe(stack, true);
                return true;
            }
            if (PIHelper.isInstalled() && keyCode == PIHelper.getETGuiKey().func_151463_i() && !(pages = PIHelper.getRelatedPages(stack)).isEmpty()) {
                PIHelper.openGui(this.modularGui.getScreen(), pages);
                return true;
            }
        }
        return super.keyTyped(typedChar, keyCode);
    }
}

