/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.integration.mcmultipart;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mcmultipart.RayTraceHelper;
import mcmultipart.api.container.IMultipartContainer;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.multipart.MultipartHelper;
import mcmultipart.api.slot.IPartSlot;
import mcmultipart.multipart.PartInfo;
import mcmultipart.util.MCMPWorldWrapper;
import mod.chiselsandbits.chiseledblock.TileEntityBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.BitCollisionIterator;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.integration.mcmultipart.ChiseledBlockPart;
import mod.chiselsandbits.integration.mcmultipart.IMCMultiPart;
import mod.chiselsandbits.integration.mcmultipart.MultiPartSlots;
import mod.chiselsandbits.integration.mcmultipart.MultipartContainerBuilder;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class MCMultipart2Proxy
implements IMCMultiPart {
    @Override
    public void swapRenderIfPossible(TileEntity current, TileEntityBlockChiseled newTileEntity) {
    }

    @Override
    public void removePartIfPossible(TileEntity te) {
        if (te.func_145831_w() instanceof MCMPWorldWrapper) {
            MCMPWorldWrapper wrapper = (MCMPWorldWrapper)te.func_145831_w();
            te = ModUtil.getTileEntitySafely((IBlockAccess)wrapper.getActualWorld(), te.func_174877_v());
        }
        if (te instanceof IMultipartContainer && !te.func_145831_w().field_72995_K) {
            IMultipartContainer container = (IMultipartContainer)te;
            container.removePart((IPartSlot)MultiPartSlots.BITS);
        }
    }

    @Override
    public TileEntityBlockChiseled getPartIfPossible(World w, BlockPos pos, boolean create) {
        Optional container = MultipartHelper.getOrConvertContainer((World)w, (BlockPos)pos);
        if (container.isPresent()) {
            Optional part = ((IMultipartContainer)container.get()).getPartTile((IPartSlot)MultiPartSlots.BITS);
            if (part.isPresent() && part.get() instanceof TileEntityBlockChiseled) {
                return (TileEntityBlockChiseled)part.get();
            }
            if (MultipartHelper.addPart((World)w, (BlockPos)pos, (IPartSlot)MultiPartSlots.BITS, (IBlockState)ChiselsAndBits.getBlocks().getChiseledDefaultState(), (boolean)true)) {
                if (create && !w.field_72995_K) {
                    ChiseledBlockPart tx = new ChiseledBlockPart(null);
                    tx.occlusionState = new MultipartContainerBuilder(w, pos, tx, (IMultipartContainer)container.get());
                    tx.func_145834_a(w);
                    tx.func_174878_a(pos);
                    return tx;
                }
                if (create) {
                    ChiseledBlockPart tx = new ChiseledBlockPart(null);
                    tx.func_145834_a(w);
                    tx.func_174878_a(pos);
                    return tx;
                }
            }
        }
        return null;
    }

    @Override
    public void triggerPartChange(TileEntity te) {
        Optional part;
        if (te instanceof IMultipartContainer && !te.func_145831_w().field_72995_K && (part = ((IMultipartContainer)te).get((IPartSlot)MultiPartSlots.BITS)).isPresent()) {
            ((IPartInfo)part.get()).notifyChange();
        }
    }

    @Override
    public boolean isMultiPart(World w, BlockPos pos) {
        return MultipartHelper.getContainer((IBlockAccess)w, (BlockPos)pos) != null || MultipartHelper.addPart((World)w, (BlockPos)pos, (IPartSlot)MultiPartSlots.BITS, (IBlockState)ChiselsAndBits.getBlocks().getChiseledDefaultState(), (boolean)true);
    }

    @Override
    public void populateBlobWithUsedSpace(World w, BlockPos pos, VoxelBlob vb) {
        Optional mc;
        if (this.isMultiPart(w, pos) && (mc = MultipartHelper.getOrConvertContainer((World)w, (BlockPos)pos)).isPresent()) {
            IMultipartContainer mcc = (IMultipartContainer)mc.get();
            Predicate<IPartSlot> ignoreMe = which -> MultiPartSlots.BITS == which;
            List partBoxes = mcc.getParts().values().stream().filter(i -> !ignoreMe.test(i.getSlot())).map(i -> i.getPart().getOcclusionBoxes(i)).flatMap(Collection::stream).collect(Collectors.toList());
            if (partBoxes.isEmpty()) {
                return;
            }
            BitCollisionIterator bci = new BitCollisionIterator();
            block0: while (bci.hasNext()) {
                AxisAlignedBB bitBox = bci.getBoundingBox();
                for (AxisAlignedBB b : partBoxes) {
                    if (!b.func_72326_a(bitBox)) continue;
                    bci.setNext(vb, 1);
                    continue block0;
                }
            }
        }
    }

    @Override
    public boolean rotate(World world, BlockPos pos, EntityPlayer player) {
        IBlockState state;
        Block blk;
        IMultipartContainer container = MultipartHelper.getContainer((IBlockAccess)world, (BlockPos)pos).orElse(null);
        if (container != null && (blk = (state = world.func_180495_p(pos)).func_177230_c()) != null) {
            Pair atob = RayTraceHelper.getRayTraceVectors((EntityPlayer)player);
            RayTraceResult crt = blk.func_180636_a(state, world, pos, (Vec3d)atob.getKey(), (Vec3d)atob.getValue());
            if (crt.hitInfo instanceof PartInfo) {
                // empty if block
            }
        }
        return false;
    }

    @Override
    public TileEntityBlockChiseled getPartFromBlockAccess(IBlockAccess w, BlockPos pos) {
        TileEntity te = ModUtil.getTileEntitySafely(w, pos);
        IMultipartContainer container = null;
        if (te instanceof IMultipartContainer) {
            container = (IMultipartContainer)te;
        }
        if (container != null) {
            return container.getPartTile((IPartSlot)MultiPartSlots.BITS).orElse(null);
        }
        return null;
    }
}

