/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.registry;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.blay09.mods.farmingforblockheads.api.FarmingForBlockheadsAPI;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.api.MarketRegistryDefaultHandler;
import net.blay09.mods.farmingforblockheads.registry.AbstractRegistry;
import net.blay09.mods.farmingforblockheads.registry.MarketEntry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class MarketRegistry
extends AbstractRegistry {
    public static final MarketRegistry INSTANCE = new MarketRegistry();
    private static final Pattern ITEMSTACK_PATTERN = Pattern.compile("(?:([0-9]+)\\*)?(?:([\\w\\-]+):)([\\w\\-]+)(?::([0-9]+))?(?:@(.+))?");
    private final Map<ResourceLocation, IMarketCategory> indexedCategories = Maps.newHashMap();
    private final ArrayListMultimap<IMarketCategory, IMarketEntry> entries = ArrayListMultimap.create();
    private final Map<String, ItemStack> defaultPayments = Maps.newHashMap();
    private final Map<String, Integer> defaultAmounts = Maps.newHashMap();
    private final Map<String, MarketRegistryDefaultHandler> defaultHandlers = Maps.newHashMap();

    public MarketRegistry() {
        super("Market");
    }

    public void registerCategory(IMarketCategory category) {
        if (this.indexedCategories.containsKey(category.getRegistryName())) {
            throw new RuntimeException("Attempted to register duplicate market category " + category.getRegistryName());
        }
        this.indexedCategories.put(category.getRegistryName(), category);
    }

    public void registerEntry(ItemStack outputItem, ItemStack costItem, IMarketCategory type) {
        this.entries.put((Object)type, (Object)new MarketEntry(outputItem, costItem, type));
    }

    @Nullable
    public static IMarketEntry getEntryFor(ItemStack outputItem) {
        for (IMarketEntry entry : MarketRegistry.INSTANCE.entries.values()) {
            if (!entry.getOutputItem().func_77969_a(outputItem) || !ItemStack.func_77970_a((ItemStack)entry.getOutputItem(), (ItemStack)outputItem) || outputItem.func_190916_E() != entry.getOutputItem().func_190916_E()) continue;
            return entry;
        }
        return null;
    }

    public static ArrayListMultimap<IMarketCategory, IMarketEntry> getGroupedEntries() {
        return MarketRegistry.INSTANCE.entries;
    }

    public static Collection<IMarketEntry> getEntries() {
        return MarketRegistry.INSTANCE.entries.values();
    }

    @Override
    protected void clear() {
        this.entries.clear();
    }

    @Override
    protected JsonObject create() {
        JsonObject root = new JsonObject();
        JsonObject defaults = new JsonObject();
        defaults.addProperty("__comment", "You can disable defaults by setting these to false. Do *NOT* try to add additional entries here. You can add additional entries in the custom section.");
        root.add("defaults", (JsonElement)defaults);
        JsonObject payment = new JsonObject();
        payment.addProperty("__comment", "You can define custom payment items for the default entries here.");
        root.add("defaults payment", (JsonElement)payment);
        JsonObject amount = new JsonObject();
        amount.addProperty("__comment", "You can define custom amounts for the default entries here.");
        root.add("defaults amount", (JsonElement)amount);
        JsonArray blacklist = new JsonArray();
        blacklist.add((JsonElement)new JsonPrimitive("examplemod:example_item"));
        root.add("defaults blacklist", (JsonElement)blacklist);
        JsonObject custom = new JsonObject();
        custom.addProperty("__comment", "You can define additional items to be sold by the Market here. Defaults can be overridden. Prefix with ! to blacklist instead.");
        custom.addProperty("examplemod:example_item", "2*minecraft:emerald");
        root.add("custom entries", (JsonElement)custom);
        return root;
    }

    @Override
    protected void load(JsonObject root) {
        JsonObject payments = this.tryGetObject(root, "defaults payment");
        this.loadDefaultPayments(payments);
        JsonObject amounts = this.tryGetObject(root, "defaults amount");
        this.loadDefaultAmounts(amounts);
        JsonObject defaults = this.tryGetObject(root, "defaults");
        this.registerDefaults(defaults);
        JsonArray blacklist = this.tryGetArray(root, "defaults blacklist");
        for (int i = 0; i < blacklist.size(); ++i) {
            JsonElement element = blacklist.get(i);
            if (element.isJsonPrimitive()) {
                this.loadDefaultBlacklistEntry(element.getAsString());
                continue;
            }
            this.logError("Failed to load %s registry: blacklist entries must be strings", this.registryName);
        }
        JsonObject custom = this.tryGetObject(root, "custom entries");
        for (Map.Entry entry : custom.entrySet()) {
            if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                this.loadMarketEntry((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                continue;
            }
            this.logError("Failed to load %s registry: entries must be strings", this.registryName);
        }
    }

    @Override
    protected boolean hasCustomLoader() {
        return true;
    }

    private void loadMarketEntry(String key, String value) {
        if (key.equals("__comment") || key.equals("examplemod:example_item")) {
            return;
        }
        ItemStack outputStack = this.parseItemStack(key);
        ItemStack costStack = this.parseItemStack(value);
        if (outputStack.func_190926_b() || costStack.func_190926_b()) {
            return;
        }
        this.tryRemoveEntry(outputStack);
        IMarketCategory category = FarmingForBlockheadsAPI.getMarketCategoryOther();
        ResourceLocation registryName = outputStack.func_77973_b().getRegistryName();
        if (registryName != null) {
            if (registryName.func_110623_a().contains("sapling")) {
                category = FarmingForBlockheadsAPI.getMarketCategorySaplings();
            } else if (registryName.func_110623_a().contains("seed")) {
                category = FarmingForBlockheadsAPI.getMarketCategorySeeds();
            } else if (registryName.func_110623_a().contains("flower")) {
                category = FarmingForBlockheadsAPI.getMarketCategoryFlowers();
            }
        }
        this.registerEntry(outputStack, costStack, category);
    }

    private void loadDefaultBlacklistEntry(String input) {
        if (input.equals("examplemod:example_item")) {
            return;
        }
        ItemStack itemStack = this.parseItemStack(input);
        if (!itemStack.func_190926_b() && !this.tryRemoveEntry(itemStack)) {
            this.logError("Could not find default entry for blacklisted item %s", input);
        }
    }

    private void loadDefaultPayments(JsonObject defaults) {
        for (Map.Entry<String, MarketRegistryDefaultHandler> entry : this.defaultHandlers.entrySet()) {
            ItemStack itemStack;
            String value = this.tryGetString(defaults, entry.getKey(), "");
            if (value.isEmpty()) {
                ItemStack defaultPayment = entry.getValue().getDefaultPayment();
                defaults.addProperty(entry.getKey(), String.format("%d*%s:%d", defaultPayment.func_190916_E(), defaultPayment.func_77973_b().getRegistryName(), defaultPayment.func_77952_i()));
            }
            ItemStack itemStack2 = itemStack = !value.isEmpty() ? this.parseItemStack(value) : null;
            if (itemStack == null) {
                itemStack = entry.getValue().getDefaultPayment();
            }
            this.defaultPayments.put(entry.getKey(), itemStack);
        }
    }

    private void loadDefaultAmounts(JsonObject defaults) {
        for (Map.Entry<String, MarketRegistryDefaultHandler> entry : this.defaultHandlers.entrySet()) {
            int value = this.tryGetInt(defaults, entry.getKey(), 1);
            if (!defaults.has(entry.getKey())) {
                int defaultAmount = entry.getValue().getDefaultAmount();
                defaults.addProperty(entry.getKey(), (Number)defaultAmount);
            }
            this.defaultAmounts.put(entry.getKey(), value);
        }
    }

    @Override
    protected void registerDefaults(JsonObject json) {
        for (Map.Entry<String, MarketRegistryDefaultHandler> entry : this.defaultHandlers.entrySet()) {
            if (!this.tryGetBoolean(json, entry.getKey(), entry.getValue().isEnabledByDefault())) continue;
            entry.getValue().apply(MarketRegistry.INSTANCE.defaultPayments.get(entry.getKey()), MarketRegistry.INSTANCE.defaultAmounts.get(entry.getKey()));
        }
    }

    public static void registerDefaultHandler(String defaultKey, MarketRegistryDefaultHandler handler) {
        if (MarketRegistry.INSTANCE.defaultHandlers.containsKey(defaultKey)) {
            throw new RuntimeException("Attempted to register duplicate default handler");
        }
        MarketRegistry.INSTANCE.defaultHandlers.put(defaultKey, handler);
    }

    private boolean tryRemoveEntry(ItemStack itemStack) {
        Iterator it = this.entries.values().iterator();
        while (it.hasNext()) {
            IMarketEntry entry = (IMarketEntry)it.next();
            if (!entry.getOutputItem().func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)entry.getOutputItem(), (ItemStack)itemStack) || itemStack.func_190916_E() != entry.getOutputItem().func_190916_E()) continue;
            it.remove();
            return true;
        }
        return false;
    }

    private ItemStack parseItemStack(String input) {
        Matcher matcher = ITEMSTACK_PATTERN.matcher(input);
        if (!matcher.find()) {
            this.logError("Invalid item %s, format mismatch", input);
            return ItemStack.field_190927_a;
        }
        ResourceLocation resourceLocation = new ResourceLocation(matcher.group(2), matcher.group(3));
        Item item = (Item)Item.field_150901_e.func_82594_a((Object)resourceLocation);
        if (item == null) {
            this.logUnknownItem(resourceLocation);
            return ItemStack.field_190927_a;
        }
        int count = matcher.group(1) != null ? this.tryParseInt(matcher.group(1)) : 1;
        int meta = matcher.group(4) != null ? this.tryParseInt(matcher.group(4)) : 0;
        String nbt = matcher.group(5);
        NBTTagCompound tagCompound = null;
        if (nbt != null) {
            try {
                tagCompound = JsonToNBT.func_180713_a((String)nbt);
            }
            catch (NBTException e) {
                this.logError("Invalid nbt for item %s, %s", input, e.getMessage());
            }
        }
        ItemStack itemStack = new ItemStack(item, count, meta);
        if (tagCompound != null) {
            itemStack.func_77982_d(tagCompound);
        }
        return itemStack;
    }

    public static Collection<IMarketCategory> getCategories() {
        return MarketRegistry.INSTANCE.indexedCategories.values();
    }

    @Nullable
    public static IMarketCategory getCategory(ResourceLocation id) {
        return MarketRegistry.INSTANCE.indexedCategories.get(id);
    }
}

