/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.client.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketEntry;
import net.blay09.mods.farmingforblockheads.client.gui.GuiButtonMarketFilter;
import net.blay09.mods.farmingforblockheads.container.ContainerMarketClient;
import net.blay09.mods.farmingforblockheads.container.FakeSlotMarket;
import net.blay09.mods.farmingforblockheads.container.SlotMarketBuy;
import net.blay09.mods.farmingforblockheads.registry.MarketRegistry;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Mouse;
import yalter.mousetweaks.api.MouseTweaksIgnore;

@MouseTweaksIgnore
public class GuiMarket
extends GuiContainer {
    private static final int SCROLLBAR_COLOR = -5592406;
    private static final int SCROLLBAR_Y = 8;
    private static final int SCROLLBAR_WIDTH = 7;
    private static final int SCROLLBAR_HEIGHT = 77;
    private static final int VISIBLE_ROWS = 4;
    private static final ResourceLocation TEXTURE = new ResourceLocation("farmingforblockheads", "textures/gui/market.png");
    private final ContainerMarketClient container;
    private final List<GuiButtonMarketFilter> filterButtons = Lists.newArrayList();
    private boolean isEventHandler;
    private int scrollBarScaledHeight;
    private int scrollBarXPos;
    private int scrollBarYPos;
    private int currentOffset;
    private int mouseClickY = -1;
    private int indexWhenClicked;
    private int lastNumberOfMoves;
    private GuiTextField searchBar;

    public GuiMarket(ContainerMarketClient container) {
        super((Container)container);
        this.container = container;
    }

    public void func_73866_w_() {
        IMarketCategory[] categories;
        this.field_147000_g = 174;
        super.func_73866_w_();
        this.searchBar = new GuiTextField(0, this.field_146289_q, this.field_147003_i + this.field_146999_f - 78, this.field_147009_r - 5, 70, 10);
        int id = 1;
        int curY = -80;
        for (IMarketCategory category : categories = (IMarketCategory[])MarketRegistry.getCategories().stream().sorted().toArray(IMarketCategory[]::new)) {
            if (MarketRegistry.getGroupedEntries().get((Object)category).isEmpty()) continue;
            GuiButtonMarketFilter filterButton = new GuiButtonMarketFilter(id++, this.field_146294_l / 2 + 87, this.field_146295_m / 2 + curY, this.container, category);
            this.field_146292_n.add(filterButton);
            this.filterButtons.add(filterButton);
            curY += 20;
        }
        if (!this.isEventHandler) {
            MinecraftForge.EVENT_BUS.register((Object)this);
            this.isEventHandler = true;
        }
        this.recalculateScrollBar();
    }

    protected void func_146284_a(GuiButton button) {
        if (button instanceof GuiButtonMarketFilter) {
            if (this.container.getCurrentCategory() == ((GuiButtonMarketFilter)button).getCategory()) {
                this.container.setFilterCategory(null);
            } else {
                this.container.setFilterCategory(((GuiButtonMarketFilter)button).getCategory());
            }
            this.container.populateMarketSlots();
            this.setCurrentOffset(this.currentOffset);
        }
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int delta = Mouse.getEventDWheel();
        if (delta == 0) {
            return;
        }
        this.setCurrentOffset(delta > 0 ? this.currentOffset - 1 : this.currentOffset + 1);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        if (state != -1 && this.mouseClickY != -1) {
            this.mouseClickY = -1;
            this.indexWhenClicked = 0;
            this.lastNumberOfMoves = 0;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        if (button == 1 && mouseX >= this.searchBar.field_146209_f && mouseX < this.searchBar.field_146209_f + this.searchBar.field_146218_h && mouseY >= this.searchBar.field_146210_g && mouseY < this.searchBar.field_146210_g + this.searchBar.field_146219_i) {
            this.searchBar.func_146180_a("");
            this.container.search(null);
            this.container.populateMarketSlots();
            this.setCurrentOffset(this.currentOffset);
        } else {
            this.searchBar.func_146192_a(mouseX, mouseY, button);
        }
        if (mouseX >= this.scrollBarXPos && mouseX <= this.scrollBarXPos + 7 && mouseY >= this.scrollBarYPos && mouseY <= this.scrollBarYPos + this.scrollBarScaledHeight) {
            this.mouseClickY = mouseY;
            this.indexWhenClicked = this.currentOffset;
        }
    }

    protected void func_73869_a(char c, int keyCode) throws IOException {
        if (this.searchBar.func_146201_a(c, keyCode)) {
            this.container.search(this.searchBar.func_146179_b());
            this.container.populateMarketSlots();
            this.setCurrentOffset(this.currentOffset);
        } else {
            super.func_73869_a(c, keyCode);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        for (GuiButton guiButton : this.filterButtons) {
            if (!guiButton.func_146115_a() || !guiButton.field_146124_l) continue;
            this.func_146283_a(((GuiButtonMarketFilter)guiButton).getTooltipLines(), mouseX, mouseY);
        }
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        int numberOfFiltersMoved;
        float pixelsPerFilter;
        if (this.container.isDirty()) {
            this.recalculateScrollBar();
            this.container.setDirty(false);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r - 10, 0, 0, this.field_146999_f, this.field_147000_g + 10);
        if (this.container.getSelectedEntry() != null && !this.container.isReadyToBuy()) {
            this.func_73729_b(this.field_147003_i + 43, this.field_147009_r + 40, 176, 0, 14, 14);
        }
        if (this.mouseClickY != -1 && (pixelsPerFilter = (float)(77 - this.scrollBarScaledHeight) / (float)Math.max(1, (int)Math.ceil((float)this.container.getFilteredListCount() / 3.0f) - 4)) != 0.0f && (numberOfFiltersMoved = (int)((float)(mouseY - this.mouseClickY) / pixelsPerFilter)) != this.lastNumberOfMoves) {
            this.setCurrentOffset(this.indexWhenClicked + numberOfFiltersMoved);
            this.lastNumberOfMoves = numberOfFiltersMoved;
        }
        this.field_146289_q.func_175065_a(I18n.func_135052_a((String)"container.farmingforblockheads:market", (Object[])new Object[0]), (float)(this.field_147003_i + 10), (float)(this.field_147009_r + 10), 0xFFFFFF, true);
        if (this.container.getSelectedEntry() == null) {
            this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.farmingforblockheads:market.no_selection", (Object[])new Object[0]), this.field_147003_i + 49, this.field_147009_r + 65, 0xFFFFFF);
        } else {
            this.func_73732_a(this.field_146289_q, this.getFormattedCostStringShort(this.container.getSelectedEntry()), this.field_147003_i + 49, this.field_147009_r + 65, 0xFFFFFF);
        }
        GuiContainer.func_73734_a((int)this.scrollBarXPos, (int)this.scrollBarYPos, (int)(this.scrollBarXPos + 7), (int)(this.scrollBarYPos + this.scrollBarScaledHeight), (int)-5592406);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.searchBar.func_146194_f();
    }

    public Collection<GuiButtonMarketFilter> getFilterButtons() {
        return this.filterButtons;
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (this.isEventHandler) {
            MinecraftForge.EVENT_BUS.unregister((Object)this);
            this.isEventHandler = false;
        }
    }

    public void recalculateScrollBar() {
        int scrollBarTotalHeight = 76;
        this.scrollBarScaledHeight = (int)((double)scrollBarTotalHeight * Math.min(1.0, 4.0 / Math.ceil((float)this.container.getFilteredListCount() / 3.0f)));
        this.scrollBarXPos = this.field_147003_i + this.field_146999_f - 7 - 9;
        this.scrollBarYPos = this.field_147009_r + 8 + (scrollBarTotalHeight - this.scrollBarScaledHeight) * this.currentOffset / Math.max(1, (int)Math.ceil((float)this.container.getFilteredListCount() / 3.0f) - 4);
    }

    public void setCurrentOffset(int currentOffset) {
        this.currentOffset = Math.max(0, Math.min(currentOffset, (int)Math.ceil((float)this.container.getFilteredListCount() / 3.0f) - 4));
        this.container.setScrollOffset(this.currentOffset);
        this.recalculateScrollBar();
    }

    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        Slot hoverSlot = this.getSlotUnderMouse();
        if (hoverSlot != null && event.getItemStack() == hoverSlot.func_75211_c()) {
            IMarketEntry hoverEntry = null;
            if (hoverSlot instanceof FakeSlotMarket) {
                hoverEntry = ((FakeSlotMarket)hoverSlot).getEntry();
            } else if (hoverSlot instanceof SlotMarketBuy) {
                hoverEntry = this.container.getSelectedEntry();
            }
            if (hoverEntry != null) {
                event.getToolTip().add(this.getFormattedCostString(hoverEntry));
            }
        }
    }

    private String getFormattedCostString(IMarketEntry entry) {
        String color = TextFormatting.GREEN.toString();
        if (entry.getCostItem().func_77973_b() == Items.field_151045_i) {
            color = TextFormatting.AQUA.toString();
        }
        return color + I18n.func_135052_a((String)"gui.farmingforblockheads:market.tooltip_cost", (Object[])new Object[]{I18n.func_135052_a((String)"gui.farmingforblockheads:market.cost", (Object[])new Object[]{entry.getCostItem().func_190916_E(), entry.getCostItem().func_82833_r()})});
    }

    private String getFormattedCostStringShort(IMarketEntry entry) {
        String color = TextFormatting.GREEN.toString();
        String unlocalizedName = entry.getCostItem().func_77977_a().toLowerCase(Locale.ENGLISH);
        if (unlocalizedName.contains("diamond")) {
            color = TextFormatting.AQUA.toString();
        } else if (unlocalizedName.contains("gold")) {
            color = TextFormatting.YELLOW.toString();
        } else if (unlocalizedName.contains("iron")) {
            color = TextFormatting.WHITE.toString();
        }
        return color + I18n.func_135052_a((String)"gui.farmingforblockheads:market.cost", (Object[])new Object[]{entry.getCostItem().func_190916_E(), entry.getCostItem().func_82833_r()});
    }
}

