/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.api.IEmitter;
import com.endertech.minecraft.forge.blocks.BlockState;
import com.endertech.minecraft.forge.units.RelatedUnitsInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.ForgeWorld;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;

public abstract class EmittersInit<T extends IEmitter, E extends Enum<?>>
extends RelatedUnitsInit<T, E> {
    private final Map<ResourceLocation, T> entities = new ConcurrentHashMap<ResourceLocation, T>();

    public EmittersInit(ForgeMod mod, Class<E> builtIn) {
        super(mod, builtIn);
    }

    @Override
    protected void clearAttachedStates() {
        this.entities.clear();
        super.clearAttachedStates();
    }

    @Override
    protected void attachToStates() {
        this.clearAttachedStates();
        for (IEmitter emitter : this.getAll()) {
            if (emitter.isEntity()) {
                UnitId id = emitter.getRelatedId();
                if (!Loader.isModLoaded((String)id.getModId())) continue;
                this.entities.put(id.toResLoc(), emitter);
                continue;
            }
            this.attachToBlockStates(emitter);
            this.attachToItemStates(emitter);
        }
    }

    @Nullable
    public T findBy(Entity entity) {
        ResourceLocation key = EntityList.func_191301_a((Entity)entity);
        return (T)(key != null ? (IEmitter)this.entities.get(key) : null);
    }

    @Nullable
    public T findBy(World world, BlockPos pos) {
        TileEntity tile;
        IBlockState state = world.func_180495_p(pos);
        IEmitter emitter = (IEmitter)this.findBy(state);
        if (emitter == null) {
            return null;
        }
        if (emitter.useDroppedItemMeta()) {
            BlockState droppedState = ForgeWorld.getBlockDroppedState(world, pos);
            IEmitter actualEmitter = (IEmitter)this.findBy(droppedState);
            if (actualEmitter != null && actualEmitter != emitter) {
                emitter = actualEmitter;
            } else {
                return null;
            }
        }
        if (emitter.isIdentified((INBTSerializable<NBTTagCompound>)(tile = world.func_175625_s(pos)))) {
            return (T)emitter;
        }
        return null;
    }

    @Override
    public void onPostInit(FMLPostInitializationEvent event) {
        super.onPostInit(event);
        for (IEmitter unit : this.getAll()) {
            unit.onPostInit(event);
            for (BlockState state : unit.getRelatedId().getAllBlockStates()) {
                if (!state.exists() || state.isAir()) continue;
                state.getBlock().func_149675_a(true);
            }
        }
    }
}

