/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.items;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.endertech.minecraft.forge.units.UnitEnabled;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.units.UnitVariant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

public class ForgeItem
extends Item
implements IForgeUnit {
    private final UnitEnabled unitEnabled;
    private final ForgeConfig config;
    private final UnitId id;
    private final ForgeMod mod;
    private Map<Object, UnitVariant> variants = new HashMap<Object, UnitVariant>();
    private final UnitVariant defaultVariant;

    public ForgeItem(ForgeMod mod, UnitConfig config, CreativeTabs tab) {
        this(mod, config, "", tab);
    }

    public ForgeItem(ForgeMod mod, UnitConfig config, String name, CreativeTabs tab) {
        this.mod = mod;
        this.id = this.createId(mod.getId(), name);
        this.config = config;
        this.unitEnabled = new UnitEnabled(config, this.getUnitCategory(), true);
        this.defaultVariant = UnitVariant.from(this.id, IForgeUnit.Variants.INVENTORY);
        this.setRegistryName(this.getId().toResLoc());
        this.func_77655_b(this.getId().getRegName());
        this.func_77637_a(tab);
        this.register();
    }

    public static UUID getAttackDamageModifierUUID() {
        return field_111210_e;
    }

    public static UUID getAttackSpeedModifierUUID() {
        return field_185050_h;
    }

    public static List<String> getOreDictNamesFor(ItemStack stack) {
        if (stack.func_190926_b()) {
            return Collections.emptyList();
        }
        int[] oreIds = OreDictionary.getOreIDs((ItemStack)stack);
        ArrayList<String> oreNames = new ArrayList<String>(oreIds.length);
        for (int i = 0; i < oreIds.length; ++i) {
            oreNames.add(OreDictionary.getOreName((int)oreIds[i]));
        }
        return oreNames;
    }

    @Nullable
    @Deprecated
    public static ItemStack getItemStackOrNull(IForgeUnit unit, int amount) {
        String CANT_CREATE_STACK = "Can't create stack: {}";
        Logger logger = ForgeMain.instance.getLogger();
        if (unit != null) {
            if (unit.isRegistered()) {
                if (unit instanceof Block) {
                    return new ItemStack((Block)unit, amount);
                }
                if (unit instanceof Item) {
                    return new ItemStack((Item)unit, amount);
                }
                logger.error("Can't create stack: {}", (Object)"specified unit is neither block nor item!");
            } else {
                logger.error("Can't create stack: {}", (Object)"unit is not registered!");
            }
        } else {
            logger.error("Can't create stack: {}", (Object)"unit is NULL!");
        }
        return null;
    }

    @Nullable
    public static ItemStack findItemStackInOreDict(String oreDictName, int amount) {
        ItemStack stack;
        NonNullList list;
        if (oreDictName != null && (list = OreDictionary.getOres((String)oreDictName, (boolean)false)) != null && !list.isEmpty() && (stack = (ItemStack)list.get(0)) != null) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(amount);
            return copy;
        }
        return null;
    }

    public static String getStringId(Item item) {
        return UnitId.from(item, 0).toString();
    }

    public String toString() {
        return ForgeItem.class.getSimpleName() + Args.group(Args.get("status", IForgeUnit.getStatus(this)), Args.get("regName", this.getId().getRegName()), Args.get("enabled", this.isEnabled()));
    }

    @Override
    public boolean isEnabled() {
        return this.unitEnabled.isEnabled();
    }

    @Override
    public boolean isRegistered() {
        return ForgeItem.isRegistered(this);
    }

    @Override
    public void onInit() {
        this.saveConfig();
    }

    @Override
    public boolean isReadyToRegister() {
        return true;
    }

    @Override
    public UnitId getId() {
        return this.id;
    }

    @Override
    public ForgeConfig getConfig() {
        return this.config;
    }

    public static void damageItem(int damage, ItemStack stack, @Nullable EntityLivingBase damager, boolean destroyBroken) {
        EntityPlayer player;
        EntityPlayer entityPlayer = player = damager instanceof EntityPlayer ? (EntityPlayer)damager : null;
        if (player != null && player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (stack != null && stack.func_77984_f()) {
            if (stack.func_96631_a(damage, (Random)CommonMath.RANDOM, player instanceof EntityPlayerMP ? (EntityPlayerMP)player : null)) {
                stack.func_77964_b(stack.func_77958_k());
            }
            if (destroyBroken && ForgeItem.isBroken(stack)) {
                damager.func_70669_a(stack);
                stack.func_190918_g(1);
                stack.func_77964_b(0);
                if (player != null) {
                    player.func_71029_a(StatList.func_188059_c((Item)stack.func_77973_b()));
                }
            }
        }
    }

    public static boolean isBroken(ItemStack stack) {
        return stack.func_77984_f() && stack.func_77952_i() >= stack.func_77958_k();
    }

    public static boolean notBroken(ItemStack stack) {
        return !ForgeItem.isBroken(stack);
    }

    public static boolean isRegistered(Item item) {
        return item != null && ForgeRegistries.ITEMS.containsValue((IForgeRegistryEntry)item);
    }

    public static boolean hasNBT(ItemStack stack) {
        return stack != null && stack.func_77942_o();
    }

    public static void ensureHasNBT(ItemStack stack) {
        if (stack != null && !ForgeItem.hasNBT(stack)) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    @Override
    public ForgeMod getMod() {
        return this.mod;
    }

    @Override
    public Map<Object, UnitVariant> getUnitVariants() {
        return this.variants;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onInitClient() {
    }

    @Nullable
    public CreativeTabs func_77640_w() {
        return this.displayOnCreativeTab() ? super.func_77640_w() : null;
    }

    @Override
    public UnitVariant getDefaultVariant() {
        return this.defaultVariant;
    }

    @Override
    public <E extends Enum<E>> void setUnitVariants(Class<E> clazz) {
        this.variants = this.createUnitVariants(clazz);
    }
}

