/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.blocks;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.endertech.minecraft.forge.units.IRelatedUnit;
import com.endertech.minecraft.forge.units.UnitId;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RelatedBlock
extends ForgeBlock
implements IRelatedUnit {
    private final UnitId relatedBlockId;

    public RelatedBlock(ForgeMod mod, UnitConfig config, String name, UnitId relatedBlockId, CreativeTabs tab) {
        super(mod, config, name, RelatedBlock.getDefaultMaterialOr(relatedBlockId.getBlockState().getBlock(), Material.field_151576_e), tab);
        this.relatedBlockId = ForgeConfig.getUnitId(config, this.getUnitCategory(), "relatedBlockId", relatedBlockId, "Id is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUnit name will be automatically converted to ore dictionary name with reverse word order (example: oreIronBlack).\nUse '*' char as meta value to specify all possible values.\nTo define multiple block states, you can use block properties instead of meta. The format is <modId:blockName:[prop1=value1, prop2=value2]>\nAlso you may use just ore dictionary name as full id.\n");
    }

    @Override
    public UnitId getRelatedId() {
        return this.relatedBlockId;
    }

    @Override
    public String getClassRegName() {
        return "";
    }

    public Material func_149688_o(IBlockState state) {
        Block block = this.getRelatedBlock();
        return block != null ? block.func_176223_P().func_185904_a() : super.func_149688_o(state);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        Block relatedBlock = this.getRelatedBlock();
        if (relatedBlock != null) {
            int meta = this.getRelatedId().getMeta();
            try {
                IBlockState relatedState = relatedBlock.func_176203_a(meta);
                return relatedBlock.func_180659_g(relatedState, world, pos);
            }
            catch (Exception e) {
                return relatedBlock.func_180659_g(relatedBlock.func_176223_P(), world, pos);
            }
        }
        return super.func_180659_g(state, world, pos);
    }

    @Nullable
    protected Block getRelatedBlock() {
        Block block = this.getRelatedId().getBlockState().getBlock();
        return block;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        Block relatedBlock = this.getRelatedBlock();
        return relatedBlock != null ? relatedBlock.func_180664_k() : super.func_180664_k();
    }

    public SoundType func_185467_w() {
        Block relatedBlock = this.getRelatedBlock();
        return relatedBlock != null ? relatedBlock.func_185467_w() : super.func_185467_w();
    }

    @Override
    public boolean isReadyToRegister() {
        String modId = this.getRelatedId().getModId();
        boolean isLoaded = Loader.isModLoaded((String)modId);
        return isLoaded;
    }

    @Override
    public void onInit() {
        Block relatedBlock = this.getRelatedBlock();
        if (relatedBlock != null) {
            this.field_149784_t = relatedBlock.func_149750_m(relatedBlock.func_176223_P());
            this.field_149781_w = relatedBlock.func_149638_a(null) * 5.0f;
            this.field_149782_v = relatedBlock.func_176195_g(relatedBlock.func_176223_P(), null, null);
        }
        if (!this.hasVariants()) {
            String name = UnitId.buildRegName(this.getId().getRegName(), IForgeUnit.getClassRegName(this.getClass()));
            this.func_149663_c(name);
        }
        super.onInit();
    }
}

