/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.api;

import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.blocks.BlockState;
import com.endertech.minecraft.forge.configs.ForgeNBT;
import com.endertech.minecraft.forge.regs.IPostInit;
import com.endertech.minecraft.forge.units.IRelatedUnit;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.INBTSerializable;

public interface IEmitter
extends IRelatedUnit,
IPostInit {
    public static final String COMMENT_ACTIVE_STATE_TAG = "Defines the name of the NBT tag that stores info about tile entity active state.\nEmitter is considered active if the return value is greater than 0 or true.\nSet to an empty string if you don't need this function.";
    public static final String COMMENT_IDENTITY_TAG = "This parameter is required only for those blocks that use NBT tags to fully identify themselves.\nThe format is <tagKey>=<value>\nIf the value is a string, it must be enclosed in double quotes. Example: id=\"ic2:generator\"\nLeave this blank if you don't need it.";
    public static final String COMMENT_IS_ENTITY = "Set this to True only if this emitter is not a block or a tile but an entity.";
    public static final String COMMENT_USE_DROPPED_ITEM_META = "If true, the meta data of the dropped item will be used instead of the block state meta.\nThis is usefull when the placed block has other meta than its item.";
    public static final String COMMENT_RELATED_BLOCKS = "Defines a list of blocks which should be considered as part of this multiblock.";

    public String getActiveStateTag();

    public KeyValuePair getIdentityTag();

    public boolean isEntity();

    public boolean useDroppedItemMeta();

    public Set<BlockState> getRelatedBlocks();

    default public boolean isActive(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return this.isActive((INBTSerializable<NBTTagCompound>)tile);
    }

    default public boolean isActive(@Nullable INBTSerializable<NBTTagCompound> nbtSource) {
        String tag = this.getActiveStateTag();
        if (tag == null || tag.isEmpty()) {
            return true;
        }
        if (nbtSource == null) {
            return false;
        }
        NBTTagCompound compound = (NBTTagCompound)nbtSource.serializeNBT();
        ForgeNBT.KeyPathPair pair = ForgeNBT.KeyPathPair.from(tag);
        if ((compound = ForgeNBT.getNestedCompound(compound, pair.path)) != null) {
            int intValue = compound.func_74762_e(pair.key);
            return intValue > 0;
        }
        return false;
    }

    default public boolean isIdentified(@Nullable INBTSerializable<NBTTagCompound> nbtSource) {
        ForgeNBT.KeyPathPair pair;
        KeyValuePair id = this.getIdentityTag();
        if (id == null || id.key.isEmpty()) {
            return true;
        }
        if (nbtSource == null) {
            return false;
        }
        NBTTagCompound compound = (NBTTagCompound)nbtSource.serializeNBT();
        NBTBase tag = ForgeNBT.getTag(compound, pair = ForgeNBT.KeyPathPair.from(id.key));
        if (tag == null) {
            return false;
        }
        if (id.value.isEmpty()) {
            return true;
        }
        return id.value.equals(tag.toString());
    }
}

