/*
 * Decompiled with CFR 0.152.
 */
package com.wags13.tatami.features;

import com.wags13.tatami.base.Feature;
import com.wags13.tatami.features.shojipanels.ShojiPanels;
import com.wags13.tatami.features.tatamimats.TatamiMats;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class FeatureLoader {
    public static List<Class<? extends Feature>> featureClasses = new ArrayList<Class<? extends Feature>>();
    public static Map<Class<? extends Feature>, Feature> featureClassInstanceMap = new HashMap<Class<? extends Feature>, Feature>();

    public static void setup() {
        FeatureLoader.registerFeature(TatamiMats.class);
        FeatureLoader.registerFeature(ShojiPanels.class);
    }

    public static void preInit() {
        FeatureLoader.setup();
        featureClasses.forEach(clazz -> {
            try {
                Feature instance = (Feature)clazz.newInstance();
                featureClassInstanceMap.put((Class<? extends Feature>)clazz, instance);
            }
            catch (Exception e) {
                throw new RuntimeException("Can't initialize module " + clazz, e);
            }
        });
        FeatureLoader.forEachFeature(feature -> feature.preInit());
    }

    private static void forEachFeature(Consumer<Feature> lambda) {
        featureClassInstanceMap.values().forEach(lambda);
    }

    private static void registerFeature(Class<? extends Feature> clazz) {
        if (!featureClasses.contains(clazz)) {
            featureClasses.add(clazz);
        }
    }
}

