/*
 * Decompiled with CFR 0.152.
 */
package lain.lib;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class Retries {
    public static <T> ThrowingAccept<T> fallback(ThrowingAccept<T> action, ThrowingAccept<T> other) {
        return t -> {
            try {
                action.accept(t);
            }
            catch (Throwable throwable) {
                try {
                    other.accept(t);
                }
                catch (Throwable otherThrowable) {
                    throwable.addSuppressed(otherThrowable);
                    throw throwable;
                }
            }
        };
    }

    public static <T, R> ThrowingApply<T, R> fallback(ThrowingApply<T, R> action, ThrowingApply<T, R> other) {
        return t -> {
            try {
                return action.apply(t);
            }
            catch (Throwable throwable) {
                try {
                    return other.apply(t);
                }
                catch (Throwable otherThrowable) {
                    throwable.addSuppressed(otherThrowable);
                    throw throwable;
                }
            }
        };
    }

    public static <T> ThrowingGet<T> fallback(ThrowingGet<T> action, ThrowingGet<T> other) {
        return () -> {
            try {
                return action.get();
            }
            catch (Throwable throwable) {
                try {
                    return other.get();
                }
                catch (Throwable otherThrowable) {
                    throwable.addSuppressed(otherThrowable);
                    throw throwable;
                }
            }
        };
    }

    public static ThrowingRun fallback(ThrowingRun action, ThrowingRun other) {
        return () -> {
            try {
                action.run();
            }
            catch (Throwable throwable) {
                try {
                    other.run();
                }
                catch (Throwable otherThrowable) {
                    throwable.addSuppressed(otherThrowable);
                    throw throwable;
                }
            }
        };
    }

    public static <T> ThrowingTest<T> fallback(ThrowingTest<T> action, ThrowingTest<T> other) {
        return t -> {
            try {
                return action.test(t);
            }
            catch (Throwable throwable) {
                try {
                    return other.test(t);
                }
                catch (Throwable otherThrowable) {
                    throwable.addSuppressed(otherThrowable);
                    throw throwable;
                }
            }
        };
    }

    public static <T> T rethrow(Throwable throwable) {
        return (T)Retries.rethrow0(throwable);
    }

    private static <T extends Throwable, R> R rethrow0(Throwable throwable) throws T {
        throw throwable;
    }

    public static <T> ThrowingAccept<T> retrying(ThrowingAccept<T> action, Predicate<Throwable> shouldRetry, Consumer<Integer> beforeRetry, int maxRetries) {
        AtomicReference thrown = new AtomicReference();
        AtomicInteger retries = new AtomicInteger();
        return t -> {
            while (true) {
                try {
                    if (thrown.get() != null && beforeRetry != null) {
                        beforeRetry.accept(retries.get());
                    }
                    action.accept(t);
                    return;
                }
                catch (Throwable throwable) {
                    if (thrown.compareAndSet(null, throwable)) continue;
                    ((Throwable)thrown.get()).addSuppressed(throwable);
                    if ((shouldRetry == null || shouldRetry.test(throwable)) && retries.getAndIncrement() != maxRetries) continue;
                    throw (Throwable)thrown.get();
                }
                break;
            }
        };
    }

    public static <T, R> ThrowingApply<T, R> retrying(ThrowingApply<T, R> action, Predicate<Throwable> shouldRetry, Consumer<Integer> beforeRetry, int maxRetries) {
        AtomicReference thrown = new AtomicReference();
        AtomicInteger retries = new AtomicInteger();
        return t -> {
            while (true) {
                try {
                    if (thrown.get() != null && beforeRetry != null) {
                        beforeRetry.accept(retries.get());
                    }
                    return action.apply(t);
                }
                catch (Throwable throwable) {
                    if (thrown.compareAndSet(null, throwable)) continue;
                    ((Throwable)thrown.get()).addSuppressed(throwable);
                    if ((shouldRetry == null || shouldRetry.test(throwable)) && retries.getAndIncrement() != maxRetries) continue;
                    throw (Throwable)thrown.get();
                }
                break;
            }
        };
    }

    public static <T> ThrowingGet<T> retrying(ThrowingGet<T> action, Predicate<Throwable> shouldRetry, Consumer<Integer> beforeRetry, int maxRetries) {
        AtomicReference thrown = new AtomicReference();
        AtomicInteger retries = new AtomicInteger();
        return () -> {
            while (true) {
                try {
                    if (thrown.get() != null && beforeRetry != null) {
                        beforeRetry.accept(retries.get());
                    }
                    return action.get();
                }
                catch (Throwable throwable) {
                    if (thrown.compareAndSet(null, throwable)) continue;
                    ((Throwable)thrown.get()).addSuppressed(throwable);
                    if ((shouldRetry == null || shouldRetry.test(throwable)) && retries.getAndIncrement() != maxRetries) continue;
                    throw (Throwable)thrown.get();
                }
                break;
            }
        };
    }

    public static ThrowingRun retrying(ThrowingRun action, Predicate<Throwable> shouldRetry, Consumer<Integer> beforeRetry, int maxRetries) {
        AtomicReference thrown = new AtomicReference();
        AtomicInteger retries = new AtomicInteger();
        return () -> {
            while (true) {
                try {
                    if (thrown.get() != null && beforeRetry != null) {
                        beforeRetry.accept(retries.get());
                    }
                    action.run();
                    return;
                }
                catch (Throwable throwable) {
                    if (thrown.compareAndSet(null, throwable)) continue;
                    ((Throwable)thrown.get()).addSuppressed(throwable);
                    if ((shouldRetry == null || shouldRetry.test(throwable)) && retries.getAndIncrement() != maxRetries) continue;
                    throw (Throwable)thrown.get();
                }
                break;
            }
        };
    }

    public static <T> ThrowingTest<T> retrying(ThrowingTest<T> action, Predicate<Throwable> shouldRetry, Consumer<Integer> beforeRetry, int maxRetries) {
        AtomicReference thrown = new AtomicReference();
        AtomicInteger retries = new AtomicInteger();
        return t -> {
            while (true) {
                try {
                    if (thrown.get() != null && beforeRetry != null) {
                        beforeRetry.accept(retries.get());
                    }
                    return action.test(t);
                }
                catch (Throwable throwable) {
                    if (thrown.compareAndSet(null, throwable)) continue;
                    ((Throwable)thrown.get()).addSuppressed(throwable);
                    if ((shouldRetry == null || shouldRetry.test(throwable)) && retries.getAndIncrement() != maxRetries) continue;
                    throw (Throwable)thrown.get();
                }
                break;
            }
        };
    }

    private Retries() {
    }

    @FunctionalInterface
    public static interface ThrowingTest<T> {
        public boolean test(T var1) throws Throwable;

        default public Predicate<T> toPredicate() {
            return this.toPredicate(Retries::rethrow);
        }

        default public Predicate<T> toPredicate(Consumer<Throwable> handler) {
            return t -> {
                try {
                    return this.test(t);
                }
                catch (Throwable throwable) {
                    if (handler != null) {
                        handler.accept(throwable);
                    }
                    return false;
                }
            };
        }
    }

    @FunctionalInterface
    public static interface ThrowingRun {
        public void run() throws Throwable;

        default public Runnable toRunnable() {
            return this.toRunnable(Retries::rethrow);
        }

        default public Runnable toRunnable(Consumer<Throwable> handler) {
            return () -> {
                block2: {
                    try {
                        this.run();
                    }
                    catch (Throwable throwable) {
                        if (handler == null) break block2;
                        handler.accept(throwable);
                    }
                }
            };
        }
    }

    @FunctionalInterface
    public static interface ThrowingGet<T> {
        public T get() throws Throwable;

        default public Supplier<T> toSupplier() {
            return this.toSupplier(Retries::rethrow);
        }

        default public Supplier<T> toSupplier(Consumer<Throwable> handler) {
            return () -> {
                try {
                    return this.get();
                }
                catch (Throwable throwable) {
                    if (handler != null) {
                        handler.accept(throwable);
                    }
                    return null;
                }
            };
        }
    }

    @FunctionalInterface
    public static interface ThrowingApply<T, R> {
        public R apply(T var1) throws Throwable;

        default public Function<T, R> toFunction() {
            return this.toFunction(Retries::rethrow);
        }

        default public Function<T, R> toFunction(Consumer<Throwable> handler) {
            return t -> {
                try {
                    return this.apply(t);
                }
                catch (Throwable throwable) {
                    if (handler != null) {
                        handler.accept(throwable);
                    }
                    return null;
                }
            };
        }
    }

    @FunctionalInterface
    public static interface ThrowingAccept<T> {
        public void accept(T var1) throws Throwable;

        default public Consumer<T> toConsumer() {
            return this.toConsumer(Retries::rethrow);
        }

        default public Consumer<T> toConsumer(Consumer<Throwable> handler) {
            return t -> {
                block2: {
                    try {
                        this.accept(t);
                    }
                    catch (Throwable throwable) {
                        if (handler == null) break block2;
                        handler.accept(throwable);
                    }
                }
            };
        }
    }
}

