/*
 * Decompiled with CFR 0.152.
 */
package mezz.modnametooltip;

import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Locale;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Config {
    public static final String CATEGORY_FORMATTING = "formatting";
    private static final String defaultModNameFormatFriendly = "blue italic";
    private final Configuration config;
    private String modNameFormat = Config.parseFriendlyModNameFormat("blue italic");

    public Config(FMLPreInitializationEvent event) {
        File configFile = new File(event.getModConfigurationDirectory(), "modnametooltip.cfg");
        this.config = new Configuration(configFile, "1.0.0");
        this.loadConfig();
    }

    private void loadConfig() {
        EnumSet<TextFormatting> validFormatting = EnumSet.allOf(TextFormatting.class);
        validFormatting.remove(TextFormatting.RESET);
        Object[] validValues = new String[validFormatting.size()];
        int i = 0;
        for (TextFormatting formatting : validFormatting) {
            validValues[i] = formatting.func_96297_d().toLowerCase(Locale.ENGLISH);
            ++i;
        }
        Property prop = this.config.get(CATEGORY_FORMATTING, "modNameFormat", defaultModNameFormatFriendly);
        prop.setLanguageKey("config.modnametooltip.formatting.modNameFormat");
        prop.setComment(I18n.func_135052_a((String)"config.modnametooltip.formatting.modNameFormat.comment", (Object[])new Object[]{Arrays.toString(validValues)}));
        String modNameFormatFriendly = prop.getString();
        this.modNameFormat = Config.parseFriendlyModNameFormat(modNameFormatFriendly);
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public String getModNameFormat() {
        return this.modNameFormat;
    }

    private static String parseFriendlyModNameFormat(String formatWithEnumNames) {
        String[] strings;
        String format = "";
        if (formatWithEnumNames.isEmpty()) {
            return format;
        }
        for (String string : strings = formatWithEnumNames.split(" ")) {
            TextFormatting valueByName = TextFormatting.func_96300_b((String)string);
            if (valueByName != null) {
                format = format + valueByName.toString();
                continue;
            }
            FMLLog.severe((String)("Invalid format: " + string), (Object[])new Object[0]);
        }
        return format;
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if ("modnametooltip".equals(eventArgs.getModID())) {
            this.loadConfig();
        }
    }
}

