/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.network;

import com.google.common.collect.Maps;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.config.PlayerConfigSetting;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.UUID;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class BoolConfigUpdateMessage
implements IMessage {
    private String uuid;
    private String key;
    private boolean value;

    public BoolConfigUpdateMessage() {
    }

    public BoolConfigUpdateMessage(String uuid, String key, boolean value) {
        this.uuid = uuid;
        this.key = key;
        this.value = value;
    }

    public void fromBytes(ByteBuf buf) {
        this.uuid = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.key = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.value = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.uuid);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.key);
        buf.writeBoolean(this.value);
    }

    public static class Handler
    implements IMessageHandler<BoolConfigUpdateMessage, IMessage> {
        public IMessage onMessage(BoolConfigUpdateMessage message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                UUID playerUniqueId;
                try {
                    playerUniqueId = UUID.fromString(message.uuid);
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
                HashMap clientMap = ConfigManager.serverPlayerConfigSettings.get(playerUniqueId);
                if (clientMap == null) {
                    clientMap = Maps.newHashMap();
                }
                clientMap.put(message.key, new PlayerConfigSetting<Boolean>(message.key, message.value, playerUniqueId));
                ConfigManager.serverPlayerConfigSettings.put(playerUniqueId, clientMap);
            }
            return null;
        }
    }
}

